local Illidan = DBM:NewBossMod("Illidan", DBM_ILLIDAN_NAME, DBM_ILLIDAN_DESCRIPTION, DBM_BLACK_TEMPLE, DBM_BT_TAB, 9)

Illidan.Version		= "1.1"
Illidan.Author		= "Tandanu"
Illidan.MinRevision = 734

Illidan:RegisterCombat("YELL", DBM_ILLIDAN_YELL_PULL)

local flameTargets = {}
local flamesDown = 0
local flameBursts = 0
local demonTargets = {}
local phase2
local warnedDemons

Illidan:RegisterEvents(
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE",
	"CHAT_MSG_MONSTER_YELL",
	"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF",
	"CHAT_MSG_COMBAT_HOSTILE_DEATH",
	"CHAT_MSG_SPELL_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE",
	"UNIT_SPELLCAST_START"
)

Illidan:AddOption("RangeCheck", true, DBM_ILLIDAN_OPTION_RANGECHECK)
Illidan:AddOption("WarnPhases", true, DBM_ILLIDAN_OPTION_PHASES)
Illidan:AddOption("WarnShearCast", false, DBM_ILLIDAN_OPTION_SHEARCAST)
Illidan:AddOption("WarnShear", true, DBM_ILLIDAN_OPTION_SHEAR)
Illidan:AddOption("WarnShadowfiend", true, DBM_ILLIDAN_OPTION_SHADOWFIEND)
Illidan:AddOption("IconShadowfiend", true, DBM_ILLIDAN_OPTION_ICONFIEND)
Illidan:AddOption("WarnBarrage", true, DBM_ILLIDAN_OPTION_BARRAGE)
Illidan:AddOption("WarnBarrageSoon", true, DBM_ILLIDAN_OPTION_BARRAGE_SOON)
Illidan:AddOption("WarnEyeBeam", true, DBM_ILLIDAN_OPTION_EYEBEAM)
--Illidan:AddOption("WarnEyeBeamSoon", false, DBM_ILLIDAN_OPTION_EYEBEAMSOON) -- inaccurate!
Illidan:AddOption("WarnFlames", true, DBM_ILLIDAN_OPTION_FLAMES)
Illidan:AddOption("WarnDemonForm", true, DBM_ILLIDAN_OPTION_DEMONFORM)
Illidan:AddOption("WarnFlameBursts", true, DBM_ILLIDAN_OPTION_FLAMEBURST)
Illidan:AddOption("WarnShadowDemons", true, DBM_ILLIDAN_OPTION_SHADOWDEMONS)

function Illidan:OnCombatStart(delay)
	flameTargets = {}
	demonTargets = {}
	flamesDown = 0
	flameBursts = 0
	phase2 = nil
	delay = delay - 7 - 33 -- 7 = time until combat starts and 33 because the timer will stop while illidan is switching from phase 1->2, 2->3 and 3->4; according to my combatlogs this should be quite accurate
	self:StartStatusBarTimer(1500 - delay, "Enrage", "Interface\\Icons\\Spell_Shadow_UnholyFrenzy");	
	self:ScheduleAnnounce(900 - delay, DBM_GENERIC_ENRAGE_WARN:format(10, DBM_MIN), 1)
	self:ScheduleAnnounce(1200 - delay, DBM_GENERIC_ENRAGE_WARN:format(5, DBM_MIN), 1)
	self:ScheduleAnnounce(1320 - delay, DBM_GENERIC_ENRAGE_WARN:format(3, DBM_MIN), 1)
	self:ScheduleAnnounce(1440 - delay, DBM_GENERIC_ENRAGE_WARN:format(1, DBM_MIN), 2)
	self:ScheduleAnnounce(1470 - delay, DBM_GENERIC_ENRAGE_WARN:format(30, DBM_SEC), 3)
	self:ScheduleAnnounce(1490 - delay, DBM_GENERIC_ENRAGE_WARN:format(10, DBM_SEC), 4)
end

function Illidan:OnCombatEnd()
	if self.Options.RangeCheck then
		DBM_Gui_DistanceFrame_Hide()
	end
	phase2 = nil
end

function Illidan:OnEvent(event)
	if event == "CHAT_MSG_MONSTER_YELL" then
		if arg1 == DBM_ILLIDAN_YELL_EYEBEAM then
			self:SendSync("EyeBeam")
		elseif arg1 == DBM_ILLIDAN_YELL_DEMONFORM then
			self:SendSync("DemonForm")
		elseif arg1 == DBM_ILLIDAN_YELL_PHASE4 then
			self:SendSync("Phase4")
		elseif arg1 == DBM_ILLIDAN_YELL_START then
			self:StartStatusBarTimer(36.6, "Illidan", "Interface\\Icons\\INV_Weapon_ShortBlade_07")
		end
	elseif event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" then
		if arg1:find(DBM_ILLIDAN_DEBUFF_SHEAR) then
			local _, _, target, isSelf = arg1:find(DBM_ILLIDAN_DEBUFF_SHEAR)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("Shear"..target)
			end
		elseif arg1:find(DBM_ILLIDAN_DEBUFF_SHADOWFIEND) then
			local _, _, target, isSelf = arg1:find(DBM_ILLIDAN_DEBUFF_SHADOWFIEND)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("Shadowfiend"..target)
			end
		elseif arg1:find(DBM_ILLIDAN_DEBUFF_DARKBARRAGE) then
			local _, _, target, isSelf = arg1:find(DBM_ILLIDAN_DEBUFF_DARKBARRAGE)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("DarkBarrage"..target)
			end
		elseif arg1:find(DBM_ILLIDAN_DEBUFF_FLAMES) then
			local _, _, target, isSelf = arg1:find(DBM_ILLIDAN_DEBUFF_FLAMES)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("Flames"..target)
			end
		elseif arg1:find(DBM_ILLIDAN_DEBUFF_DEMON) and self.InCombat then
			local _, _, target, isSelf = arg1:find(DBM_ILLIDAN_DEBUFF_DEMON)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("ShadowDems"..target)
			end
		end
	elseif event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" then
		if arg1 == DBM_ILLIDAN_CAST_PHASE2 then
			self:SendSync("Phase2")
		elseif arg1 == DBM_ILLIDAN_CAST_SHADOWDEMS then
			self:SendSync("ShadowDemons")
		end
	elseif event == "WarnAF" then
		local msg = ""
		for i, v in ipairs(flameTargets) do
			msg = msg..">"..v.."<, "
		end
		msg = msg:sub(0, -3)
		flameTargets = {}
		if self.Options.WarnFlames then
			self:Announce(DBM_ILLIDAN_WARN_FLAMES:format(msg), 3)
		end
	elseif event == "WarnSD" and not warnedDemons then
		local msg = ""
		for i, v in ipairs(demonTargets) do
			msg = msg..">"..v.."<, "
		end
		msg = msg:sub(0, -3)
		demonTargets = {}
		if self.Options.WarnShadowDemons then
			self:Announce(DBM_ILLIDAN_WARN_SHADOWDEMSON:format(msg), 4)
		end
		warnedDemons = true
	elseif event == "CHAT_MSG_COMBAT_HOSTILE_DEATH" then
		if arg1 == DBM_ILLIDAN_FLAME_DOWN then
			self:SendSync("FlameDown")
		end
	elseif event == "CHAT_MSG_SPELL_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE" then
		if arg1:find(DBM_ILLIDAN_CAST_FLAMEBURST) then
			self:SendSync("Flameburst")
		end
	elseif event == "UNIT_SPELLCAST_START" and arg1 and UnitName(arg1) == DBM_ILLIDAN_NAME then
		if UnitCastingInfo(arg1) == DBM_ILLIDAN_SPELL_SHEAR then
			self:SendSync("CastShear")
		elseif UnitCastingInfo(arg1) == DBM_ILLIDAN_SPELL_SHADOWDEMONS then
			self:SendSync("ShadowDemons")
		end
	end
end

function Illidan:GetBossHP()
	if phase2 then
		return DBM_ILLIDAN_STATUSMSG_PHASE2
	end
end

function Illidan:OnSync(msg)
	if msg:sub(0, 5) == "Shear" then
		msg = msg:sub(6)
		if self.Options.WarnShear then
			self:Announce(DBM_ILLIDAN_WARN_SHEAR:format(msg), 1)
		end
		self:StartStatusBarTimer(7, "Shear: "..msg, "Interface\\Icons\\Spell_Shadow_FocusedPower")
	elseif msg == "CastShear" then
		if self.Options.WarnShearCast then
			self:Announce(DBM_ILLIDAN_WARN_CASTSHEAR, 1)
		end
	elseif msg:sub(0, 11) == "Shadowfiend" then
		msg = msg:sub(12)
		if msg == UnitName("player") then
			self:AddSpecialWarning(DBM_ILLIDAN_SELFWARN_SHADOWFIEND)
		end
		if self.Options.WarnShadowfiend then
			self:Announce(DBM_ILLIDAN_WARN_SHADOWFIEND:format(msg), 2)
		end
		if self.Options.IconShadowfiend then
			self:SetIcon(msg, 10)
		end
		self:StartStatusBarTimer(10, "Shadowfiend: "..msg, "Interface\\Icons\\Spell_Shadow_Shadowfiend")
	elseif msg:sub(0, 11) == "DarkBarrage" then
		msg = msg:sub(12)
		if self.Options.WarnBarrage then
			self:Announce(DBM_ILLIDAN_WARN_BARRAGE:format(msg), 2)
		end
		if self.Options.WarnBarrageSoon then
			self:ScheduleAnnounce(42, DBM_ILLIDAN_WARN_BARRAGE_SOON, 1)
		end
		self:EndStatusBarTimer("Next Dark Barrage") -- synced timers may only overwrite timers that are about to expire - the barrage timer seems to be quite inaccurate...so send a end timer command before.
		self:StartStatusBarTimer(44, "Next Dark Barrage", "Interface\\Icons\\Spell_Shadow_PainSpike")
		self:StartStatusBarTimer(10, "Dark Barrage: "..msg, "Interface\\Icons\\Spell_Shadow_PainSpike")
	elseif msg == "EyeBeam" then
		if self.Options.WarnEyeBeam then
			self:Announce(DBM_ILLIDAN_WARN_EYEBEAM, 3)
		end
--		if self.Options.WarnEyeBeamSoon then -- inaccurate!
--			self:ScheduleAnnounce(32, DBM_ILLIDAN_WARN_EYEBEAM_SOON, 2)
--		end
--		self:StartStatusBarTimer(35, "Next Eye Blast", "Interface\\Icons\\Spell_Shadow_SiphonMana")
	elseif msg:sub(0, 6) == "Flames" then
		msg = msg:sub(7)
		self:StartStatusBarTimer(60, "Flames: "..msg, "Interface\\Icons\\Spell_Fire_BlueImmolation")
		if msg == UnitName("player") then
			self:AddSpecialWarning(DBM_ILLIDAN_SELFWARN_SHADOW)
		end
		table.insert(flameTargets, msg)
		self:UnScheduleEvent("WarnAF")
		self:ScheduleEvent(1, "WarnAF")
	elseif msg == "Phase2" then
		if self.Options.WarnPhases then
			self:Announce(DBM_ILLIDAN_WARN_PHASE2, 4)
		end
		if self.Options.WarnBarrageSoon then
			self:ScheduleAnnounce(76, DBM_ILLIDAN_WARN_BARRAGE_SOON, 1)
		end
		self:StartStatusBarTimer(81, "Next Dark Barrage", "Interface\\Icons\\Spell_Shadow_PainSpike")
		phase2 = true
		flamesDown = 0
	elseif msg == "Phase3" then
		if self.Options.WarnPhases then
			self:Announce(DBM_ILLIDAN_WARN_PHASE3, 4)
		end
		if self.Options.RangeCheck then
			DBM_Gui_DistanceFrame_Show()
		end
		phase2 = nil
		self:StartStatusBarTimer(76, "Demon Phase", "Interface\\Icons\\Spell_Shadow_Metamorphosis")
		if self.Options.WarnDemonForm then
			self:ScheduleAnnounce(66, DBM_ILLIDAN_WARN_DEMONPHASE_SOON, 3)
		end
		self:EndStatusBarTimer("Next Dark Barrage")
		self:UnScheduleAnnounce(DBM_ILLIDAN_WARN_BARRAGE_SOON, 1)
	elseif msg == "Phase4" then
		if self.Options.WarnPhases then
			self:Announce(DBM_ILLIDAN_WARN_PHASE4, 4)
		end
		self:EndStatusBarTimer("Demon Phase")
		self:EndStatusBarTimer("Normal Phase")
		self:UnScheduleAnnounce(DBM_ILLIDAN_WARN_DEMONPHASE_SOON)
		self:UnScheduleAnnounce(DBM_ILLIDAN_WARN_NORMALPHASE_SOON)
		self:StartStatusBarTimer(92, "Demon Phase", "Interface\\Icons\\Spell_Shadow_Metamorphosis")
		if self.Options.WarnDemonForm then
			self:ScheduleAnnounce(82, DBM_ILLIDAN_WARN_DEMONPHASE_SOON, 3)
		end
	elseif msg == "DemonForm" then
		flameBursts = 0
		if self.Options.WarnDemonForm then
			self:Announce(DBM_ILLIDAN_WARN_PHASE_DEMON, 4)
		end
		self:StartStatusBarTimer(74, "Normal Phase", "Interface\\Icons\\INV_Weapon_ShortBlade_07")
		self:StartStatusBarTimer(34, "Shadow Demons", "Interface\\Icons\\Spell_Shadow_SoulLeech_3")
		self:StartStatusBarTimer(20, "Next Flame Burst", "Interface\\Icons\\Spell_Fire_BlueRainOfFire")
		if self.Options.WarnDemonForm then
			self:ScheduleAnnounce(64, DBM_ILLIDAN_WARN_NORMALPHASE_SOON, 2)
		end
		if self.Options.WarnShadowDemons then
			self:ScheduleAnnounce(29, DBM_ILLIDAN_WARN_SHADOWDEMSSOON, 2)
		end
		if self.Options.WarnFlameBursts then
			self:ScheduleAnnounce(15, DBM_ILLIDAN_WARN_FLAMEBURST_SOON, 1)
		end
		self:ScheduleMethod(74, "SendSync", "NormalForm")
		warnedDemons = nil
	elseif msg == "NormalForm" then
		if self.Options.WarnDemonForm then
			self:Announce(DBM_ILLIDAN_WARN_PHASE_NORMAL, 4)
		end
		self:StartStatusBarTimer(60, "Demon Phase", "Interface\\Icons\\Spell_Shadow_Metamorphosis")
		if self.Options.WarnDemonForm then
			self:ScheduleAnnounce(50, DBM_ILLIDAN_WARN_DEMONPHASE_SOON, 3)
		end
	elseif msg == "FlameDown" then
		flamesDown = flamesDown + 1
		if flamesDown >= 2 then
			self:SendSync("Phase3")
		end
	elseif msg == "Flameburst" then
		flameBursts = flameBursts + 1
		if flameBursts < 3 then
			self:StartStatusBarTimer(19.5, "Next Flame Burst", "Interface\\Icons\\Spell_Fire_BlueRainOfFire")
			if self.Options.WarnFlameBursts then
				self:ScheduleAnnounce(14.5, DBM_ILLIDAN_WARN_FLAMEBURST_SOON, 1)
			end
		end
		if self.Options.WarnFlameBursts then
			self:Announce(DBM_ILLIDAN_WARN_FLAMEBURST:format(flameBursts), 3)
		end
--[[elseif msg == "ShadowDemons" then
		if self.Options.WarnShadowDemons then
			self:Announce(DBM_ILLIDAN_WARN_SHADOWDEMS, 4)
		end]]--
	elseif msg:sub(0, 10) == "ShadowDems" then
		msg = msg:sub(11)
		if msg == UnitName("player") then
			self:AddSpecialWarning(DBM_ILLIDAN_SELFWARN_DEMONS)
		end
		table.insert(demonTargets, msg)
		self:UnScheduleEvent("WarnSD")
		if #demonTargets == 4 then
			self:OnEvent("WarnSD")
		else
			self:ScheduleEvent(1, "WarnSD")
		end
	end
end
