local Council = DBM:NewBossMod("Council", DBM_COUNCIL_NAME, DBM_COUNCIL_DESCRIPTION, DBM_BLACK_TEMPLE, DBM_BT_TAB, 8)

Council.Version		= "1.0"
Council.Author		= "Tandanu"

Council:RegisterCombat("YELL", {DBM_COUNCIL_YELL_PULL1, DBM_COUNCIL_YELL_PULL2, DBM_COUNCIL_YELL_PULL3, DBM_COUNCIL_YELL_PULL4}, DBM_COUNCIL_MOB_GATHIOS, DBM_COUNCIL_NAME, DBM_COUNCIL_MOB_GATHIOS);

Council:AddOption("WarnCoH", true, DBM_COUNCIL_OPTION_COH)
Council:AddOption("WarnDP", true, DBM_COUNCIL_OPTION_DP)
Council:AddOption("WarnDW", false, DBM_COUNCIL_OPTION_DW)
Council:AddOption("WarnVanish", true, DBM_COUNCIL_OPTION_VANISH)
Council:AddOption("WarnVanishFade", true, DBM_COUNCIL_OPTION_VANISHFADED)
Council:AddOption("WarnVanishFadeSoon", true, DBM_COUNCIL_OPTION_VANISHFADESOON)
Council:AddOption("WarnShieldNormal", true, DBM_COUNCIL_OPTION_SN)
Council:AddOption("WarnShieldSpell", true, DBM_COUNCIL_OPTION_SS)
Council:AddOption("WarnShieldMelee", true, DBM_COUNCIL_OPTION_SM)
Council:AddOption("WarnDevAura", true, DBM_COUNCIL_OPTION_DEVAURA)
Council:AddOption("WarnResAura", true, DBM_COUNCIL_OPTION_RESAURA)

Council:RegisterEvents(
	"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF",
	"CHAT_MSG_SPELL_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE",
	"CHAT_MSG_SPELL_AURA_GONE_OTHER",
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS"
);

function Council:OnCombatStart(delay)
	self:StartStatusBarTimer(900 - delay, "Enrage", "Interface\\Icons\\Spell_Shadow_UnholyFrenzy");	
	self:ScheduleAnnounce(300 - delay, DBM_GENERIC_ENRAGE_WARN:format(10, DBM_MIN), 1)
	self:ScheduleAnnounce(600 - delay, DBM_GENERIC_ENRAGE_WARN:format(5, DBM_MIN), 1)
	self:ScheduleAnnounce(720 - delay, DBM_GENERIC_ENRAGE_WARN:format(3, DBM_MIN), 1)
	self:ScheduleAnnounce(840 - delay, DBM_GENERIC_ENRAGE_WARN:format(1, DBM_MIN), 2)
	self:ScheduleAnnounce(870 - delay, DBM_GENERIC_ENRAGE_WARN:format(30, DBM_SEC), 3)
	self:ScheduleAnnounce(890 - delay, DBM_GENERIC_ENRAGE_WARN:format(10, DBM_SEC), 4)
end

function Council:OnEvent(event)
	if event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" then
		if arg1 == DBM_COUNCIL_CAST_COH then
			self:SendSync("CoHCast")
		elseif arg1:find(DBM_COUNCIL_HEAL_COH) then
			self:SendSync("CoHHeal")
		end
	elseif event == "CHAT_MSG_SPELL_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE" then
		if arg1:find(DBM_COUNCIL_INTERRUPT_COH) then
			self:SendSync("CoHInterrupt")
		end
	elseif event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" then
		if arg1:find(DBM_COUNCIL_DEBUFF_POISON) then
			local _, _, target, isSelf = arg1:find(DBM_COUNCIL_DEBUFF_POISON)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("DP"..target)
			end
		elseif arg1:find(DBM_COUNCIL_DEBUFF_WRATH) then
			local _, _, target, isSelf = arg1:find(DBM_COUNCIL_DEBUFF_WRATH)
			if target == DBM_YOU and isSelf == DBM_ARE  then
				target = UnitName("player")
			end
			if target then
				self:SendSync("DW"..target)
			end
		end
	elseif event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" then
		if arg1 == DBM_COUNCIL_FADE_VANISH then
			self:SendSync("FadeVanish")
		end
	elseif event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" then
		if arg1 == DBM_COUNCIL_BUFF_VANISH then
			self:SendSync("Vanish")
		elseif arg1 == DBM_COUNCIL_BUFF_SHIELD then
			self:SendSync("ShieldNormal")
		elseif arg1:find(DBM_COUNCIL_BUFF_DEV_AURA) then
			self:SendSync("DevAura")
		elseif arg1:find(DBM_COUNCIL_BUFF_RES_AURA) then
			self:SendSync("ResAura")
		elseif arg1:find(DBM_COUNCIL_BUFF_SPELLWARD) then
			local _, _, target = arg1:find(DBM_COUNCIL_BUFF_SPELLWARD)
			if target then
				self:SendSync("Spellward"..target)
			end
		elseif arg1:find(DBM_COUNCIL_BUFF_PROTECTION) then
			local _, _, target = arg1:find(DBM_COUNCIL_BUFF_PROTECTION)
			if target then
				self:SendSync("Protection"..target)
			end
		end
	elseif event == "VanishFadeSoon" then
		if self.Options.WarnVanishFadeSoon then
			self:Announce(DBM_COUNCIL_WARN_VANISHFADE_SOON, 3)
		end
	end
end

function Council:OnSync(msg)
	if msg:sub(0, 9) == "Spellward" then
		msg = msg:sub(10)
		if self.Options.WarnShieldSpell then
			self:Announce(DBM_COUNCIL_WARN_SHIELD_SPELL:format(msg), 2)
		end
		self:StartStatusBarTimer(15, "Spell Shield: "..msg, "Interface\\Icons\\Spell_Holy_SealOfRighteousness")
	elseif msg:sub(0, 10) == "Protection" and self.InCombat then
		msg = msg:sub(11)
		if self.Options.WarnShieldMelee then
			self:Announce(DBM_COUNCIL_WARN_SHIELD_MELEE:format(msg), 2)
		end
		self:StartStatusBarTimer(15, "Melee Shield: "..msg, "Interface\\Icons\\Spell_Holy_SealOfProtection")
	elseif msg == "CoHCast" then
		if self.Options.WarnCoH then
			self:Announce(DBM_COUNCIL_WARN_CAST_COH, 4)
		end
		self:StartStatusBarTimer(2.5, "Circle of Healing", "Interface\\Icons\\Spell_Holy_CircleOfRenewal")
	elseif msg == "CoHHeal" then
		self:StartStatusBarTimer(19.5, "Next Circle of Healing", "Interface\\Icons\\Spell_Holy_CircleOfRenewal")
	elseif msg == "CoHInterrupt" then
		self:StartStatusBarTimer(14.5, "Next Circle of Healing", "Interface\\Icons\\Spell_Holy_CircleOfRenewal")
	elseif msg:sub(0, 2) == "DP" and self.InCombat then
		msg = msg:sub(3)
		if self.Options.WarnDP then
			self:Announce(DBM_COUNCIL_WARN_POISON:format(msg), 2)
		end
	elseif msg:sub(0, 2) == "DW" then
		msg = msg:sub(3)
		if self.Options.WarnDW then
			self:Announce(DBM_COUNCIL_WARN_WRATH:format(msg), 1)
		end
	elseif msg == "ShieldNormal" then
		if self.Options.WarnShieldNormal then
			self:Announce(DBM_COUNCIL_WARN_SHIELD_NORMAL, 3)
		end
		self:StartStatusBarTimer(20, "Reflective Shield", "Interface\\Icons\\Spell_Holy_PowerWordShield")

	elseif msg == "Vanish" and self.Options.WarnVanish then
		self:Announce(DBM_COUNCIL_WARN_VANISH, 1)
		self:StartStatusBarTimer(31, "Vanish", "Interface\\Icons\\Ability_Vanish")
		self:ScheduleEvent(26, "VanishFadeSoon")
	elseif msg == "FadeVanish" and self.Options.WarnVanishFade then
		self:Announce(DBM_COUNCIL_WARN_VANISH_FADED, 4)
	elseif msg == "DevAura" then
		if self.Options.WarnDevAura then
			self:Announce(DBM_COUNCIL_WARN_AURA_DEV, 1)
		end
		self:StartStatusBarTimer(30, "Devotion Aura", "Interface\\Icons\\Spell_Holy_SealOfProtection")
	elseif msg == "ResAura" then
		if self.Options.WarnResAura then
			self:Announce(DBM_COUNCIL_WARN_AURA_RES, 1)
		end
		self:StartStatusBarTimer(30, "Resistance Aura", "Interface\\Icons\\Spell_Frost_WizardMark")
	end
end
