local Gorefiend = DBM:NewBossMod("TeronGorefiend", DBM_GOREFIEND_NAME, DBM_GOREFIEND_DESCRIPTION, DBM_BLACK_TEMPLE, DBM_BT_TAB, 4);

Gorefiend.Version		= "1.0";
Gorefiend.Author		= "Tandanu";

Gorefiend:RegisterCombat("YELL", DBM_GOREFIEND_YELL_PULL);

Gorefiend:RegisterEvents(
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE"
);

Gorefiend:AddOption("WarnIncinerate", false, DBM_GOREFIEND_OPTION_INCINERATE);

function Gorefiend:OnEvent(event, arg1)
	if (event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" 
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE") and arg1 then
		local _, _, target, isSelf = arg1:find(DBM_GOREFIEND_DEBUFF_SOD);
		if target == DBM_YOU and isSelf == DBM_ARE then
			target = UnitName("player");
			self:AddSpecialWarning(DBM_GOREFIEND_SPECWARN_SOD);
		end
		if target then
			self:SendSync("SoD"..target);
		end
		target = nil;
		
		_, _, target, isSelf = arg1:find(DBM_GOREFIEND_DEBUFF_INCINERATE);
		if target == DBM_YOU and isSelf == DBM_ARE then
			target = UnitName("player");
		end
		if target then
			self:SendSync("Inc"..target);
		end
	elseif event == "Ghost" and arg1 then
		self:StartStatusBarTimer(60, "Vengeful Spirit: "..tostring(arg1), "Interface\\Icons\\Spell_Shadow_DemonicTactics");
	end
end

function Gorefiend:OnSync(msg)
	if msg:sub(0, 3) == "SoD" then
		msg = msg:sub(4);
		self:Announce(DBM_GOREFIEND_WARN_SOD:format(msg), 3);
		self:StartStatusBarTimer(55, "Shadow of Death: "..msg, "Interface\\Icons\\Spell_Arcane_PrismaticCloak");
		self:ScheduleSelf(55, "Ghost", msg);
	elseif msg:sub(0, 3) == "Inc" then
		msg = msg:sub(4);
		if self.Options.WarnIncinerate then
			self:Announce(DBM_GOREFIEND_WARN_INCINERATE:format(msg), 2);
		end
	end
end