local Azgalor = DBM:NewBossMod("Azgalor", DBM_AZGALOR_NAME, DBM_AZGALOR_DESCRIPTION, DBM_MOUNT_HYJAL, DBM_HYJAL_TAB, 4);

Azgalor.Version	= "1.0";
Azgalor.Author	= "Tandanu";

Azgalor:RegisterCombat("YELL", DBM_AZGALOR_YELL_PULL, nil, nil, nil, 160);

Azgalor:AddOption("WarnSilence", true, DBM_AZGALOR_OPTION_SILENCE);
Azgalor:AddOption("DoomIcon", true, DBM_AZGALOR_OPTION_ICON);

Azgalor:RegisterEvents(
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE"
);

function Azgalor:OnEvent(event, arg1)
	if (event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE") and arg1 then
		local _, _, target, isSelf = arg1:find(DBM_AZGALOR_DEBUFF_DOOM);
		if target == DBM_YOU and isSelf == DBM_ARE then
			target = UnitName("player");
			self:AddSpecialWarning(DBM_AZGALOR_SPECWARN_DOOM_YOU);
		end
		if target then
			self:SendSync("Doom"..target);
		end
		if arg1:find(DBM_AZGALOR_DEBUFF_SILENCE) then
			self:SendSync("Silence");
		end
	elseif event == "SilenceWarn" then
		if self.Options.WarnSilence then
			self:Announce(DBM_AZGALOR_WARN_SILENCESOON, 1);
		end
	end
end

function Azgalor:OnSync(msg)
	if msg:sub(0, 4) == "Doom" then
		msg = msg:sub(5);
		self:Announce(DBM_AZGALOR_WARN_DOOM:format(msg), 4);
		if self.Options.DoomIcon then
			self:SetIcon(msg, 20);
		end
		self:StartStatusBarTimer(20, "Doom: "..msg, "Interface\\Icons\\Spell_Shadow_AuraOfDarkness");
	elseif msg == "Silence" then
		if self.Options.WarnSilence then
			self:Announce(DBM_AZGALOR_WARN_SILENCE, 2);
		end
		self:StartStatusBarTimer(19, "Silence", "Interface\\Icons\\Spell_Holy_Silence");
		self:UnScheduleSelf("SilenceWarn")
		self:ScheduleSelf(16, "SilenceWarn")
	end
end