local BBW = DBM:NewBossMod("BigBadWolf", DBM_BBW_NAME, DBM_BBW_DESCRIPTION, DBM_KARAZHAN, DBM_KARAZHAN_TAB, 5);

BBW.Version			= "1.0";
BBW.Author			= "Tandanu";

BBW:RegisterEvents(
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE",
	
	"CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS"	
);

BBW:RegisterCombat("YELL", DBM_BBW_YELL_1);

BBW:AddOption("FearWarn", true, DBM_BBW_OPTION_1);
BBW:AddOption("Whisper", true, DBM_BBW_OPTION_2);
function BBW:OnEvent(event, arg1)
	if event == "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS" then
		local target;
		
		if arg1 == DBM_BBW_YOU_GAIN then
			target = UnitName("player");
			self:AddSpecialWarning(DBM_BBW_RUN_AWAY);
			
		elseif string.find(arg1, DBM_BBW_GAIN_DEBUFF) then
			_, _, target = string.find(arg1, DBM_BBW_GAIN_DEBUFF);
		end
		
		if type(target) == "string" then
			self:SendSync(target);
		end
		
	elseif event == "RRHSoonWarn" then
		self:Announce(DBM_BBW_RRH_SOON_WARN, 1);
		
	elseif event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" and arg1 then
		if string.find(arg1, DBM_BBW_FEAR_EXP) then
			self:StartStatusBarTimer(23, "Fear", "Interface\\Icons\\Ability_Devour");
			
			if self.Options.FearWarn then
				self:Announce(DBM_BBW_FEAR_WARN, 2);
			end
			
			self:UnScheduleSelf("FearWarning", "soon");
			self:ScheduleSelf(23, "FearWarning", "soon");
		else
			local _, _, target, isSelf = string.find(arg1, DBM_BBW_AFFLICTED_DEBUFF);
			if target == DBM_YOU and isSelf == DBM_ARE then
				target = UnitName("player");
				self:AddSpecialWarning(DBM_BBW_RUN_AWAY);
			end
			if target then
				self:SendSync(target);
			end
		end
		
	elseif event == "ClearIcon" and arg1 then
		DBM.ClearIconByName(arg1);
		
	elseif event == "FearWarning" and arg1 == "soon" and self.Options.FearWarn then
		self:Announce(DBM_BBW_FEAR_SOON, 2);
		
	end
end

function BBW:OnSync(target)
	if target then
		if self.Options.Whisper and self.Options.Announce and DBM.Rank >= 1 then
			self:SendHiddenWhisper(DBM_BBW_RUN_AWAY_WHISP, target);			
		end
		self:EndStatusBarTimer("Next Red Riding Hood");
		self:StartStatusBarTimer(30, "Next Red Riding Hood", "Interface\\Icons\\INV_Helmet_28");
		self:StartStatusBarTimer(20, "Red Riding Hood", "Interface\\Icons\\INV_Helmet_28");
		self:Announce(string.format(DBM_BBW_RRH_WARN, target), 3);
		self:SetIcon(target, 20);
		self:ScheduleSelf(20, "ClearIcon", target);
		self:ScheduleSelf(27, "RRHSoonWarn");
	end
end