local Moroes = DBM:NewBossMod("Moroes", DBM_MOROES_NAME, DBM_MOROES_DESCRIPTION, DBM_KARAZHAN, DBM_KARAZHAN_TAB, 2);

Moroes.Version			= "1.0";
Moroes.Author			= "Tandanu";
Moroes.LastVanish		= 0;

Moroes:RegisterEvents(
	"CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS",
	"CHAT_MSG_SPELL_AURA_GONE_OTHER",
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
);

Moroes:AddOption("VanishWarn", true, DBM_MOROES_OPTION_1);
Moroes:AddOption("VanishWarnFade", true, DBM_MOROES_OPTION_2);
Moroes:AddOption("VanishWarnSoon", true, DBM_MOROES_OPTION_3);
Moroes:AddOption("GarroteWarn", true, DBM_MOROES_OPTION_4);

Moroes:RegisterCombat("YELL", DBM_MOROES_YELL_START);

function Moroes:OnCombatStart(delay)
	self:StartStatusBarTimer(33, "Vanish", "Interface\\Icons\\Ability_Vanish");
	self:ScheduleSelf(33, "SoonWarning");
end

function Moroes:OnEvent(event, arg1)	
	if event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and arg1 == DBM_MOROES_VANISH_GAIN then
		if self.Options.VanishWarn then
			self:Announce(DBM_MOROES_VANISH_WARN, 3);
		end
		self.LastVanish = GetTime();
		
	elseif event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" and arg1 == DBM_MOROES_VANISH_FADES then		
		if self.Options.VanishWarnFade then
			self:Announce(DBM_MOROES_VANISH_FADED, 3);
		end
		self:EndStatusBarTimer("Vanish");
		if (GetTime() - self.LastVanish) < 20 then
			self:StartStatusBarTimer(36.5 - (GetTime() - self.LastVanish), "Vanish", "Interface\\Icons\\Ability_Vanish");
			self:ScheduleSelf(31.5 - (GetTime() - self.LastVanish), "SoonWarning");
		end
	
	elseif event == "SoonWarning" and self.Options.VanishWarnSoon then
		self:Announce(DBM_MOROES_VANISH_SOON, 2);
		
	elseif event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" and arg1 then
		if string.find(arg1, DBM_MOROES_GARROTE) and self.Options.GarroteWarn then
			local _, _, target, isSelf = string.find(arg1, DBM_MOROES_GARROTE);
			if target == DBM_YOU and isSelf == DBM_ARE then
				target = UnitName("player");
			end
			if target then
				self:Announce(string.format(DBM_MOROES_GARROTE_WARN, target), 2);
			end
		end
	end
end
