local Nightbane = DBM:NewBossMod("Nightbane", DBM_NB_NAME, DBM_NB_DESCRIPTION, DBM_KARAZHAN, DBM_KARAZHAN_TAB, 13);
--Edit by Nightkiller@鸨hA(kc10577@ګ;Azael)
Nightbane.Version			= "1.2";
Nightbane.Author			= "Tandanu";
Nightbane.BoneRain			= 0;
Nightbane.LastYell			= 0;
Nightbane.LastSmokeTarget	= nil;

Nightbane:RegisterCombat("YELL", DBM_NB_YELL_PULL);

Nightbane:RegisterEvents(
	"CHAT_MSG_MONSTER_YELL",
	"CHAT_MSG_MONSTER_EMOTE",
	"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE"
);


Nightbane:AddOption("CharredEarth", true, DBM_NB_OPTION_1);
Nightbane:AddOption("Ash", false, DBM_NB_OPTION_2);
Nightbane:AddOption("BoneRain", true, DBM_NB_OPTION_3);
-- Nightbane:AddOption("Icon", true, DBM_NB_OPTION_ICON);
-- Nightbane:AddOption("SmokingBlast", false, DBM_NB_OPTION_4); -- no longer needed since the hotfix/nerf
-- Nightbane:AddOption("SmokingSpecWarn", false, DBM_NB_OPTION_5);

function Nightbane:OnEvent(event, arg1)
	if event == "CHAT_MSG_MONSTER_EMOTE" then
		if arg1 == DBM_NB_EMOTE_PULL then
			self:StartStatusBarTimer(34, "Nightbane", "Interface\\Icons\\Ability_Mount_Undeadhorse");
		end
		
	elseif event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" then
		if arg1 == DBM_NB_CAST_FEAR then
			self:StartStatusBarTimer(31.5, "Next Fear", "Interface\\Icons\\Spell_Shadow_PsychicScream");
			self:StartStatusBarTimer(1.5, "Fear", "Interface\\Icons\\Spell_Shadow_PsychicScream");
			self:Announce(DBM_NB_FEAR_WARN, 3);
			self:ScheduleSelf(31.5, "FearWarn");
		end
		
	elseif event == "FearWarn" then
		self:Announce(DBM_NB_FEAR_SOON_WARN, 2);
		
	elseif event == "CHAT_MSG_MONSTER_YELL" then
		if arg1 == DBM_NB_YELL_AIR then
			self.LastSmokeTarget = nil;
			self:Announce(DBM_NB_AIR_WARN, 1);
			self:ScheduleSelf(47, "DownFIRSTWarn");
			self:ScheduleSelf(54, "DownSECWarn");
			self:StartStatusBarTimer(57, "Air Phase", "Interface\\AddOns\\DBM_API\\Textures\\CryptFiendBurrow");
		elseif (arg1 == DBM_NB_YELL_GROUND or arg1 == DBM_NB_YELL_GROUND2) and ((GetTime() - self.LastYell) > 45) then -- he sometimes yells twice...(but seems to be fixed? not sure)
			self.LastYell = GetTime();
			self:ScheduleSelf(3, "UpdateAirTimer");
		end
	elseif event == "UpdateAirTimer" then --stupid bug in old versions and MinVerToSync does not work with UpdateStatusBarTimer -_-
		self:UpdateStatusBarTimer("Air Phase", 43, 57);
		
	elseif event == "DownFIRSTWarn" then
		self:Announce(DBM_NB_DOWN_WARN, 2);
		
	elseif event == "DownSECWarn" then
		self:Announce(DBM_NB_DOWN_WARN2, 1);
		
	elseif event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" 
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" then
		if self.Options.CharredEarth and arg1 == DBM_NB_EARTH_YOU then
			self:AddSpecialWarning(DBM_NB_EARTH_WARN);
		elseif self.Options.BoneRain and (GetTime() - self.BoneRain) > 60 and string.find(arg1, DBM_NB_CAST_BONES) then
			local _, _, target, isSelf = string.find(arg1, DBM_NB_CAST_BONES);
			if target == DBM_YOU and isSelf == DBM_ARE then
				target = UnitName("player");
			end
			if target then
				self.BoneRain = GetTime();
				self:Announce(DBM_NB_BONES_WARN, 2);
			end
			
		elseif self.Options.Ash and string.find(arg1, DBM_NB_CAST_ASH) then
			local _, _, target, isSelf = string.find(arg1, DBM_NB_CAST_ASH);
			if target == DBM_YOU and isSelf == DBM_ARE then
				target = UnitName("player");
			end
			if target then
				local isRangedClass = false;
				for i = 1, GetNumRaidMembers() do
					local name, _, _, _, _, fileName = GetRaidRosterInfo(i); -- UnitClass would return a localized string (okay, the 2nd return value of UnitClass would yield the same result...)
					if name == target
					and fileName ~= "WARRIOR"
					and fileName ~= "ROGUE" then
						isRangedClass = true;
						break;
					end
				end
				
				if isRangedClass then
					self:Announce(string.format(DBM_NB_ASH_WARN, target), 2);
				end
			end
			
--[[	elseif string.format(arg1, DBM_NB_CAST_SMOKE) then
			local _, _, target, isSelf = string.find(arg1, DBM_NB_CAST_SMOKE);
			
			if target and target ~= self.LastSmokeTarget then
				self.LastSmokeTarget = target;
				
				if target == DBM_YOU and isSelf == DBM_ARE then
					target = UnitName("player");
					if self.Options.SmokingSpecWarn then
						self:AddSpecialWarning(DBM_NB_SMOKE_SPECWARN);
					end
				end
				if self.Options.SmokingBlast then
					self:Announce(string.format(DBM_NB_SMOKE_WARN, target));
				end
			end]]
		end
	end
end