﻿local RaJ = DBM:NewBossMod("RomuloAndJulianne", DBM_RJ_NAME, DBM_RJ_DESCRIPTION, DBM_KARAZHAN, DBM_KARAZHAN_TAB, 6);
--Edit by Nightkiller@日落沼澤(kc10577@巴哈;Azael)
RaJ.Version			= "1.0";
RaJ.Author			= "Tandanu";

RaJ:RegisterEvents(
	"CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS",
	"CHAT_MSG_MONSTER_YELL",
	"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF",
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
);

RaJ:RegisterCombat("COMBAT", 5, DBM_RJ_JULIANNE, DBM_RJ_NAME, {DBM_RJ_ROMULO, DBM_RJ_JULIANNE}, 20);

RaJ:AddOption("WarnHeal", true, DBM_RJ_OPTION_1);
RaJ:AddOption("PosionWarn", true, DBM_RJ_OPTION_2);

function RaJ:OnEvent(event, arg1)
	if event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" then
		if arg1 == DBM_RJ_GAIN_DARING then
			self:Announce(DBM_RJ_DARING_WARN, 2);
		elseif arg1 == DBM_RJ_GAIN_DEVOTION then
			self:Announce(DBM_RJ_DEVOTION_WARN, 2);
		end
	elseif event == "CHAT_MSG_MONSTER_YELL" then
		if arg1 == DBM_RJ_PHASE2_YELL then
			self:ScheduleSelf(3, "SetPhase");
		end
	elseif event == "SetPhase" then
		self.Phase = 2; --needed for combat end detection, because the "xyz dies." event is fired when you kill one of them in phase 1.
	elseif event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" then
		if arg1 == DBM_RJ_CAST_HEAL and self.Options.WarnHeal then
			DBM.Announce(DBM_RJ_HEAL_WARN);
			DBM.StartStatusBarTimer(2, "Heal", "Interface\\Icons\\Spell_Holy_Heal");
		end
	elseif type(arg1) == "string" and string.find(arg1, DBM_RJ_POISON) and self.Options.PosionWarn then
		local _, _, target, isSelf = string.find(arg1, DBM_RJ_POISON);
		if target == DBM_YOU and isSelf == DBM_ARE then
			target = UnitName("player");
		end
		if target then
			self:Announce(string.format(DBM_RJ_POISON_WARN, target), 2);
		end
	end
end

function RaJ:OnCombatStart()
	self.Phase = 0;
end

function RaJ:OnCombatEnd()
	self.Phase = 0;
end
