local Fathomlord = DBM:NewBossMod("Fathomlord", DBM_FATHOMLORD_NAME, DBM_FATHOMLORD_DESCRIPTION, DBM_COILFANG, DBM_SERPENT_TAB, 4);

Fathomlord.Version		= "1.0";
Fathomlord.Author		= "Tandanu";

Fathomlord:RegisterCombat("YELL", DBM_FATHOMLORD_YELL_PULL);

Fathomlord:RegisterEvents(
	"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF"
);

Fathomlord:AddOption("TidalTotem", true, DBM_FATHOMLORD_OPTION_TOTEM_1);
Fathomlord:AddOption("KaraTotem", true, DBM_FATHOMLORD_OPTION_TOTEM_2);
Fathomlord:AddOption("Heal", true, DBM_FATHOMLORD_OPTION_HEAL);


function Fathomlord:OnCombatStart(delay)
	self:StartStatusBarTimer(600 - delay, "Enrage", "Interface\\Icons\\Spell_Shadow_UnholyFrenzy");
end

function Fathomlord:OnEvent(event, arg1)
	if event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" then
		if arg1 == DBM_FATHOMLORD_TIDALVESS_TOTEM then
			self:SendSync("TidalTotem");
		elseif arg1 == DBM_FATHOMLORD_KARATHRESS_TOTEM then
			self:SendSync("KaraTotem");
		elseif arg1 == DBM_FATHOMLORD_CAST_HEAL then
			self:SendSync("Heal");
		end
	end
end

function Fathomlord:OnSync(msg)
	if msg == "TidalTotem" then
		if self.Options.TidalTotem then
			self:Announce(DBM_FATHOMLORD_SFTOTEM1_WARN);
		end
	elseif msg == "KaraTotem" then
		if self.Options.KaraTotem then
			self:Announce(DBM_FATHOMLORD_SFTOTEM2_WARN);
		end
	elseif msg == "Heal" then
		if self.Options.Heal then
			self:Announce(DBM_FATHOMLORD_HEAL_WARN);
		end
		self:StartStatusBarTimer(1, "Healing Wave", "Interface\\Icons\\Spell_Nature_MagicImmunity");
	end
end