local Solarian = DBM:NewBossMod("Solarian", DBM_SOLARIAN_NAME, DBM_SOLARIAN_DESCRIPTION, DBM_TEMPEST_KEEP, DBM_EYE_TAB, 3);

Solarian.Version	= "1.0";
Solarian.Author		= "Tandanu";

local warnPhase = false;

Solarian:RegisterEvents(
	"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF",
	"CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",
	"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE",
	"CHAT_MSG_MONSTER_YELL"
);

Solarian:RegisterCombat("COMBAT");

Solarian:AddOption("WarnWrath", true, DBM_SOLARIAN_OPTION_WARN_WRATH);
Solarian:AddOption("IconWrath", true, DBM_SOLARIAN_OPTION_ICON_WRATH);
Solarian:AddOption("SpecWrath", true, DBM_SOLARIAN_OPTION_SPECWARN_WRATH);
Solarian:AddOption("WhisperWrath", true, DBM_SOLARIAN_OPTION_WHISPER_WRATH);
Solarian:AddOption("WarnPhase", true, DBM_SOLARIAN_OPTION_WARN_PHASE);

function Solarian:OnCombatStart(delay)	
	warnPhase = false;
	self:ScheduleSelf(15, "CheckBack"); -- to prevent bugs if you are using an unsupported client language...
	
	self:StartStatusBarTimer(50 - delay, "Split", "Interface\\Icons\\Spell_Holy_SummonLightwell");
	if self.Options.WarnPhase then
		self:ScheduleSelf(45 - delay, "SplitWarn");
	end
end

function Solarian:OnEvent(event, arg1)
	if event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE"
	or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" and arg1 then
		local _, _, target, isSelf = string.find(arg1, DBM_SOLARIAN_DEBUFF_WRATH);
		if target == DBM_YOU and isSelf == DBM_ARE then
			target = UnitName("player");			
		end
		if target then
			self:SendSync("Wrath"..target);
		end
	elseif event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" then
		if arg1 == DBM_SOLARIAN_CAST_SPLIT then
			self:SendSync("Split");
		end
	elseif event == "CHAT_MSG_MONSTER_YELL" and arg1 then
		if string.find(arg1, DBM_SOLARIAN_YELL_ENRAGE) then
			self:Announce(DBM_SOLARIAN_ANNOUNCE_ENRAGE_PHASE, 3);
			warnPhase = false;
			self:EndStatusBarTimer("Split");
			self:UnScheduleSelf("SplitWarn");
			self:UnScheduleSelf("CheckBack");
		end
	elseif event == "SplitWarn" then
		self:Announce(DBM_SOLARIAN_ANNOUNCE_SPLIT_SOON, 2);
	elseif event == "PriestsWarn" then
		self:Announce(DBM_SOLARIAN_ANNOUNCE_PRIESTS_SOON, 2);
	elseif event == "PriestsNow" then
		self:Announce(DBM_SOLARIAN_ANNOUNCE_PRIESTS_NOW, 3);
	elseif event == "AgentsNow" then
		self:Announce(DBM_SOLARIAN_ANNOUNCE_AGENTS_NOW, 2);
	elseif event == "CheckBack" then
		for i = 1, GetNumRaidMembers() do
			if UnitName("raid"..i.."target") == DBM_SOLARIAN_NAME and UnitAffectingCombat("raid"..i.."target") then -- to prevent false positives after wipes
				warnPhase = true;
				break;
			end
		end
	end
end


function Solarian:OnSync(msg)
	if string.sub(msg, 1, 5) == "Wrath" then
		local target = string.sub(msg, 6);
		if target then
			if target == UnitName("player") and self.Options.SpecWrath then
				self:AddSpecialWarning(DBM_SOLARIAN_SPECWARN_WRATH);
			end
			if self.Options.WarnWrath then
				self:Announce(string.format(DBM_SOLARIAN_ANNOUNCE_WRATH, target), 1);
			end
			if self.Options.IconWrath and DBM.Rank > 0 then
				self:SetIcon(target, 6);
			end
			if self.Options.WhisperWrath then
				self:SendHiddenWhisper(DBM_SOLARIAN_SPECWARN_WRATH, target)
			end
			self:StartStatusBarTimer(6, "Wrath: "..target, "Interface\\Icons\\Spell_Arcane_ArcaneTorrent")
		end
		
	elseif msg == "Split" then
		if self.Options.WarnPhase then
			self:Announce(DBM_SOLARIAN_ANNOUNCE_SPLIT, 3);
			self:ScheduleSelf(6, "AgentsNow");
			self:ScheduleSelf(17, "PriestsWarn");
			self:ScheduleSelf(22, "PriestsNow");
			self:ScheduleSelf(85, "SplitWarn");
		end		
		self:StartStatusBarTimer(90, "Split", "Interface\\Icons\\Spell_Holy_SummonLightwell");
		self:StartStatusBarTimer(22.5, "Priests & Solarian", "Interface\\Icons\\Spell_Holy_Renew");
		self:StartStatusBarTimer(6.5, "Agents", "Interface\\Icons\\Spell_Holy_AuraMastery");
	end
end

function Solarian:OnUpdate(elapsed) -- this can be used to detect the phase if nobody was in range after her teleport
	if self.InCombat then
		local foundIt;
		for i = 1, GetNumRaidMembers() do
			if UnitName("raid"..i.."target") == DBM_SOLARIAN_NAME then
				foundIt = true;
				break;
			end
		end
		if not foundIt and warnPhase then
			self:SendSync("Split");
			warnPhase = false;
			self:ScheduleSelf(45, "CheckBack");
		end
	end
end