﻿-- File to handle all the clock info

function GroupCalendar_ShowAnalogClock()
	GroupCalendarButtonClockBackground:Show();
	GroupCalendarButtonMinuteHand:Show();
	GroupCalendarButtonHourHand:Show();
	
	MCSchedulerLib:ScheduleUniqueRepeatingTask(1, GroupCalendar_UpdateAnalogClock);
end

function GroupCalendar_HideAnalogClock()
	GroupCalendarButtonClockBackground:Hide();
	GroupCalendarButtonMinuteHand:Hide();
	GroupCalendarButtonHourHand:Hide();
	
	MCSchedulerLib:UnscheduleTask(GroupCalendar_UpdateAnalogClock);
end

function GroupCalendar_SetTextureAngle(pTexture, pAngle)
	local	vCosAngle = 0.5 * math.cos(-pAngle);
	local	vSinAngle = 0.5 * math.sin(-pAngle);
	
	local	vTLx = -vCosAngle + vSinAngle;
	local	vTLy = -vSinAngle - vCosAngle;
	
	local	vTRx = vCosAngle + vSinAngle;
	local	vTRy = vSinAngle - vCosAngle;
	
	local	vBLx = -vCosAngle - vSinAngle;
	local	vBLy = -vSinAngle + vCosAngle;
	
	local	vBRx = vCosAngle - vSinAngle;
	local	vBRy = vSinAngle + vCosAngle;
	
	pTexture:SetTexCoord(vTLx + 0.5, vTLy + 0.5, vBLx + 0.5, vBLy + 0.5, vTRx + 0.5, vTRy + 0.5, vBRx + 0.5, vBRy + 0.5);
end

function GroupCalendar_UpdateAnalogClock()
	local	vTime = Calendar_GetCurrentServerTime();
	
	if gGroupCalendar_Settings.ClockMode == "local"
	or (gGroupCalendar_Settings.ClockMode == "auto" and gGroupCalendar_Settings.ShowEventsInLocalTime) then
		vTime = Calendar_GetLocalTimeFromServerTime(vTime);
	end
	
	local	vHour, vMinute = Calendar_ConvertTimeToHM(vTime);
	local	vHourAngle;
	
	vHourAngle = (vHour + vMinute / 60) * 3.1415926535 / 6;
	
	GroupCalendar_SetTextureAngle(GroupCalendarButtonHourHand, vHourAngle);
	GroupCalendar_SetTextureAngle(GroupCalendarButtonMinuteHand, vMinute * 3.1415926535 / 30);
end