﻿GroupCalendarCoolDowns_cCooldownItemInfo =
{
	[15846] = {EventID = "Leatherworking"}, -- Salt Shaker
	[17716] = {EventID = "Snowmaster"}, -- Snowmaster 9000
};
         
function GroupCalendarCoolDowns_CheckItemCooldowns()
	for vBagIndex = 0, NUM_BAG_SLOTS do
		local	vNumBagSlots = GetContainerNumSlots(vBagIndex);
		
		for vBagSlotIndex = 1, vNumBagSlots do
			local	vItemLink = GetContainerItemLink(vBagIndex, vBagSlotIndex);
			
			if vItemLink then
				local	vStartIndex, vEndIndex, vLinkColor, vItemCode, vItemEnchantCode, vUnknownCode1, vUnknownCode2, vUnknownCode3, vUnknownCode4, vItemSubCode, vUnknownCode5, vItemName = strfind(vItemLink, GroupCalendar_cItemLinkFormat);
				
				if vStartIndex then
					vItemCode = tonumber(vItemCode);
					
					local	vCooldownItemInfo = GroupCalendarCoolDowns_cCooldownItemInfo[vItemCode];
					
					if vCooldownItemInfo then
						local vStart, vDuration, vEnable = GetContainerItemCooldown(vBagIndex, vBagSlotIndex);
						
						-- local	texture, itemCount, locked, quality, readable = GetContainerItemInfo(vBagIndex, vBagSlotIndex);
						-- MCDebugLib:TestMessage(vItemName..": "..texture);
						
						if vEnable > 0 then
							vRemainingTime = vDuration - (GetTime() - vStart);
							
							if vRemainingTime > 0 then
								EventDatabase_ScheduleTradeskillCooldownEvent(gGroupCalendar_UserDatabase, vCooldownItemInfo.EventID, vRemainingTime);
							end
						end
					end
				end
			end
		end
	end
end