﻿-- File to handle all the Time info

function GroupCalendarTime_RoundTimeOffsetToNearest30(pOffset)
	local	vNegativeOffset;
	local	vOffset;
	
	if pOffset < 0 then
		vNegativeOffset = true;
		vOffset = -pOffset;
	else
		vNegativeOffset = false;
		vOffset = pOffset;
	end
	
	vOffset = vOffset - (math.fmod(vOffset + 15, 30) - 15);
	
	if vNegativeOffset then
		return -vOffset;
	else
		return vOffset;
	end
end
         
function GroupCalendarTime_CalculateTimeZoneOffset()
	local	vServerTime = Calendar_ConvertHMToTime(GetGameTime());
	local	vLocalDate, vLocalTime = Calendar_GetCurrentLocalDateTime();
	local	vUTCDate, vUTCTime = Calendar_GetCurrentUTCDateTime();
	
	local	vLocalDateTime = vLocalDate * 1440 + vLocalTime;
	local	vUTCDateTime = vUTCDate * 1440 + vUTCTime;
	
	local	vLocalUTCDelta = GroupCalendarTime_RoundTimeOffsetToNearest30(vLocalDateTime - vUTCDateTime);
	local	vLocalServerDelta = GroupCalendarTime_RoundTimeOffsetToNearest30(vLocalTime - vServerTime);
	local	vServerUTCDelta = vLocalUTCDelta - vLocalServerDelta;
	
	if vServerUTCDelta < (-12 * 60) then
		vServerUTCDelta = vServerUTCDelta + (24 * 60);
	elseif vServerUTCDelta > (12 * 60) then
		vServerUTCDelta = vServerUTCDelta - (24 * 60);
	end
	
	vLocalServerDelta = vLocalUTCDelta - vServerUTCDelta;
	
	if vLocalServerDelta ~= gGroupCalendar_ServerTimeZoneOffset then
		gGroupCalendar_ServerTimeZoneOffset = vLocalServerDelta;
		
		-- Time zone changed
		
		if gGroupCalendar_ServerTimeZoneOffset == 0 then
			GroupCalendarUseServerTime:Hide();
		else
			GroupCalendarUseServerTime:Show();
		end
	end
end

function GroupCalendarTime_UpdateTimeTooltip()
	local	vServerTime = Calendar_ConvertHMToTime(GetGameTime());
	local	vLocalDate = Calendar_GetCurrentLocalDate();
	
	local	vServerTimeString = Calendar_GetShortTimeString(vServerTime);
	local	vLocalDateString = Calendar_GetLongDateString(vLocalDate, true);

	GameTooltip:AddLine(vLocalDateString);
	GameTooltip:AddLine(vServerTimeString);
	
	if gGroupCalendar_ServerTimeZoneOffset ~= 0 then
		local	vLocalTime = Calendar_GetLocalTimeFromServerTime(vServerTime);
		local	vLocalTimeString = Calendar_GetShortTimeString(vLocalTime);
		
		GameTooltip:AddLine(string.format(GroupCalendar_cLocalTimeNote, vLocalTimeString));
	end
	
	GameTooltip:Show();
end


function GroupCalendarTime_SetUseServerDateTime(pUseServerDateTime)
	gGroupCalendar_Settings.ShowEventsInLocalTime = not pUseServerDateTime;
	
	GroupCalendarUseServerTime:SetChecked(pUseServerDateTime);
	
	GroupCalendar_MajorDatabaseChange(nil); -- Force the display to update
end

function GroupCalendarTime_SetMondayWeek()
	Calendar_SetStartWeekOnMonday(true);
end

function GroupCalendarTime_SetSundayWeek()
	Calendar_SetStartWeekOnMonday(nil);
end

function GroupCalendarTime_Set12Hour()
	gGroupCalendar_Settings.TwentyFourHourTime = false;
	TwentyFourHourTime = nil;
end

function GroupCalendarTime_Set24Hour()
	gGroupCalendar_Settings.TwentyFourHourTime = true;
	TwentyFourHourTime = 1;
end



function GroupCalendarTime_ShowAnalogClock()
	GroupCalendarButtonClockBackground:Show();
	GroupCalendarButtonMinuteHand:Show();
	GroupCalendarButtonHourHand:Show();
	
	MCSchedulerLib:ScheduleUniqueRepeatingTask(1, GroupCalendarTime_UpdateAnalogClock);
end

function GroupCalendarTime_HideAnalogClock()
	GroupCalendarButtonClockBackground:Hide();
	GroupCalendarButtonMinuteHand:Hide();
	GroupCalendarButtonHourHand:Hide();
	
	MCSchedulerLib:UnscheduleTask(GroupCalendarTime_UpdateAnalogClock);
end

function GroupCalendarTime_SetTextureAngle(pTexture, pAngle)
	local	vCosAngle = 0.5 * math.cos(-pAngle);
	local	vSinAngle = 0.5 * math.sin(-pAngle);
	
	local	vTLx = -vCosAngle + vSinAngle;
	local	vTLy = -vSinAngle - vCosAngle;
	
	local	vTRx = vCosAngle + vSinAngle;
	local	vTRy = vSinAngle - vCosAngle;
	
	local	vBLx = -vCosAngle - vSinAngle;
	local	vBLy = -vSinAngle + vCosAngle;
	
	local	vBRx = vCosAngle - vSinAngle;
	local	vBRy = vSinAngle + vCosAngle;
	
	pTexture:SetTexCoord(vTLx + 0.5, vTLy + 0.5, vBLx + 0.5, vBLy + 0.5, vTRx + 0.5, vTRy + 0.5, vBRx + 0.5, vBRy + 0.5);
end

function GroupCalendarTime_UpdateAnalogClock()
	local	vTime = Calendar_GetCurrentServerTime();
	
	if gGroupCalendar_Settings.ClockMode == "local"
	or (gGroupCalendar_Settings.ClockMode == "auto" and gGroupCalendar_Settings.ShowEventsInLocalTime) then
		vTime = Calendar_GetLocalTimeFromServerTime(vTime);
	end
	
	local	vHour, vMinute = Calendar_ConvertTimeToHM(vTime);
	local	vHourAngle;
	
	vHourAngle = (vHour + vMinute / 60) * 3.1415926535 / 6;
	
	GroupCalendarTime_SetTextureAngle(GroupCalendarButtonHourHand, vHourAngle);
	GroupCalendarTime_SetTextureAngle(GroupCalendarButtonMinuteHand, vMinute * 3.1415926535 / 30);
end