-- Original implementation by:
-- brotherhobbes@gmail.com
-- Adapted further by Ammo

assert( oRA, "oRA not found!")

------------------------------
--      Are you local?      --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("oRALLoot")

local lootmethods = {
	["Need before greed"] = "needbeforegreed",
	["Free for all"] = "freeforall",
	["Round robin"] = "roundrobin",
	["Master looter"] = "master",
	["Group loot"] = "group",
}

local lootthresholds = {
	["Poor"] = 0,
	["Common"] = 1,
	["Uncommon"] = 2,
	["Rare"] = 3,
	["Epic"] = 4,
	["Legendary"] = 5,
	["Artifact"] = 6,
}

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["lootleader"] = true,
	["loot"] = true,
	["Loot"] = true,
	["Leader/Loot"] = true,
	["Options for loot."] = true,
	["Method"] = true,
	["Threshold"] = true,
	["Set the loot method."] = true,
	["Set the loot threshold."] = true,
	["Free for all"] = true,
	["Round robin"] = true,
	["Master looter"] = true,
	["Group loot"] = true,
    ["Need before greed"] = true,
    ["<method>"] = true,
    ["<threshold>"] = true,
    ["Poor"] = true,
	["Common"] = true,
	["Uncommon"] = true,
	["Rare"] = true,
	["Epic"] = true,
	["Legendary"] = true,
	["Artifact"] = true,
} end )

L:RegisterTranslations("frFR", function() return {
	--["lootleader"] = true,
	--["loot"] = true,
	["Loot"] = "Butin",
	["Leader/Loot"] = "Chef/Butin",
	["Options for loot."] = "Options concernant le butin.",
	["Method"] = "M\195\169thode",
	["Threshold"] = "Seuil",
	["Set the loot method."] = "D\195\169termine la m\195\169thode de distribution du butin.",
	["Set the loot threshold."] = "D\195\169termine le seuil du butin.",
	["Free for all"] = "Acc\195\168s libre",
	["Round robin"] = "Chacun son tour",
	["Master looter"] = "Ma\195\174tre du butin",
	["Group loot"] = "Butin de groupe",
	["Need before greed"] = "Le besoin avant la cupidit\195\169",
	["<method>"] = "<m\195\169thode>",
	["<threshold>"] = "<seuil>",
	["Poor"] = "Camelote",
	["Common"] = "Commun",
	["Uncommon"] = "Inhabituel",
	--["Rare"] = true,
	["Epic"] = "Epique",
	["Legendary"] = "L\195\169gendaire",
	["Artifact"] = "Art\195\169fact",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

oRALLoot = oRA:NewModule(L["lootleader"])
oRALLoot.defaults = {
	method = L["Master looter"],
	threshold = L["Uncommon"],
	master = UnitName("player"),
}
oRALLoot.leader = true
oRALLoot.name = L["Leader/Loot"]
oRALLoot.consoleCmd = L["loot"]
oRALLoot.consoleOptions = {
	type = "group",
	name = L["Loot"],
	desc = L["Options for loot."],
	disabled = function() return not oRA:IsActive() end,
	args = {
		[L["Method"]] = {
			type = "text",
			name = L["Method"], desc = L["Set the loot method."],
			get = function() return oRALLoot.db.profile.method end,
			set = function(v) 
					oRALLoot.db.profile.method = v
					oRALLoot:SetLootMethod()
				  end,
			validate = { L["Free for all"], L["Round robin"], L["Master looter"], L["Group loot"], L["Need before greed"] },
			usage = L["<method>"], 
		},
		[L["Threshold"]] = {
			type = "text",
			name = L["Threshold"], desc = L["Set the loot threshold."],
			get = function() return oRALLoot.db.profile.threshold end,
			set = function(v)
					oRALLoot.db.profile.threshold = v
					oRALLoot:SetLootMethod()
					end,
			validate = { L["Poor"], L["Common"], L["Uncommon"], L["Rare"], L["Epic"], L["Legendary"], L["Artifact"]},
			usage = L["<threshold>"], 
		},
	}
}


------------------------------
--      Initialization      --
------------------------------

function oRALLoot:OnEnable()
	self:SetLootMethod()
end

----------------------
-- Command handlers --
----------------------

function oRALLoot:SetLootMethod()
	if not IsRaidLeader() then return end

	local method = self.db.profile.method
	local threshold = self.db.profile.threshold

	if method and L:HasReverseTranslation( method ) and lootmethods[L:GetReverseTranslation(method)] then
		method = lootmethods[L:GetReverseTranslation(method)]
	else
		method = self.defaults.method
		method = lootmethods[L:GetReverseTranslation(method)]
	end
	
	if threshold and L:HasReverseTranslation( threshold ) and lootthresholds[L:GetReverseTranslation(threshold)] then
		threshold = lootthresholds[L:GetReverseTranslation(threshold)]
	else
		threshold = self.defaults.threshold
		threshold = lootthresholds[L:GetReverseTranslation(threshold)]
	end	
	
	-- SetLootMethod("method"{,"masterPlayer" or ,threshold})
	-- method  "group", "freeforall", "master", "neeedbeforegreed", "roundrobin".
	-- threshold  0 poor  1 common  2 uncommon  3 rare  4 epic  5 legendary  6 artifact    
	
	SetLootMethod(method, self.db.profile.master, threshold)
	if method == "master" or method == "group" then
		self:ScheduleEvent("oralootthreshold", function(threshold) SetLootThreshold(threshold) end, 3, threshold)
	end
end
