﻿assert( oRA, "oRA not found!")

------------------------------
--      Are you local?      --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("oRAOGroup")
local roster = AceLibrary("Roster-2.1")
local playergroup = 0

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["Group"] = true,
	["group"] = true,
	["groupoptional"] = true,
	["Optional/Group"] = true,
	["Options for Group."] = true,
	["%s has joined your group."] = true,
	["%s has left your group."] = true,
	["You have joined group %d."] = true,
	["change"] = true,
	["Group Change"] = true,
	["Notify for group change."] = true,
	["members"] = true,
	["Members Change"] = true,
	["Notify for group members change."] = true,
	["You are now in group %d."] = true,
	["%s has left your group."] = true,
	["%s has joined your group."] = true,
} end )

L:RegisterTranslations("koKR", function() return {
	["Group"] = "파티",
--	["group"] = "파티",
--	["groupoptional"] = "파티 설정",
	["Optional/Group"] = "Optional/Group",
	["Options for Group."] = "파티에 대한 설정입니다.",
	["%s has joined your group."] = "%s|1이;가; 파티에 참가했습니다.",
	["%s has left your group."] = "%s|1이;가; 파티를 떠났습니다.",
	["You have joined group %d."] = "%d 파티에 참가했습니다.",
--	["change"] = "바꾸기",
	["Group Change"] = "파티 변경",
	["Notify for group change."] = "파티 변경 사항을 알립니다.",
--	["members"] = "파티원",
	["Members Change"] = "파티원 변경",
	["Notify for group members change."] = "파티원 변경 사항을 알립니다.",
	["You are now in group %d."] = "현재 %d 파티 내에 있습니다.",
	["%s has left your group."] = "%s|1이;가; 파티를 떠났습니다.",
	["%s has joined your group."] = "%s|1이;가; 파티에 참가했습니다.",
} end )

L:RegisterTranslations("frFR", function() return {
	["Group"] = "Groupe",
	--["group"] = true,
	--["groupoptional"] = true,
	["Optional/Group"] = "Optionnel/Groupe",
	["Options for Group."] = "Options concernant votre groupe.",
	["%s has joined your group."] = "%s a rejoint votre groupe.",
	["%s has left your group."] = "%s a quitt\195\169 votre groupe.",
	["You have joined group %d."] = "Vous avez rejoint le groupe %d.",
	--["change"] = true,
	["Group Change"] = "Changement de groupe",
	["Notify for group change."] = "Vous pr\195\169viens quand vous \195\170tes chang\195\169 de groupe.",
	--["members"] = true,
	["Members Change"] = "Changement de membres",
	["Notify for group members change."] = "Vous pr\195\169viens quand la composition de votre groupe a chang\195\169.",
	["You are now in group %d."] = "Vous \195\170tes maintenant dans le groupe %d.",
	["%s has left your group."] = "%s a quitt\195\169 votre groupe.",
	["%s has joined your group."] = "%s a rejoint votre groupe.",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

oRAOGroup = oRA:NewModule(L["groupoptional"])
oRAOGroup.defaults = {
	change = true,
	members = true,
}
oRAOGroup.optional = true
oRAOGroup.name = L["Optional/Group"]
oRAOGroup.consoleCmd = L["group"]
oRAOGroup.consoleOptions = {
	type = "group",
	desc = L["Options for Group."],
	name = L["Group"],
	disabled = function() return not oRA:IsActive() end,	
	args = {
		[L["change"]] = {
			type = "toggle", name = L["Group Change"],
			desc = L["Notify for group change."],
			get = function() return oRAOGroup.db.profile.change end,
			set = function(v) oRAOGroup.db.profile.change = v end,
		},
		[L["members"]] = {
			type = "toggle", name = L["Members Change"],
			desc = L["Notify for group members change."],
			get = function() return oRAOGroup.db.profile.members end,
			set = function(v) oRAOGroup.db.profile.members = v end,
		},
	}
}

------------------------------
--      Initialization      --
------------------------------

function oRAOGroup:OnEnable()
	local playerunit = roster:GetUnitObjectFromName(UnitName("player"))
	if not playerunit then
		playergroup = 0
	else
		playergroup = playerunit.subgroup or 0
	end
	self:RegisterEvent("RosterLib_UnitChanged")
end

------------------------
--   Event Handlers   --
------------------------

function oRAOGroup:RosterLib_UnitChanged( id, name, class, subgroup, rank, oldname, oldid, oldclass, oldsubgroup, oldrank )
	if subgroup ~= oldsubgroup then
		if UnitName("player") == name and self.db.profile.change then
			playergroup = subgroup
			self:Print( string.format( L["You are now in group %d."], playergroup ) )
		elseif oldsubgroup == playergroup and self.db.profile.members then
			self:Print( string.format( L["%s has left your group."], oldname ) )
		elseif subgroup == playergroup and self.db.profile.members then
			self:Print( string.format( L["%s has joined your group."], name ) )
		end
	end
end
