assert( oRA, "oRA not found!")

------------------------------
--      Are you local?      --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("oRAPCoolDown")
local BS = AceLibrary("Babble-Spell-2.2")

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["cd"] = true,
	["cooldown"] = true,
	["cooldownparticipant"] = true,
	["Options for cooldowns."] = true,
	["Participant/CoolDown"] = true,
} end )


L:RegisterTranslations("frFR", function() return {
	--["cd"] = true,
	--["cooldown"] = true,
	--["cooldownparticipant"] = true,
	["Options for cooldowns."] = "Options concernant les temps de recharge.",
	["Participant/CoolDown"] = "Participant/Temps de recharge",
} end )

L:RegisterTranslations("koKR", function() return {
	["Options for cooldowns."] = "재사용대기시간 설정",
	["Participant/CoolDown"] = "부분/재사용대기시간",
} end )

L:RegisterTranslations("zhCN", function() return {
	["cd"] = "冷却",
	["cooldown"] = "冷却",
	["cooldownparticipant"] = "cooldownparticipant",
	["Options for cooldowns."] = "冷却监视器选项",
	["Participant/CoolDown"] = "Participant/CoolDown",
} end )

L:RegisterTranslations("zhTW", function() return {
	["cd"] = "冷卻",
	["cooldown"] = "冷卻",
	["cooldownparticipant"] = "cooldownparticipant",
	["Options for cooldowns."] = "冷卻監視器選項",
	["Participant/CoolDown"] = "隊員/冷卻",
} end )
----------------------------------
--      Module Declaration      --
----------------------------------

oRAPCoolDown = oRA:NewModule(L["cooldownparticipant"], "AceHook-2.1")
oRAPCoolDown.defaults = {
}
oRAPCoolDown.participant = true
oRAPCoolDown.name = L["Participant/CoolDown"]
-- oRAPCoolDown.consoleCmd = L["cd"]
-- oRAPCoolDown.consoleOptions = {
-- 	type = "group",
-- 	desc = L["Options for cooldowns."],
-- 	args = {
-- 	}
-- }


------------------------------
--      Initialization      --
------------------------------

function oRAPCoolDown:OnEnable()

	local _, c = UnitClass("player")
	if c == "DRUID" or c == "WARLOCK" or c == "PALADIN" then
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	elseif c == "SHAMAN" then
		self:SecureHook("UseSoulstone")
	end
end

function oRAPCoolDown:OnDisable()
	self:UnregisterAllEvents()
	self:UnhookAll()
end


-------------------------------
--      Event Handlers       --
-------------------------------

function oRAPCoolDown:UNIT_SPELLCAST_SUCCEEDED( unit, spell, rank )
	if spell == BS["Rebirth"] then
		self:SendMessage("CD 1 30")
	elseif spell == BS["Soulstone Resurrection"] then
		self:SendMessage("CD 3 30")
	elseif spell == BS["Divine Intervention"] then
		self:SendMessage("CD 4 60", true) -- only oRA2 clients will receive this cooldown I just numbered on.
	end
end

---------------
--   Hooks   --
---------------

function oRAPCoolDown:UseSoulstone()
	local text = HasSoulstone()
	if text and text == BS["Reincarnation"] then
		local cooldown = 60
		for tab = 1, GetNumTalentTabs(), 1 do
			for talent = 1, GetNumTalents(tab), 1 do
				local name, _, _, _, rank = GetTalentInfo(tab, talent)
				if name == BS["Improved Reincarnation"] then
					cooldown = cooldown - (rank*10)
					break
				end
			end
			if cooldown then break end
			self:SendMessage("CD 2 " .. cooldown )
		end
	end
end
