assert( oRA, "oRA not found!")

------------------------------
--      Are you local?      --
------------------------------

local L = AceLibrary("AceLocale-2.2"):new("oRAPResurrection")
local BS = AceLibrary("Babble-Spell-2.2")

local spells = {
	[BS["Rebirth"]] = true,
	[BS["Resurrection"]] = true,
	[BS["Redemption"]] = true,
	[BS["Ancestral Spirit"]] = true,
	[BS["Reincarnation"]] = true,
}

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	["resurrection"] = true,
	["resurrectionparticipant"] = true,
	["Participant/Resurrection"] = true,
	["Options for resurrection."] = true,
	["Toggle"] = true,
	["toggle"] = true,
	["^Corpse of (.+)$"] = true,
} end )

L:RegisterTranslations("koKR", function() return {

	["Participant/Resurrection"] = "부분/부활",
	["Options for resurrection."] = "부활 설정",
	["Toggle"] = "토글",
	["^Corpse of (.+)$"] = "^([^%s]+)의 시체",
} end )

L:RegisterTranslations("zhCN", function() return {
	["resurrection"] = "复活术",
	["resurrectionparticipant"] = "resurrectionparticipant",
	["Participant/Resurrection"] = "Participant/Resurrection",
	["Options for resurrection."] = "复活的选项",
	["Toggle"] = "显示",
	["toggle"] = "显示",
	["^Corpse of (.+)$"] = "^([^%s]+)的尸体",
} end )

L:RegisterTranslations("zhTW", function() return {
	["resurrection"] = "復活",
	["resurrectionparticipant"] = "resurrectionparticipant",
	["Participant/Resurrection"] = "隊員/復活",
	["Options for resurrection."] = "復活選項",
	["Toggle"] = "顯示",
	["toggle"] = "顯示",
	["^Corpse of (.+)$"] = "^(.+)的屍體",
} end )

L:RegisterTranslations("frFR", function() return {
	--["resurrection"] = true,
	--["resurrectionparticipant"] = true,
	["Participant/Resurrection"] = "Participant/R\195\169surrection",
	["Options for resurrection."] = "Options concernant les r\195\169surrections",
	["Toggle"] = "Afficher",
	--["toggle"] = true,
	["^Corpse of (.+)$"] = "^Cadavre de (.+)$",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

oRAPResurrection = oRA:NewModule(L["resurrectionparticipant"], "AceHook-2.1")
oRAPResurrection.defaults = {
}
oRAPResurrection.participant = true
oRAPResurrection.name = L["Participant/Resurrection"]
-- oRAPResurrection.consoleCmd = L["resurrection"]
-- oRAPResurrection.consoleOptions = {
-- 	type = "group",
-- 	desc = L["Options for resurrection."],
-- 	args = {
-- 	}
-- }

------------------------------
--      Initialization      --
------------------------------

function oRAPResurrection:OnEnable()
	self.iscasting = nil
	self.target = nil
	self.enabled = nil
	self:HookAndRegister()
end

function oRAPResurrection:OnDisable()
	self:UnhookAll()
	self:UnregisterAllEvents()
end

------------------------
--   Event Handlers   --
------------------------

function oRAPResurrection:HookAndRegister()
	local c = select(2, UnitClass("player"))
	if c == "DRUID" or c == "PRIEST" or c == "SHAMAN" or c == "PALADIN" then
	
		self:RegisterEvent("UNIT_SPELLCAST_SENT")
		
		self:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED", "SpellStopped")
		self:RegisterEvent("UNIT_SPELLCAST_FAILED", "SpellStopped")
		self:RegisterEvent("UNIT_SPELLCAST_STOP", "SpellStopped")
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED", "SpellStopped")

		self:HookScript(WorldFrame, "OnMouseDown", "WorldFrameOnMouseDown")
	end

	self:Hook(StaticPopupDialogs["DEATH"], "OnShow", function()
			self.hooks[StaticPopupDialogs["DEATH"]].OnShow()
			if HasSoulstone() then self:SendMessage("CANRES") end end, true )

	self:Hook(StaticPopupDialogs["RESURRECT"], "OnShow", function()
			self.hooks[StaticPopupDialogs["RESURRECT"]].OnShow()
			self:SendMessage("RESSED") end, true )

	self:Hook(StaticPopupDialogs["RESURRECT_NO_SICKNESS"], "OnShow", function()
			self.hooks[StaticPopupDialogs["RESURRECT_NO_SICKNESS"]].OnShow()
			self:SendMessage("RESSED") end, true )

	self:Hook(StaticPopupDialogs["RESURRECT_NO_TIMER"], "OnShow", function()
			self.hooks[StaticPopupDialogs["RESURRECT_NO_TIMER"]].OnShow()
			self:SendMessage("RESSED") end, true )

	-- hrmf we can't hook the OnHide's normally, since they are not there. But
	-- blizzard will fire the OnHide if it finds it.
	-- so some more magic to get this working. And be friendly if someone else created
	-- an OnHide already.

	if not StaticPopupDialogs["RESURRECT"].OnHide then
		StaticPopupDialogs["RESURRECT"].OnHide = function() self:SendMessage("NORESSED") end
	else 
		self:Hook(StaticPopupDialogs["RESURRECT"], "OnHide", function()
			self.hooks[StaticPopupDialogs["RESURRECT"]].OnHide()
			self:SendMessage("NORESSED") end, true )
	end
	if not StaticPopupDialogs["RESURRECT_NO_SICKNESS"].OnHide then
		StaticPopupDialogs["RESURRECT_NO_SICKNESS"].OnHide = function() self:SendMessage("NORESSED") end
	else
		self:Hook(StaticPopupDialogs["RESURRECT_NO_SICKNESS"], "OnHide", function()
			self.hooks[StaticPopupDialogs["RESURRECT_NO_SICKNESS"]].OnHide()
			self:SendMessage("NORESSED") end, true )
	end
	if not StaticPopupDialogs["RESURRECT_NO_TIMER"].OnHide then
		StaticPopupDialogs["RESURRECT_NO_TIMER"].OnHide = function() 
			if not StaticPopup_FindVisible("DEATH") then self:SendMessage("NORESSED") end
		end
	else
		self:Hook(StaticPopupDialogs["RESURRECT_NO_TIMER"], "OnHide", function()
			self.hooks[StaticPopupDialogs["RESURRECT_NO_TIMER"]].OnHide()
			if not StaticPopup_FindVisible("DEATH") then self:SendMessage("NORESSED") end end, true )
	end
end

function oRAPResurrection:UNIT_SPELLCAST_SENT(unit, spell, rank, target)
	if not target or target == "" then target = self.target end
	if unit == "player" and spells[spell] and target then
		self.iscasting = true
		self:SendMessage("RES " .. target )
	end
end

function oRAPResurrection:SpellStopped( unit )
	if unit == "player" and self.iscasting then
		self.iscasting = nil
		self.target = nil
		self:SendMessage("RESNO")
	end
end

-------------
--  HOOKS  --
-------------	

function oRAPResurrection:WorldFrameOnMouseDown()
	if GameTooltipTextLeft1:IsVisible() then
		local name = select(3, GameTooltipTextLeft1:GetText():find(L["^Corpse of (.+)$"]))
		if name then
			self.target = name
		end
	end
	self.hooks[WorldFrame]["OnMouseDown"]()
end

