--
-- Trailer01 mod, to support a second trailer
--
-- @author  Zartask (zartask@yahoo.com)
-- @date    28.05.2008
-- @version 0.1
--
-- Thanks to the developer of GIANTS Developer Network for their work
--

Trailer01 = {};

source("data/scripts/vehicles/trailer.lua");

function Trailer01:new(configFile, positionX, offsetY, positionZ, rotationY, customMt)

    if Trailer01_mt == nil then
        Trailer01_mt = Class(Trailer01, Trailer);
    end;

    local mt = customMt;
    if mt == nil then
        mt = Trailer01_mt;
    end;
    local instance = Trailer:new(configFile, positionX, offsetY, positionZ, rotationY, mt);
    local xmlFile = loadXMLFile("TempConfig", configFile);

    instance.attacherVehicle = nil;
    instance.attachedTrailer = nil;

    instance.attacherJointBack = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, "vehicle.attacherJointBack#index"));
    instance.attacherJointBackIndex = 0;

    instance.trailerIsInTipTriggerRange = false;
    instance.trailerInMountRange = nil;

    delete(xmlFile);

    return instance;
end;

function Trailer01:update(dt)
    Trailer.update(self, dt);

    self.trailerIsInTipTriggerRange = self:isTrailerInTipTriggerRange();
    self.trailerInMountRange = self:getTrailerInMountRange();

    if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            if self.trailerIsInTipTriggerRange and self.attachedTrailer ~= nil then
                self.attachedTrailer:toggleTipState();
            elseif self.trailerInMountRange ~= nil and self.trailerInMountRange.attachedTrailer == nil and self.attachedTrailer == nil then
                self.attacherVehicle:playAttachSound();

                self.attachedTrailer = self.trailerInMountRange;
                self.attachedTrailer:onAttach(self);

                local constr = JointConstructor:new();
                constr:setActors(self.rootNode, self.attachedTrailer.rootNode);
                constr:setJointTransforms(self.attacherJointBack, self.attachedTrailer.attacherJoint);
                --constr:setBreakable(40, 40);
                constr:setRotationLimit(0, Utils.degToRad(-10), Utils.degToRad(10));
                constr:setRotationLimit(1, Utils.degToRad(-50), Utils.degToRad(50));
                constr:setRotationLimit(2, Utils.degToRad(-50), Utils.degToRad(50));
                self.attacherJointBackIndex = constr:finalize();
            elseif self.attachedTrailer ~= nil then
                self.attacherVehicle:playAttachSound();

                if self.attacherJointBackIndex ~= 0 then
                    self.attachedTrailer:onDetach();
                    self.attachedTrailer = nil;

                    removeJoint(self.attacherJointBackIndex);
                    self.attacherJointBackIndex = 0;
                end;
            end;
        end;
    end;
end;

function Trailer01:draw()
    Trailer.draw(self);

    if self.attachedTrailer ~= nil then
        self.attachedTrailer:draw();
    end;

    if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered then
        if self.trailerIsInTipTriggerRange and self.attachedTrailer ~= nil then
            g_currentMission:addHelpButtonText("Anhnger auskippen", InputBinding.IMPLEMENT_EXTRA);
        elseif self.trailerInMountRange ~= nil and self.trailerInMountRange.attachedTrailer == nil and self.attachedTrailer == nil then
            g_currentMission:addHelpButtonText("Anhnger ankuppeln", InputBinding.IMPLEMENT_EXTRA);
        end;
    end;
end;

function Trailer01:onAttach(attacherVehicle)
    Trailer.onAttach(self, attacherVehicle);

    self.attacherVehicle = attacherVehicle;
end;

function Trailer01:onDetach()
    Trailer.onDetach(self);

    self.attacherVehicle = nil;
end;

function Trailer01:isTrailerInTipTriggerRange()
    if self.attacherVehicle ~= nil and self.attachedTrailer ~= nil then
        local px, py, pz = getWorldTranslation(self.attachedTrailer.tipReferencePoint);

        for i=1, table.getn(g_currentMission.tipTriggers) do
            local vx, vy, vz = getWorldTranslation(g_currentMission.tipTriggers[i].triggerId);

            if Utils.vector2Length(px-vx, pz-vz) < g_currentMission.tipTriggerRangeThreshold then
                return true;
            end;
        end;
    end;

    return false;

end;

function Trailer01:getTrailerInMountRange()
    if self.attacherVehicle ~= nil and self.attacherJointBack ~= nil then
        local px, py, pz = getWorldTranslation(self.attacherJointBack);
        local nearestVehicle = nil;
        local nearestDistance = 0.4;

        for i=1, table.getn(g_currentMission.trailers) do
            local vx, vy, vz = getWorldTranslation(g_currentMission.trailers[i].attacherJoint);
            local distance = Utils.vector2Length(px-vx, pz-vz);

            if distance < nearestDistance then
                nearestVehicle = g_currentMission.trailers[i];
                nearestDistance = distance;
            end;
        end;
        return nearestVehicle;
    end;
    return nil;
end;
