; ***************************************************************************
; *                                                                         *
; *    Macro-gyjtemny (M_MACRO.INC)                     verzi : 0.10    *
; *    ==============================                                       *
; *    Kszitette: Mik Imre                                                *
; *                H-2886 RDE, Szchenyi ut 5.                             *
; *                Tel: (00 36) 34 374-215                                  *
; *                                                                         *
; ***************************************************************************

t       EQU tbyte ptr
q       EQU qword ptr
d       EQU dword ptr
w       EQU word ptr
b       EQU byte ptr
o       EQU offset
s       EQU short

; ---------------------------------------------------------------------------
; Betlts regiszterbe, ha source <> destination                (Bels macro)
; ---------------------------------------------------------------------------
ld      macro dest,source
          ifdif <dest>,<source>
              MOV dest,source
          endif
        endm


; ---------------------------------------------------------------------------
; Offset betlts regiszterbe, ha source <> destination         (Bels macro)
; ---------------------------------------------------------------------------
ldo     macro dest,source
          ifdif <dest>,<source>
              MOV dest,o source
          endif
        endm


; ---------------------------------------------------------------------------
; Billenyzetpuffer trlse
; ---------------------------------------------------------------------------
clr_buff macro
        local vanmeg,egykar
        JMP s egykar
vanmeg: MOV AH,10h                      ;; nem
        INT 16h
egykar: MOV AH,11h                      ;; res a bill. puffer ?
        INT 16h
        JNZ s vanmeg
        endm


; ---------------------------------------------------------------------------
; Kileps a programbl
; ---------------------------------------------------------------------------
exit    macro
        CLR_BUFF
        MOV AX,4C00h
	INT 21h
        endm


; ---------------------------------------------------------------------------
; Vrakozs billentynyomsra
; ---------------------------------------------------------------------------
kbhit   macro
        MOV AH,10h
        INT 16h
        endm


; ---------------------------------------------------------------------------
; CPU osztly megllaptsa
; ---------------------------------------------------------------------------
cpu_detect      macro
         local cpu_86,cpu_286,cpu_386
         PUSHF
         XOR BX,BX
         XOR AX,AX
         PUSH AX
         POPF
         PUSHF
         POP AX
         AND AX, 0F000h
         CMP AX, 0F000h
         JZ s cpu_86
         MOV AX, 0F000h
         PUSH AX
         POPF
         PUSHF
         POP AX
         AND AX, 0F000h
         JZ short cpu_286
cpu_386: INC BX
cpu_286: INC BX
cpu_86:  INC BX
         POPF
         endm


; ---------------------------------------------------------------------------
; Vrakozs n millisecundumig
; ---------------------------------------------------------------------------
delay   macro time
        times = time * 1000 / 976 * 976
        MOV CX,times shr 16
        MOV DX,times and 0FFFFh
        MOV AH,86h
        INT 15h
        endm

; ---------------------------------------------------------------------------
; Randomize (init RND number)
; ---------------------------------------------------------------------------
randomize macro rnd
        PUSH 0
        POP GS
        MOV BX,46Ch
        MOV EBX,GS:[BX]
        MOV rnd,EBX
        endm

; ---------------------------------------------------------------------------
; Random (llvletlenszm genertor)
; ---------------------------------------------------------------------------
random  macro rnd
        MOV EAX,1107030247
        MUL rnd
	ADD EAX,97177
	MOV rnd,EAX
        endm

; ---------------------------------------------------------------------------
; File megnyitsa
; ---------------------------------------------------------------------------
open    macro fname,handle,mode
        MOV AH,3Dh
        LD AL,mode
        LDO DX,fname
        INT 21h
        LD handle,AX
        endm

; ---------------------------------------------------------------------------
; File ltrehozsa
; ---------------------------------------------------------------------------
create  macro fname,handle,attrib
        MOV AH,3Ch
        LD CX,attrib
        LDO DX,fname
        INT 21h
        LD handle,AX
        endm

; ---------------------------------------------------------------------------
; File lezrsa
; ---------------------------------------------------------------------------
close   macro handl
        MOV AH,3Eh
        LD BX,handl
        INT 21h
        endm


; ---------------------------------------------------------------------------
; Olvass filebl
; ---------------------------------------------------------------------------
read    macro handl,numbyte,point
        MOV AH,3Fh
        LD BX,handl
        LD CX,numbyte
        PUSH DS
        LDS DX,d point
        INT 21h
        POP DS
        endm


readn   macro handl,numbyte,ofset
        MOV AH,3Fh
        LD BX,handl
        LD CX,numbyte
        LDO DX,ofset
        INT 21h
        endm


; ---------------------------------------------------------------------------
; Irs fileba
; ---------------------------------------------------------------------------
write   macro handl,numbyte,point
	MOV AH,40h
	LD BX,handl
	LD CX,numbyte
	PUSH DS
	LDS DX,d point
	INT 21h
	POP DS
        endm


writen  macro handl,numbyte,ofset
	MOV AH,40h
	LD BX,handl
	LD CX,numbyte
	LDO DX,ofset
	INT 21h
        endm


; ---------------------------------------------------------------------------
; Filepointer mozgatsa
; ---------------------------------------------------------------------------
seek    macro handl,fw,aw,mode
        LD CX,fw
        LD DX,aw
        MOV AH,42h
        LD AL,mode
        LD BX,handl
        INT 21h
        endm

seekc   macro handl,ofs,mode            ;; konstansal
        MOV CX,ofs / 65536
        MOV DX,ofs mod 65536
        MOV AH,42h
        LD AL,mode
        LD BX,handl
        INT 21h
        endm


; ---------------------------------------------------------------------------
; Szveges zemmd belltsa
; ---------------------------------------------------------------------------
init_text macro column,row,mode
        local cikl,vege,dat480
          ifidn <mode>,<color>
            mode_add = 1
          else
            ifidn <mode>,<bw>
              mode_add = 0
            else
              %out Hiba: Az INIT_TEXT makr md paramtere hibs!
              %out ----- Lehetsges varicik: color , bw
            endif
          endif
          r_ok = 0
          c_ok = 0
          ifidn <column>,<40>           ;; 40 oszlop
            c_ok = 1
            MOV AX,0000h+mode_add
            INT 10h
          endif
          ifidn <column>,<80>           ;; 80 oszlop
            c_ok = 1
            MOV AX,0002h+mode_add
            INT 10h
              ifidn <row>,<30>          ;; 80 oszlop 30 sor
                r_ok = 1
                MOV  DX,03D4h
                MOV  AX,0E11h
                OUT  DX,AX
                MOV  CX,18h
                XOR  AL,AL
                LEA  SI,dat480
             cikl:
                MOV  AH,CS:[SI]
                OUT  DX,AX
                INC  SI
                INC  AL
                LOOP cikl
                MOV  DX,03C2h           ;; clock mode 480
                MOV  AL,0E7h
                OUT  DX,AL
                JMP  s vege
              dat480:
                DB   5Fh,4Fh,50h,82h,55h,81h
                DB   0Bh,3Eh,00h,4Fh,0Dh,0Eh,00h,00h,00h,00h
                DB   0EAh,8Ch,0DFh,28h,1Fh,0E7h,04h,0A3h,0FFh
              vege:
            endif
            ifidn <row>,<34>            ;; 80 oszlop 34 sor
                r_ok = 1
                MOV  AX,1111h
                XOR  DX,DX
                MOV  BX,0800h
                MOV  CX,256
                INT  10h
                MOV  DX,03D4h
                MOV  AX,0E11h
                OUT  DX,AX
                MOV  CX,18h
                XOR  AL,AL
                LEA  SI,dat480
              cikl:
                MOV  AH,CS:[SI]
                OUT  DX,AX
                INC  SI
                INC  AL
                LOOP cikl
                MOV  DX,03C2h           ;; clock mode 480
                MOV  AL,0E7h
                OUT  DX,AL
                JMP  s vege
              dat480:
                DB   5Fh,4Fh,50h,82h,55h,81h
                DB   0Bh,3Eh,00h,04Dh,0Dh,0Eh,00h,00h,00h,00h
                DB   0EAh,8Ch,0DFh,28h,1Fh,0DBh,04h,0A3h,0FFh
              vege:
            endif
            ifidn <row>,<60>            ;; 80 oszlop 60 sor
                r_ok = 1
                MOV  AX,1112h
                XOR  DX,DX
                MOV  BX,0800h
                MOV  CX,256
                INT  10h
                MOV  DX,03D4h
                MOV  AX,0E11h
                OUT  DX,AX
                MOV  CX,18h
                XOR  AL,AL
                LEA  SI,dat480
              cikl:
                MOV  AH,CS:[SI]
                OUT  DX,AX
                INC  SI
                INC  AL
                LOOP cikl
                MOV  DX,03C2h           ;; clock mode 480
                MOV  AL,0E7h
                OUT  DX,AL
                JMP  s vege
              dat480:
                 DB   5Fh,4Fh,50h,82h,55h,81h
                 DB   0Bh,3Eh,00h,047h,0Dh,0Eh,00h,00h,00h,00h
                 DB   0EAh,8Ch,0DFh,28h,1Fh,0E7h,04h,0A3h,0FFh
              vege:
            endif
          endif
          ifidn <row>,<25>                      ;; 25 sor
            r_ok = 1
          endif
          ifidn <row>,<28>                      ;; 28 sor
            r_ok = 1
            XOR BX,BX                   ;; load 8x14 caracter font
            MOV AX,1111h
            INT 10h
          endif
          ifidn <row>,<50>                      ;; 50 sor
            r_ok = 1
            XOR BX,BX                   ;; load 8x8 caracter font
            MOV AX,1112h
            INT 10h
          endif
          if r_ok eq 0
            %out Hiba: Az INIT_TEXT makrnak a sorparamtere helytelen!
            %out ----- A lehetsges rtkek: 25,28,30,34,50,60
            %out ----- (40 oszlopos mdban csak a 25,28, s 50 hasznlhat)
          endif
          if c_ok eq 0
            %out Hiba: Az INIT_TEXT makrnak az oszlopparamtere helytelen!
            %out ----- A lehetsges rtkek: 40,80
          endif
        endm


; ---------------------------------------------------------------------------
; Kurzorpozici vltoztatsa
; ---------------------------------------------------------------------------
gotoxy  macro xpos,ypos                 ;;(A 0. sorszmu lapon)
        MOV AH,02h
        LD DX,256*ypos+xpos
        XOR BH,BH
        INT 10h
        endm

gotoxyn macro xpos,ypos,page            ;;(A page sorszmu lapon)
        MOV AH,02h
        LD DX,256*ypos+xpos
        LD BH,page
        INT 10h
        endm


; ---------------------------------------------------------------------------
; Kurzor ki- s bekapcsolsa
; ---------------------------------------------------------------------------
cursor  macro switch
        oke = 0
        ifidn <switch>,<ON>
          oke = 1
          MOV CX,0D0Eh
        endif
        ifidn <switch>,<OFF>
          oke = 1
          MOV CX,2000h
        endif
        MOV AH,1
        INT 10h
        if oke eq 0
          %out Hiba: Az CURSOR macro paramtere hibs!!!
          %out ----- Lehetsges paramter ON vagy OFF. (Nagybetvel!!!)
        endif
        endm


; ---------------------------------------------------------------------------
; Szveg rsa a kpernyre
; ---------------------------------------------------------------------------
print   macro string
        local after,str
        JMP s after
str:    DB string,'$'
after:  MOV AH,09h
        MOV DX,o str
        INT 21h
        endm

prints  macro cimke
        MOV AH,09h
        LDO DX,cimke
        INT 21h
        endm


; ---------------------------------------------------------------------------
; 320x200x256 videmd belltsa
; ---------------------------------------------------------------------------
init_vga macro
       MOV AX,0013h
       INT 10h
       endm


; ---------------------------------------------------------------------------
; Palletta feltltse a videokrtyba
; ---------------------------------------------------------------------------
loadpal macro pal,start,num
        LD AL,start
        LD CX,num*3
        LDO SI,pal
        MOV DX,3C8h
        OUT DX,AL
        INC DX
	CLD
        REP OUTSB
        endm


; ---------------------------------------------------------------------------
; Palletta regiszterek trlse
; ---------------------------------------------------------------------------
clrpal  macro start,num
        local clr
        LD AL,start
        LD CX,num*3
        MOV DX,3C8h
        OUT DX,AL
        INC DX
        XOR AL,AL
clr:    OUT DX,AL
        DEC CX
        JNZ s clr
        endm

; ---------------------------------------------------------------------------
; Show mouse
; ---------------------------------------------------------------------------
show_mouse      macro
        MOV AX,1
        INT 33h
        endm


; ---------------------------------------------------------------------------
; Hide mouse
; ---------------------------------------------------------------------------
hide_mouse      macro
        MOV AX,2
        INT 33h
        endm


; ---------------------------------------------------------------------------
;
; ---------------------------------------------------------------------------
;       macro
;       endm


