/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class FunSnakeCanvas
extends Canvas {
    private int iScreenWidth;
    private int iScreenHeight;
    private int iPlayWidth;
    private int iPlayHeight;
    private int iHeightPercent = 85;
    private int borderLevel = 1;
    private int bordersElem;
    private int[][] borders;
    private int numSnakes;
    private int maxSnakes = this.numSnakes = 2;
    private int numTarget = 1;
    private int[] xPos;
    private int[] yPos;
    private int[] xPosOld;
    private int[] yPosOld;
    private int[] xTPos;
    private int[] yTPos;
    private boolean targetOK = true;
    private boolean gameOverOK = false;
    private boolean fireOK = false;
    private boolean bContinue = false;
    private int elemMove;
    private int[] numRElem;
    private int[] orient;
    private int[] iCurrentTarget;
    private int iEatedTarget;
    private int score = 0;
    private int lives = 3;
    private int iSpeed;
    private int level;
    private int[][][] elemPositions;
    protected Timer snakeTimer;
    protected Timer snakeTimer2;
    private Random rand = new Random(System.currentTimeMillis());
    Image mainImage;
    Graphics mainGraphics;

    public FunSnakeCanvas(int n, int n2, int n3) {
        this.xTPos = new int[this.numTarget];
        this.yTPos = new int[this.numTarget];
        this.iCurrentTarget = new int[this.numTarget];
        this.xPos = new int[this.numSnakes];
        this.yPos = new int[this.numSnakes];
        this.xPosOld = new int[this.numSnakes];
        this.yPosOld = new int[this.numSnakes];
        this.numRElem = new int[this.numSnakes];
        this.orient = new int[this.numSnakes];
        this.elemPositions = new int[this.numSnakes][40][2];
        this.iSpeed = n;
        this.elemMove = n3;
        this.level = n2;
        this.setAll();
    }

    public void setAll() {
        this.setLevel(this.level);
        int n = 0;
        while (n < this.numSnakes) {
            this.numRElem[n] = 2;
            this.orient[n] = 2;
            this.xPosOld[n] = -1;
            this.yPosOld[n] = -1;
            this.xPos[n] = this.elemMove * 5 * 2;
            this.yPos[n] = this.elemMove * 5 * (n + 1);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numTarget) {
            this.xTPos[n2] = this.elemMove * 15;
            this.yTPos[n2] = this.elemMove * 10;
            this.iCurrentTarget[n2] = 1;
            ++n2;
        }
        this.iEatedTarget = 1;
        this.iScreenWidth = this.getWidth();
        this.iScreenHeight = this.getHeight();
        this.iPlayHeight = this.iScreenHeight * this.iHeightPercent / 100;
        this.mainImage = Image.createImage((int)this.iScreenWidth, (int)this.iScreenHeight);
        this.mainGraphics = this.mainImage.getGraphics();
        this.mainGraphics.setColor(255, 255, 255);
        this.mainGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.mainGraphics.setColor(0, 0, 0);
        int n3 = 0;
        while (n3 < this.numSnakes) {
            this.mainGraphics.fillRect(this.xPos[n3], this.yPos[n3], this.elemMove, this.elemMove);
            this.elemPositions[n3][0][0] = this.xPos[n3];
            this.elemPositions[n3][0][1] = this.yPos[n3];
            this.elemPositions[n3][1][0] = this.xPos[n3] + this.elemMove;
            this.elemPositions[n3][1][1] = this.yPos[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.numTarget) {
            this.mainGraphics.fillRect(this.xTPos[n4], this.yTPos[n4], this.elemMove, this.elemMove);
            ++n4;
        }
        this.snakeTimer = new Timer();
        this.snakeTimer.schedule((TimerTask)new BadSnakeTask(), 0L, (long)this.iSpeed);
    }

    public void setLevel(int n) {
        switch (n) {
            case 0: {
                this.bordersElem = 2;
                this.borders = new int[this.bordersElem][2];
                this.borders[1][1] = 0;
                this.borders[1][0] = 0;
                this.borders[0][1] = 0;
                this.borders[0][0] = 0;
                break;
            }
            case 1: {
                this.bordersElem = 10;
                this.borders = new int[this.bordersElem][2];
                int n2 = 0;
                while (n2 < this.bordersElem) {
                    this.borders[n2][0] = n2 * this.elemMove;
                    this.borders[n2][1] = this.elemMove * 10;
                    ++n2;
                }
                break;
            }
            default: {
                this.bordersElem = 2;
                this.borders = new int[this.bordersElem][2];
                this.borders[1][1] = 0;
                this.borders[1][0] = 0;
                this.borders[0][1] = 0;
                this.borders[0][0] = 0;
            }
        }
    }

    public void calculateScore() {
        this.score += 5;
    }

    public int chooseCurrentTarget() {
        int n = -1;
        while (n < 0) {
            n = this.rand.nextInt();
        }
        int n2 = n % 6;
        return n2;
    }

    public void setCurrentTarget(int n, int n2, int n3) {
        String string = "O";
        switch (n) {
            case 1: {
                string = "0";
                break;
            }
            case 2: {
                string = "F";
                break;
            }
            case 3: {
                string = "S";
                break;
            }
            case 4: {
                string = "R";
                break;
            }
            case 5: {
                string = "M";
                break;
            }
            default: {
                string = "I";
            }
        }
        Font font = Font.getFont((int)32, (int)1, (int)8);
        this.mainGraphics.setFont(font);
        this.mainGraphics.drawString(string, n2, n3, 20);
    }

    public boolean checkErrorPos(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = this.iScreenWidth - this.elemMove;
        int n6 = 0;
        int n7 = this.iPlayHeight;
        if (n2 == n4) {
            bl = true;
        }
        if (n2 >= n5) {
            bl = true;
        }
        if (n3 == n6) {
            bl = true;
        }
        if (n3 >= n7) {
            bl = true;
        }
        if (n == 0) {
            int n8 = 0;
            while (n8 < this.numRElem[0] - 1) {
                if (n2 == this.elemPositions[0][n8][0] && n3 == this.elemPositions[0][n8][1]) {
                    bl = true;
                }
                ++n8;
            }
            int n9 = 1;
            while (n9 <= this.numSnakes - 1) {
                int n10 = 0;
                while (n10 < this.numRElem[n9]) {
                    if (n2 == this.elemPositions[n9][n10][0] && n3 == this.elemPositions[n9][n10][1]) {
                        bl = true;
                    }
                    ++n10;
                }
                ++n9;
            }
            int n11 = 0;
            while (n11 < this.bordersElem) {
                if (n2 == this.borders[n11][0] && n3 == this.borders[n11][1]) {
                    bl = true;
                }
                ++n11;
            }
        }
        return bl;
    }

    public boolean checkTargetNewPos(int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        int n4 = this.iScreenWidth - this.elemMove;
        int n5 = 0;
        int n6 = this.iPlayHeight - this.elemMove;
        if (n <= n3 || n >= n4) {
            bl = false;
        }
        if (n2 <= n5 || n2 >= n6) {
            bl = false;
        }
        return bl;
    }

    public void Ca(int n) {
        int n2 = 0 + this.elemMove;
        int n3 = this.iScreenWidth - 2 * this.elemMove;
        int n4 = 0 + this.elemMove;
        int n5 = this.iPlayHeight - this.elemMove;
        int n6 = this.orient[n];
        boolean bl = true;
        if (n != 0) {
            if (this.xPos[n] <= 10) {
                bl = false;
                this.orient[n] = 2;
            }
            if (this.xPos[n] >= 80) {
                bl = false;
                this.orient[n] = 1;
            }
            if (this.yPos[n] <= 10) {
                bl = false;
                this.orient[n] = 4;
            }
            if (this.yPos[n] >= 70) {
                bl = false;
                this.orient[n] = 3;
            }
        }
    }

    public void ActionsOnEatedTarget() {
        switch (this.iEatedTarget) {
            case 1: {
                this.score += 20;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.numSnakes >= this.maxSnakes) break;
                ++this.numSnakes;
                break;
            }
            case 4: {
                if (this.numSnakes < 2) break;
                --this.numSnakes;
                break;
            }
            case 5: {
                this.numRElem[0] = 1;
                break;
            }
        }
    }

    public void calculateElem(int n, int n2) {
        int n3;
        this.xPosOld[n] = this.xPos[n];
        this.yPosOld[n] = this.yPos[n];
        switch (this.orient[n]) {
            case 1: {
                this.xPos[n] = this.xPos[n] - this.elemMove;
                break;
            }
            case 2: {
                this.xPos[n] = this.xPos[n] + this.elemMove;
                break;
            }
            case 3: {
                this.yPos[n] = this.yPos[n] - this.elemMove;
                break;
            }
            case 4: {
                this.yPos[n] = this.yPos[n] + this.elemMove;
            }
        }
        if (this.checkErrorPos(n, this.xPos[n], this.yPos[n])) {
            this.gameOverOK = true;
        }
        if (this.numRElem[0] > 39) {
            this.gameOverOK = true;
        }
        if (this.score > 350) {
            this.gameOverOK = true;
        }
        if (n == 0) {
            n3 = 0;
            while (n3 < this.numTarget) {
                if (this.xPos[0] == this.xTPos[n3] && this.yPos[0] == this.yTPos[n3]) {
                    this.iEatedTarget = this.iCurrentTarget[n3];
                    this.ActionsOnEatedTarget();
                    this.targetOK = false;
                    this.calculateScore();
                    this.numRElem[0] = this.numRElem[0] + 1;
                }
                ++n3;
            }
        }
        this.elemPositions[n][this.numRElem[n] - 1][0] = this.xPos[n];
        this.elemPositions[n][this.numRElem[n] - 1][1] = this.yPos[n];
        n3 = 0;
        while (n3 < this.numRElem[n] - 1) {
            this.elemPositions[n][n3][0] = this.elemPositions[n][n3 + 1][0];
            this.elemPositions[n][n3][1] = this.elemPositions[n][n3 + 1][1];
            ++n3;
        }
    }

    public void drawElem() {
        int n;
        this.mainGraphics.setColor(255, 255, 255);
        this.mainGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.mainGraphics.setColor(0, 0, 0);
        this.mainGraphics.fillRect(0, 0, this.iScreenWidth, this.elemMove);
        this.mainGraphics.fillRect(0, this.iPlayHeight, this.iScreenWidth, 2);
        this.mainGraphics.fillRect(0, 0, this.elemMove, this.iPlayHeight);
        this.mainGraphics.fillRect(this.iScreenWidth - this.elemMove, 0, this.elemMove, this.iPlayHeight);
        Font font = Font.getFont((int)32, (int)1, (int)8);
        this.mainGraphics.setFont(font);
        int n2 = 0;
        while (n2 < this.bordersElem) {
            this.mainGraphics.fillRect(this.borders[n2][0], this.borders[n2][1], this.elemMove, this.elemMove);
            ++n2;
        }
        if (this.gameOverOK) {
            --this.lives;
            this.snakeTimer.cancel();
            if (this.lives == 0) {
                this.mainGraphics.drawString("GAME OVER ", 25, 40, 20);
            }
            if (this.lives > 0) {
                this.gameOverOK = false;
                this.bContinue = true;
                this.mainGraphics.drawString("Press FIRE", 25, 40, 20);
            }
        }
        this.mainGraphics.drawString("L:" + this.level + "  S:" + this.score + "  Lives:" + this.lives, 1, this.iPlayHeight, 20);
        int n3 = 0;
        while (n3 < this.numSnakes) {
            if (n3 != 0) {
                this.mainGraphics.setColor(0, 255, 0);
            }
            n = 0;
            while (n < this.numRElem[0] - 1) {
                this.mainGraphics.fillRoundRect(this.elemPositions[n3][n][0], this.elemPositions[n3][n][1], this.elemMove, this.elemMove, this.elemMove - 1, this.elemMove - 1);
                ++n;
            }
            ++n3;
        }
        if (this.targetOK) {
            this.mainGraphics.setColor(255, 0, 0);
            n = 0;
            while (n < this.numTarget) {
                this.mainGraphics.fillRect(this.xTPos[n], this.yTPos[n], this.elemMove, this.elemMove);
                ++n;
            }
            int n4 = 0;
            while (n4 < this.numTarget) {
                this.setCurrentTarget(this.iCurrentTarget[n4], this.xTPos[n4], this.yTPos[n4]);
                ++n4;
            }
        } else {
            n = 0;
            while (n < this.numTarget) {
                this.iCurrentTarget[n] = this.chooseCurrentTarget();
                do {
                    int n5 = -1;
                    while (n5 < 0) {
                        n5 = this.rand.nextInt();
                    }
                    this.xTPos[n] = n5 % this.iScreenWidth;
                    while (this.xTPos[n] % this.elemMove != 0) {
                        int n6 = n;
                        this.xTPos[n6] = this.xTPos[n6] + 1;
                    }
                    n5 = -1;
                    while (n5 < 0) {
                        n5 = this.rand.nextInt();
                    }
                    this.yTPos[n] = n5 % this.iScreenHeight;
                    while (this.yTPos[n] % this.elemMove != 0) {
                        int n7 = n;
                        this.yTPos[n7] = this.yTPos[n7] + 1;
                    }
                } while (!this.checkTargetNewPos(this.xTPos[n], this.yTPos[n]));
                ++n;
            }
            this.targetOK = true;
        }
        if (this.fireOK && this.iEatedTarget == 2) {
            this.mainGraphics.setColor(0, 0, 0);
            switch (this.orient[0]) {
                case 1: {
                    this.mainGraphics.drawLine(this.xPos[0], this.yPos[0], this.xPos[0] - 10, this.yPos[0]);
                    break;
                }
                case 2: {
                    this.mainGraphics.drawLine(this.xPos[0], this.yPos[0], this.xPos[0] + 10, this.yPos[0]);
                    break;
                }
                case 3: {
                    this.mainGraphics.drawLine(this.xPos[0], this.yPos[0] - 10, this.xPos[0], this.yPos[0]);
                    break;
                }
                case 4: {
                    this.mainGraphics.drawLine(this.xPos[0], this.yPos[0] + 10, this.xPos[0], this.yPos[0]);
                }
            }
            this.fireOK = false;
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.mainImage, 0, 0, 20);
    }

    public void CalculateNext(int n) {
        int n2 = 0;
        while (n2 < this.numSnakes) {
            this.Ca(n2);
            this.calculateElem(n2, n);
            ++n2;
        }
        this.drawElem();
        this.repaint();
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 2: {
                if (this.orient[0] == 2 || this.xPos[0] != this.xPosOld[0]) break;
                this.orient[0] = 1;
                break;
            }
            case 5: {
                if (this.orient[0] == 1 || this.xPos[0] != this.xPosOld[0]) break;
                this.orient[0] = 2;
                break;
            }
            case 1: {
                if (this.orient[0] == 4 || this.yPos[0] != this.yPosOld[0]) break;
                this.orient[0] = 3;
                break;
            }
            case 6: {
                if (this.orient[0] == 3 || this.yPos[0] != this.yPosOld[0]) break;
                this.orient[0] = 4;
                break;
            }
            case 8: {
                this.fireOK = true;
                if (!this.bContinue) break;
                this.setAll();
                this.bContinue = false;
            }
        }
    }

    class BadSnakeTask
    extends TimerTask {
        public void run() {
            FunSnakeCanvas.this.CalculateNext(FunSnakeCanvas.this.orient[0]);
        }
    }
}

