/*
 * Decompiled with CFR 0.152.
 */
package pong;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import pong.PongCourt;

class PongBall {
    static Random random = new Random();
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int posX;
    private int posY;
    private int radius = 2;
    private int diameter = this.radius * 2;
    private int deltaX;
    private int deltaY;
    private int pomozna;
    private PongCourt court;
    private boolean outOfPlay = true;

    PongBall(PongCourt pongCourt, int n, int n2, int n3, int n4) {
        this.court = pongCourt;
        this.minX = n;
        this.minY = n2;
        this.maxX = this.minX + n3 - this.diameter;
        this.maxY = this.minY + n4 - this.diameter;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getStartY() {
        return this.maxY / 2;
    }

    public boolean inPlay() {
        return this.outOfPlay ^ true;
    }

    public void move() {
        if (this.outOfPlay) {
            return;
        }
        if (this.posX <= this.minX && !this.court.isLPaddleHit(this.posY, this.diameter)) {
            this.outOfPlay = true;
            this.court.repaint();
            return;
        }
        if (this.posX >= this.maxX && !this.court.isRPaddleHit(this.posY, this.diameter)) {
            this.outOfPlay = true;
            this.court.repaint();
            return;
        }
        if (this.posX <= this.minX || this.posX >= this.maxX) {
            this.deltaX = -this.deltaX;
            this.deltaY = random.nextInt() & 1;
            if (this.deltaY == 0) {
                this.deltaY = -1;
            }
            this.pomozna = (random.nextInt() & 2) + 1;
        }
        if (this.posY <= this.minY || this.posY >= this.maxY) {
            this.deltaY = -this.deltaY;
        }
        this.posX += this.deltaX;
        if (this.posX - this.posX / this.pomozna * this.pomozna == 0) {
            this.posY += this.deltaY;
        }
    }

    void paint(Graphics graphics) {
        if (this.outOfPlay) {
            return;
        }
        graphics.setColor(255, 255, 255);
        graphics.fillArc(this.posX, this.posY, this.diameter, this.diameter, 0, 360);
    }

    void putInPlay() {
        this.outOfPlay = false;
        this.posX = this.maxX / 2;
        this.posY = this.getStartY();
        this.deltaX = -1;
        this.deltaY = random.nextInt() & 1;
        this.pomozna = (random.nextInt() & 0xA) + 1;
        if (this.deltaY == 0) {
            this.deltaY = -1;
        }
    }

    void takeOutOfPlay() {
        this.outOfPlay = true;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " x = " + this.posX + ", y = " + this.posY;
    }
}

