/*
 * Decompiled with CFR 0.152.
 */
package pong;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import pong.PongBall;
import pong.PongPaddle;

public class PongCourt
extends Canvas
implements CommandListener,
Runnable {
    static Random random = new Random();
    private static final int MAX_BALLS = 10;
    private static final int MAX_DELAY = 100;
    private static final int MIN_DELAY = 0;
    private static final int DEFAULT_DELAY = 30;
    private Command startCommand = new Command("Start", 1, 1);
    private Command stopCommand = new Command("End", 1, 1);
    private Command fasterCommand = new Command("Faster paddle", 1, 101);
    private Command slowerCommand = new Command("Slower paddle", 1, 102);
    private Command moreCommand = new Command("More balls", 1, 103);
    private Command fewerCommand = new Command("Less balls", 1, 104);
    private Command largerCommand = new Command("Bigger paddle", 1, 105);
    private Command smallerCommand = new Command("Smaller paddle", 1, 106);
    private Command slowerBallCommand = new Command("Slower ball", 1, 107);
    private Command fasterBallCommand = new Command("Faster ball", 1, 108);
    private CommandListener commandListener;
    private int delay = 30;
    private int score = 0;
    private int width = this.getWidth();
    private int height = this.getHeight() - Font.getDefaultFont().getHeight();
    private int ballsRequested = 1;
    private int ballsInPlay = 0;
    private boolean stopped = true;
    private boolean paused = true;
    private PongBall[] balls;
    private PongPaddle paddleL;
    private PongPaddle paddleR;

    public PongCourt(Display display) {
        this.initialization();
        this.addCommand(this.startCommand);
        this.addCommand(this.fasterCommand);
        this.addCommand(this.slowerCommand);
        this.addCommand(this.moreCommand);
        this.addCommand(this.fewerCommand);
        this.addCommand(this.largerCommand);
        this.addCommand(this.smallerCommand);
        this.addCommand(this.slowerBallCommand);
        this.addCommand(this.fasterBallCommand);
        super.setCommandListener((CommandListener)this);
    }

    void addBall() {
        if (this.ballsRequested >= this.balls.length) {
            return;
        }
        ++this.ballsRequested;
        if (this.ballsInPlay > 0) {
            int n = 0;
            while (n < this.balls.length) {
                if (!this.balls[n].inPlay()) {
                    this.balls[n].putInPlay();
                    ++this.ballsInPlay;
                    if (this.stopped) {
                        this.repaint();
                    }
                    return;
                }
                ++n;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.startCommand) {
            this.startGame();
            return;
        }
        if (command == this.stopCommand) {
            this.stopGame();
            return;
        }
        if (command == this.fasterCommand) {
            this.speedUpGame();
            return;
        }
        if (command == this.slowerCommand) {
            this.slowDownGame();
            return;
        }
        if (command == this.moreCommand) {
            this.addBall();
            return;
        }
        if (command == this.fewerCommand) {
            this.removeBall();
            return;
        }
        if (command == this.largerCommand) {
            this.paddleL.bigger();
            this.paddleR.bigger();
            this.repaint();
            return;
        }
        if (command == this.smallerCommand) {
            this.paddleL.smaller();
            this.paddleR.smaller();
            this.repaint();
            return;
        }
        if (command == this.slowerBallCommand) {
            this.delay += 10;
            if (this.delay > 100) {
                this.delay = 100;
            }
            return;
        }
        if (command == this.fasterBallCommand) {
            this.delay -= 10;
            if (this.delay < 0) {
                this.delay = 0;
            }
            return;
        }
        if (this.commandListener == null) {
            return;
        }
        this.commandListener.commandAction(command, displayable);
    }

    void destroy() {
        this.pause();
    }

    private void displayScore(Graphics graphics) {
        char[] cArray = new char[3];
        cArray[2] = (char)(this.score % 10 + 48);
        cArray[1] = (char)(this.score / 10 % 10 + 48);
        cArray[0] = (char)(this.score / 100 % 10 + 48);
        graphics.setColor(0, 0, 0);
        graphics.drawString("Score: " + new String(cArray), this.width - 1, this.height, 24);
    }

    protected void hideNotify() {
        this.pause();
    }

    void initialization() {
        this.paddleL = new PongPaddle(0, 1, this.height - 2);
        this.paddleR = new PongPaddle(this.width - 2, 1, this.height - 2);
        this.balls = new PongBall[10];
        int n = 0;
        while (n < this.balls.length) {
            this.balls[n] = new PongBall(this, 2, 1, this.width - 2 - 1, this.height - 2);
            ++n;
        }
        this.ballsInPlay = 1;
        this.balls[0].putInPlay();
        this.delay = 30;
        boolean bl = false;
        this.ballsRequested = 1;
        this.ballsInPlay = 0;
    }

    boolean isLPaddleHit(int n, int n2) {
        if (this.paddleL.isHit(n, n2)) {
            ++this.score;
            return true;
        }
        --this.ballsInPlay;
        if (this.ballsInPlay == 0) {
            this.stopGame();
        }
        return false;
    }

    boolean isRPaddleHit(int n, int n2) {
        if (this.paddleR.isHit(n, n2)) {
            return true;
        }
        --this.ballsInPlay;
        if (this.ballsInPlay == 0) {
            this.stopGame();
        }
        return false;
    }

    public void keyPressed(int n) {
        if (this.stopped) {
            return;
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                this.paddleL.up();
                this.repaint();
                break;
            }
            case 6: {
                this.paddleL.down();
                this.repaint();
            }
        }
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    int movePaddle() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.balls.length) {
            if (this.balls[n3].getDeltaX() == 1 && this.balls[n3].getPosX() > n && this.balls[n3].inPlay()) {
                n = this.balls[n3].getPosX();
                n2 = n3;
            }
            ++n3;
        }
        return this.balls[n2].getPosY();
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(1801248);
        graphics.fillRect(0, 0, this.getWidth(), this.height);
        graphics.setColor(196607);
        graphics.drawLine(0, 0, this.width, 0);
        graphics.drawLine(0, this.height - 1, this.width, this.height - 1);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, this.height, this.getWidth(), this.getHeight());
        this.paddleL.paint(graphics);
        this.paddleR.paint(graphics);
        this.displayScore(graphics);
        int n = 0;
        while (n < this.balls.length) {
            this.balls[n].paint(graphics);
            ++n;
        }
    }

    void pause() {
        this.paused = true;
    }

    void removeBall() {
        if (this.ballsRequested <= 1) {
            return;
        }
        --this.ballsRequested;
        int n = this.balls.length - 1;
        while (n >= 0) {
            if (this.balls[n].inPlay()) {
                this.balls[n].takeOutOfPlay();
                --this.ballsInPlay;
                if (this.stopped) {
                    this.repaint();
                }
                return;
            }
            --n;
        }
    }

    void resetGame() {
        this.score = 0;
        int n = 0;
        while (n < this.ballsRequested) {
            this.balls[n].putInPlay();
            ++this.ballsInPlay;
            ++n;
        }
    }

    public void run() {
        this.paused = false;
        while (!this.paused) {
            this.repaint();
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
            int n = 0;
            while (n < this.balls.length) {
                this.balls[n].move();
                ++n;
            }
            int n2 = this.movePaddle();
            if (n2 > this.paddleR.getPosY()) {
                this.paddleR.down();
            }
            if (n2 >= this.paddleR.getPosY()) continue;
            this.paddleR.up();
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    protected void showNotify() {
        this.start();
    }

    void slowDownGame() {
        this.paddleL.slower();
        this.paddleR.slower();
        this.delay += 10;
        if (this.delay > 100) {
            this.delay = 100;
        }
    }

    void speedUpGame() {
        this.paddleL.faster();
        this.paddleR.faster();
        this.delay -= 10;
        if (this.delay < 0) {
            this.delay = 0;
        }
    }

    void start() {
        if (this.stopped) {
            return;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    void startGame() {
        if (!this.stopped) {
            return;
        }
        this.removeCommand(this.startCommand);
        this.addCommand(this.stopCommand);
        this.initialization();
        if (this.ballsInPlay == 0) {
            this.resetGame();
        }
        this.stopped = false;
        this.start();
    }

    void stopGame() {
        this.removeCommand(this.stopCommand);
        this.addCommand(this.startCommand);
        this.stopped = true;
        this.pause();
    }
}

