#ifndef _GLOBAL_H_
#define _GLOBAL_H_

# define ATARI_RENDER_NORMAL     0
# define ATARI_RENDER_FIT_WIDTH  1
# define ATARI_RENDER_FIT        2
# define ATARI_RENDER_MAX        3
# define ATARI_LAST_RENDER       3

# define MAX_PATH   256
# define ATARI_MAX_SAVE_STATE 5

  typedef struct ATARI_t {
 
    char atari_save_used[ATARI_MAX_SAVE_STATE];
    char atari_save_name[MAX_PATH];
    char atari_home_dir[MAX_PATH];
    int  psp_screenshot_id;
    int  psp_cpu_clock;
    int  psp_reverse_analog;
    int  atari_snd_enable;
    int  atari_render_mode;
    int  psp_skip_max_frame;
    int  psp_skip_cur_frame;

  } ATARI_t;

  extern ATARI_t ATARI;


//END_LUDO:
  extern int atari_save_configuration(void);
  extern int atari_parse_configuration(void);
  extern void update_save_name(char *Name);
  extern void reset_save_name();
  extern void atari_kbd_load(void);
  extern int atari_kbd_save(void);
  extern void emulator_reset(void);
  extern int atari_load_rom(char *FileName, int zip_format);
  extern int atari_load_state(char *FileName);
  extern int atari_snapshot_save_slot(int save_id);
  extern int atari_snapshot_load_slot(int load_id);
  extern int atari_snapshot_del_slot(int save_id);

#endif
