
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;

public class GraphicsTo16BitC {

	public static void main(String args[]) throws Exception {
		// check arguments
		if (args.length != 1) {
			System.out.println("Usage: java GraphicsTo16BitC pic.png");
			return;
		}

		// load image
		String filename = args[0];
		Image image = ImageIO.read(new File(filename));

		// determine pixels
		int w = image.getWidth(null);
		int h = image.getHeight(null);
		int[] pixels = new int[w * h];
		PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
		try {
			pg.grabPixels();
		} catch (InterruptedException e) {
		}

		// save as C
		try {
			// open output stream
			String name = filename.substring(0, filename.length() - 4);
			PrintWriter out = new PrintWriter(new FileOutputStream(name + ".c"));

			// write dimension
			out.println("int " + name + "Width = " + w + ";");
			out.println("int " + name + "Height = " + h + ";");
			out.println("unsigned short " + name + "Data[] = {");

			// write pixels
			for (int y = 0; y < h; y++) {
				StringBuffer line = new StringBuffer();
				for (int x = 0; x < w; x++) {
					int color = pixels[y * w + x];
					int blue = (color & 0xff) >> 3;
					int green = ((color >> 8) & 0xff) >> 3;
					int red = ((color >> 16) & 0xff) >> 3;
					int alpha = color >> 24;
					int value = red | (green << 5) | (blue << 10);
					if (alpha == 0)
						value = 0x8000;
					line.append("0x" + Integer.toHexString(value) + ",");
				}
				out.println(line);
			}
			out.println("};");
			out.close();
		} catch (IOException e) {
			System.out.println("error while writing");
			e.printStackTrace();
		}
	}
}
