// mveletek argb tagokkal
//////////////////////////////////////////////////////////////////////

#include "ARGB.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ARGB::ARGB()
{
	Color = 0;
}

ARGB::~ARGB()
{

}

ARGB::ARGB(DWORD color)
{
	Color = color;
}

DWORD ARGB::operator =(DWORD color)
{
	Color = color;
	return color;
}

DWORD ARGB::operator =(ARGB &masik)
{
	Color = masik.Color;
	return Color;
}

// itt jnnek a fontosabbak a lnyeg hogy az ARGB-kat kln kln mdostjuk s ne lphessen pl B a G-be
DWORD ARGB::operator +(DWORD ezt)
{
	return add(Color,ezt);	
}

DWORD ARGB::operator +(ARGB &ezt)
{
	return add(Color,ezt.Color);
}


DWORD ARGB::operator +=(DWORD ezt)
{
	Color = add(Color,ezt);
	return Color;
}

DWORD ARGB::operator +=(ARGB &ezt)
{
	Color = add(Color,ezt.Color);
	return Color;
}

// kivonsok ---------------------------------------------

DWORD ARGB::operator -(DWORD ezt)
{
	return sub(Color,ezt);	
}

DWORD ARGB::operator -(ARGB &ezt)
{
	return sub(Color,ezt.Color);
}


DWORD ARGB::operator -=(DWORD ezt)
{
	Color = sub(Color,ezt);
	return Color;
}

DWORD ARGB::operator -=(ARGB &ezt)
{
	Color = sub(Color,ezt.Color);
	return Color;
}

// szorzsok  --------------------------------------
DWORD ARGB::operator *(float ezzel)
{
	return mul(Color,ezzel);	
}


DWORD ARGB::operator *=(float ezzel)
{
	Color = mul(Color,ezzel);
	return Color;
}

// tagonknti mveletek ---------------

DWORD ARGB::MulChannel(float a,float r,float g,float b)
{
	int i;
	float temp,mu[4];
	mu[0]=a;mu[1]=r;mu[2]=g;mu[3]=b;

	BYTE *e=(BYTE*)&Color;

	for(i=0;i<4;i++)
	{
		temp = e[i] * mu[i];
		if(temp<0.0f) e[i]=0;
		else 
		{
			if(temp>255.0f) e[i]=255;
			else 
			e[i]=BYTE(temp);
		}
	}

	return Color;
}

// -----------------------------------------------------------------------------------

// sszeadja a 2 argb-t
DWORD ARGB::add(DWORD ezt, DWORD ezzel)
{
	int i,temp;
	DWORD ret;
	BYTE *e=(BYTE*)&ret,*p1=(BYTE*)&ezt,*p2=(BYTE*)&ezzel;

	for(i=0;i<sizeof(DWORD);i++)
	{
		temp = int(p1[i]) + p2[i];
		if(temp>255) e[i]=255;
		else e[i]=BYTE(temp);
	}

	return ret;
}

DWORD ARGB::sub(DWORD ebbol, DWORD ezt)
{
	int i,temp;
	DWORD ret;
	BYTE *e=(BYTE*)&ret,*p1=(BYTE*)&ebbol,*p2=(BYTE*)&ezt;

	for(i=0;i<sizeof(DWORD);i++)
	{
		temp = int(p1[i]) - p2[i];
		if(temp<0) e[i]=0;
		else e[i]=BYTE(temp);
	}

	return ret;
}

DWORD ARGB::mul(DWORD ezt, float ezzel)
{
	int i;
	float temp;
	DWORD ret;
	BYTE *e=(BYTE*)&ret,*p=(BYTE*)&ezt;

	for(i=0;i<sizeof(DWORD);i++)
	{
		temp = p[i] * ezzel ;
		if(temp<0.0f) e[i]=0;
		else 
		{
			if(temp>255.0f) e[i]=255;
			else 
				e[i]=BYTE(temp);
		}
	}

	return ret;
}

DWORD ARGB::GetColor()
{
	return Color;
}
