// Draw.cpp: implementation of the CDraw class.
//
//////////////////////////////////////////////////////////////////////

#include "Draw.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


// FIXED FUNCTION PIPELINE is elg mg..

// SetRenderState() 
int CDraw::SRS(DWORD state, DWORD value)
{
	return(Dev.GetDevice()->SetRenderState((D3DRENDERSTATETYPE)state,value));
}

// SetTextureStageState()
int CDraw::STSS(DWORD stage, DWORD type, DWORD value)
{
	if(!Dev.GetDevice()) return 0;

	return(Dev.GetDevice()->SetTextureStageState(stage,(D3DTEXTURESTAGESTATETYPE) type,value));
}


// taln a regrgebbi fv-m d3d-ben:
// sima 2d-s tgla kirajzolsa
void CDraw::DrawSprite(int x,int y,int dx,int dy,CTexture *kep,float halvpixel)
{
	if(!Dev.GetDevice()) return;

	// SetTextureStageState
	STSS(0,D3DTSS_COLORARG2,D3DTA_DIFFUSE); 
	STSS(0,D3DTSS_COLORARG1,D3DTA_TEXTURE);
	STSS(0,D3DTSS_COLOROP,D3DTOP_SELECTARG1);
	STSS(1,D3DTSS_COLOROP,D3DTOP_DISABLE);

	float z=0.0f,rhw=1.0f; // egyszer z-t 0.9 re lltottam s ha kzel mentem egy falhoz akkor eltnt rla a litemap rdekes mi?

	struct menuelem{float x;float y;float z;float w;float tu;float tv;};
	menuelem verti[]={
	{float(x)+halvpixel,	float(y)+halvpixel,		z,rhw,0.0f,0.0f},
	{float(x+dx)-halvpixel,	float(y)+halvpixel,		z,rhw,1.0f,0.0f},
	{float(x)+halvpixel,	float(y+dy)-halvpixel,	z,rhw,0.0f,1.0f},
	{float(x+dx)-halvpixel,	float(y+dy)-halvpixel,z,rhw,1.0f,1.0f} };
	Dev.GetDevice()->SetFVF(D3DFVF_XYZRHW | D3DFVF_TEX1);
	Dev.GetDevice()->SetTexture(0,kep->GetTexture());
	Dev.GetDevice()->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,2,verti,sizeof(menuelem));
}

// teszt
// vektortmbt renderel adott szn linestripknet ha a closeline>0 akkor be is zrja..
void CDraw::LineStrip(VECTOR *vec, int vecnum, DWORD color,char closeline)
{
	if(!Dev.GetDevice()) return;

	Dev.GetDevice()->SetFVF(D3DFVF_XYZ | D3DFVF_DIFFUSE); // sima diffz
	STSS(0,D3DTSS_COLORARG1,D3DTA_DIFFUSE); 
	STSS(0,D3DTSS_COLORARG2,D3DTA_TEXTURE);
	STSS(0,D3DTSS_COLOROP,D3DTOP_SELECTARG1);
	STSS(1,D3DTSS_COLOROP,D3DTOP_DISABLE);

	if(vecnum<2) return;
	int add=0;if(closeline) add=1;

	vertex_DIFF *dv=new vertex_DIFF [vecnum+add];
	if(!dv) return;

	int i;
	for(i=0;i<vecnum;i++)
	{
		dv[i].vec=vec[i];
		dv[i].col=color;
	}
	if(add) 
	{
		dv[vecnum].vec=vec[0];
		dv[vecnum].col=color;
	}

	Dev.GetDevice()->DrawPrimitiveUP(D3DPT_LINESTRIP,vecnum-1+add,dv,sizeof(vertex_DIFF));	

	POINTER_FREE(dv);
}

// teszt
// adott sznnel kirajzol egy polit
void CDraw::DiffPoli(VECTOR *vecs, int vecnum, DWORD color)
{
	if(!Dev.GetDevice()) return; // no device, no fun !! (only blank & dark screen...)
	if(vecnum<3 || vecnum>16 || !vecs) return;

	Dev.GetDevice()->SetFVF(D3DFVF_XYZ | D3DFVF_DIFFUSE); // sima diffz
	STSS(0,D3DTSS_COLORARG1,D3DTA_DIFFUSE); 
	STSS(0,D3DTSS_COLORARG2,D3DTA_TEXTURE);
	STSS(0,D3DTSS_COLOROP,D3DTOP_SELECTARG1);
	STSS(1,D3DTSS_COLOROP,D3DTOP_DISABLE);

	int i;
	vertex_DIFF vv[16];if(vecnum>15) vecnum=15;
	for(i=0;i<vecnum;i++) 
	{
		vv[i].vec=vecs[i];
		vv[i].col=color;
	}
	Dev.GetDevice()->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,vecnum-2,vv,sizeof(vertex_DIFF));
}

// textrzott poli
void CDraw::TexPoli(vertex_TEX1 *vertex,int vnum,CTexture *tex)
{
	if(!Dev.GetDevice()) return; // no device, no fun !!
	if(vnum<3 || vnum>32) return;

	Dev.GetDevice()->SetFVF(D3DFVF_XYZ | D3DFVF_TEX1); // sima textra
	STSS(0,D3DTSS_COLORARG2,D3DTA_DIFFUSE); 
	STSS(0,D3DTSS_COLORARG1,D3DTA_TEXTURE);
	STSS(0,D3DTSS_COLOROP,D3DTOP_SELECTARG1);
	STSS(1,D3DTSS_COLOROP,D3DTOP_DISABLE);
	Dev.GetDevice()->SetTexture(0,tex->GetTexture());
	Dev.GetDevice()->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,vnum-2,vertex,sizeof(vertex_TEX1));
}

void CDraw::SetWorldMatrix(MATRIX *pWorld)
{
	MATRIX *m=pWorld,ident;
	if(!m)
	{
		ident.Identity();
		m=&ident;
	}
	Dev.GetDevice()->SetTransform(D3DTS_WORLD,((D3DXMATRIX*)m));
}

// poligon sordrsi irny belltsa 0 - ramutatval 1 ellenttesen (OGl style) 2 mindent rajzol
void CDraw::CullMode(char rightleftnone)
{
	if(!Dev.GetDevice()) return;
	switch(rightleftnone)
	{
	case 0: 	Dev.GetDevice()->SetRenderState( D3DRS_CULLMODE,D3DCULL_CCW); // normal culling (mramennyire D3D-ben..)
		break; 
	case 1:		Dev.GetDevice()->SetRenderState( D3DRS_CULLMODE,D3DCULL_CW); 
		break;
	case 2:		Dev.GetDevice()->SetRenderState( D3DRS_CULLMODE,D3DCULL_NONE);
		break;
	};

}

// kirajzol egy polit diffz sznnel s sttti a camera irnytl fggen
void CDraw::DiffPoliADV(VECTOR *vecs, int vecnum, DWORD color,CTexture *tex,TEXCO* texturakoords,VECTOR *campos,VECTOR *camdir, float csillogas)
{
	int i;
	if(!Dev.GetDevice() || !tex) return; // no device,no tex, no fun !! (only blank & dark screen...)
	if(vecnum<3 || vecnum>16 || !vecs) return;

	VECTOR norma=(vecs[0]-vecs[1]) * (vecs[1]-vecs[2]);
	norma.Normalize();	// poli normja - a diffz polik megklnbztetshez 
						// minl nagyobb a camdir s ekztt a bezrt szg, annl 'fnyesebb'
	ARGB col;
	col = color;
	float dp = norma.DotProduct(*camdir);

	if (dp<0.f) dp=-dp;
	col*=(0.7f+csillogas*dp); // minl kisebb szgben nz a kamera annl vilgosabb - primitiv flat shade

	DWORD newcol = col.Color;

	Dev.GetDevice()->SetFVF(D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1); // diffz+tex
	Dev.GetDevice()->SetTexture(0,tex->GetTexture());
	STSS(0,D3DTSS_COLORARG1,D3DTA_DIFFUSE); 
	STSS(0,D3DTSS_COLORARG2,D3DTA_TEXTURE);
	STSS(0,D3DTSS_COLOROP,D3DTOP_MODULATE);//D3DTOP_MODULATE); // D3DTOP_SELECTARG1); //
	STSS(1,D3DTSS_COLOROP,D3DTOP_DISABLE);

	vertex_DIFFTEX vv[16];if(vecnum>15) vecnum=15;
	for(i=0;i<vecnum;i++) 
	{
		vv[i].vec=vecs[i];
		vv[i].col=newcol;
		vv[i].tex1=texturakoords[i];
	}
	Dev.GetDevice()->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,vecnum-2,vv,sizeof(vertex_DIFFTEX));

}

// szimpln kirajzol minden polit, ami csak van a plyn
// campos a pozcija, camdir a kamera irnya
void CDraw::DrawPalya(VECTOR* campos,VECTOR* camdir,CList<CTexture>* texturak)
{
	clevel palya; // static member elnye akciban (pop-up level data ;)
	int i,vecnum,texture_num;
	DWORD szin;
	VECTOR *vecs;

	for(i=0;i<palya.polis.ElemNumMax;i++)
	{
		// szin a normja szerint
		// float tmbl vektort
		// legyen textrzs is.
		vecs=(VECTOR*)&palya.coodinate.Array[palya.polis.Array[i].vertexindex*3];
		vecnum = palya.polis.Array[i].vertexnum;
		szin = palya.diffuse.Array[i];
		texture_num = palya.polis.Array[i].Texture_num_index & 0xffffff;
		DiffPoliADV(vecs,vecnum,szin,
					texturak->GetElem(palya.textura_index.Array[texture_num]),
					&palya.texturacoord.Array[palya.polis.Array[i].Texco_num_index & 0xffffff],
					campos,camdir,1.f);
	}
	
}
