// Level.cpp: implementation of the CLevel class.
//
//////////////////////////////////////////////////////////////////////

#include "Level.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

// sajt plya file formtum csak a poligonok adatai kellenek bsp,pvs nem
enum CHUNKS
{
		// magic number -------------
	C_MAGIC			= 0,	// magic number jn (4 byte) terv:"BZ" +verzio 2 byte (0)
		// bsp staff	-------------
	C_NODE			= 1,	// csomk,	(fNODE)
	C_LEAF			= 2,	// levelek,	(fLEAF)
		// poligon data -------------
	C_POLIGON		= 3,	// poligonok (fPOLIGON)
		// vektors		-------------
	C_VERTEX		= 4,	// vektorok tmbje (fVERTEX)
	C_NORMAL		= 5,	// poligonok norminak a tmbje (fVERTEX) - bumpmapels esetn kell gondolom (terv)
		// texco - k	-------------
	C_TEXCO			= 6,	// textrakoordinta lump (fTEXCO)
		// fnyek		-------------
	C_LITE			= 7,		
		// Index lumps	-------------
	C_I_LEAFPOLI	= 8,	// (DWORDs) fLEAF.poligonindex ide
	C_I_PVS			= 9,	// (DWORDs) fLEAF.pvsstart-enk
	C_I_TEXTURENUM	= 10,	// (DWORDs) (fPOLIGON.Texture_num_index >> 8) - egy poli textrinak indexei
	C_I_LEAFLITE	= 11,	// (DWORDs) (fLEAF.liteindex) adott levlben mely fnyek vannak.
	C_TEXTURENAMES	= 12,	// (char s) textrk nevei egy szkzzel elvlasztva

	C_end
};

CList<float>		clevel::coodinate=0;
CList<tPoliData>	clevel::polis=0;
CList<DWORD>		clevel::diffuse=0;	// minden polinak egy szn - quite takarkos
CList<TEXCO>		clevel::texturacoord=0;
CList<DWORD>		clevel::textura_index=0; 

// betlti a tesztplyt ret = 1 ha ok
int CLevel::loadlevel(char *name,FILE*f)
{
Clog logger;


	DWORD chunk[2];
	char poliloaded=0,vektorloaded=0,texcoloaded=0,texn_loaded=0;
	int pnum;

	while(fread(chunk,8,1,f))
	{
		if(chunk[0]>C_end) return 0; // hibs file
		if(chunk[0]==C_POLIGON)		
		{
			pnum = int(chunk[1] / sizeof(tPoliData));
			if(pnum<1) return 0; // nincsennek polik
			if(!(Palya.polis=pnum)) return 0;	// nincs memria nekik (mondjuk akkor ki is fagy a cucc lehet.)
			if(!(Palya.diffuse=pnum)) return 0;	// szinek a poliknak
			if(!fread(Palya.polis.Array,chunk[1],1,f)) return 0; // a fileban nincs is annyi byte
			poliloaded=1;
logger.log("polik adatai betltve.");
		}
		else
		if(chunk[0]==C_VERTEX)		
		{
			pnum = int(chunk[1] / sizeof(float));
			if(pnum<1) return 0; // nincsennek vektorok benne ? - az rdekes lenne
			if(!(Palya.coodinate=pnum)) return 0;	// nincs memria nekik (mondjuk akkor ki is fagy a cucc lehet.)
			if(!fread(Palya.coodinate.Array,chunk[1],1,f)) return 0; // a fileban nincs is annyi byte
			vektorloaded=1;
logger.log("polik vektorai betltve.");
		}
		else
		if(chunk[0]==C_TEXCO)		
		{
			pnum = int(chunk[1] / sizeof(TEXCO));
			if(pnum<1) return 0; // nincsennek vektorok benne ? - az rdekes lenne
			if(!(Palya.texturacoord=pnum)) return 0;	// nincs memria nekik (mondjuk akkor ki is fagy a cucc lehet.)
			if(!fread(Palya.texturacoord.Array,chunk[1],1,f)) return 0; // a fileban nincs is annyi byte
			texcoloaded=1;
logger.log("polik textra koorinti betltve.");

		}
		else 
		if(chunk[0]==C_I_TEXTURENUM)		
		{
			pnum = int(chunk[1] / sizeof(DWORD));
			if(pnum<1) return 0; // nincsennek vektorok benne ? - az rdekes lenne
			if(!(Palya.textura_index=pnum)) return 0;	// nincs memria nekik (mondjuk akkor ki is fagy a cucc lehet.)
			if(!fread(Palya.textura_index.Array,chunk[1],1,f)) return 0; // a fileban nincs is annyi byte
			texn_loaded=1;
logger.log("polik textraindexei betltve.");
		}
		else fseek(f,chunk[1],SEEK_CUR);

		// minden betytve?
		if(poliloaded && vektorloaded && texcoloaded && texn_loaded) return 1;
	}
	return 0;
}

int CLevel::Call_loadlevel(char *name)
{
	// sorry for the pure c code :), but i like it!
	FILE*f = fopen(name,"r+b");
	if(!f) return 0;
	int ret = loadlevel(name,f);
	fclose(f);
	make_color_for_poli();
	return ret;
}

// diffz szn a poliknak - a vgn csak mindegyiknek ugyanolyan lett...
void CLevel::make_color_for_poli()
{
	// ARGB;
	ARGB szin;
	int i;
	for(i=0;i<Palya.polis.ElemNumMax;i++)
	{
		// ok mind szrke lesz..
		Palya.diffuse.Array[i]=0x00707070;
	}
}

