// MATRIX.cpp: implementation of the MATRIX class.
//
//////////////////////////////////////////////////////////////////////

#include "MATRIX.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


MATRIX::MATRIX(const MATRIX& ezzel)
{
	//_11 = ezzel._11; - gy egy kicsit sok lenne
	memcpy(this,(void*)&ezzel,sizeof(MATRIX));
}

// kapcsolat a d3d-vel
MATRIX::MATRIX(const D3DXMATRIX& ezzel)
{
	memcpy(this,(void*)&ezzel,sizeof(MATRIX)); // elvileg mennie kell
}

MATRIX& MATRIX::operator =(const MATRIX &ezzel)
{
	memcpy(this,(void*)&ezzel,sizeof(MATRIX));
	return *this;
}

MATRIX& MATRIX::operator =(const D3DXMATRIX &ezzel)
{
	memcpy(this,(void*)&ezzel,sizeof(MATRIX));
	return *this;
}

// lenullza minden adattttyt
void MATRIX::ZeroMe()
{
	_11=_12=_13=_14=0.f;
	_21=_22=_23=_24=0.f;
	_31=_32=_33=_34=0.f;
	_41=_42=_43=_44=0.f; // is it optim.-ed?
}

// szorzsa szmmal (van-e ennek rtelme - kb csak 0-val)
MATRIX& MATRIX::Mult(float ezzel)
{
	int i;
	float *m=&_11;
	for(i=0;i<16;i++) m[i]*=ezzel;

	return *this;
}

void MATRIX::ToScreen()
{
	float *m = &_11;
	int u=0;
	for(int i=0;i<16;i++)
	{
		printf("%3.3f ",m[i]);
		u++;if(u>=4) {printf("\n");u=0;}
	}

	printf("\n");
}

// egysgmtrix
MATRIX& MATRIX::Identity()
{
	memset(this,0,sizeof(MATRIX));
	_11=_22=_33=_44=1.f;

	return *this;
}

// forgats x tengely krl
MATRIX& MATRIX::RotX(float degree)
{
	double rad = degree * ONE_RAD;
	float cs = float(cos(rad));
	float sn = float(sin(rad));

	Identity();

	_22 =  cs; _23 = sn;
	_32 = -sn; _33 = cs;

	return *this;
}

MATRIX& MATRIX::RotY(float degree)
{
	double rad = degree * ONE_RAD;
	float cs = float(cos(rad));
	float sn = float(sin(rad));

	Identity();

	_11 = cs; _13 = -sn;
	_31 = sn; _33 =  cs;

	return *this;	
}

MATRIX& MATRIX::RotZ(float degree)
{
	double rad = degree * ONE_RAD;
	float cs = float(cos(rad));
	float sn = float(sin(rad));

	Identity();

	_11 =  cs; _12 = sn;
	_21 = -sn; _22 = cs;

	return *this;
}

/*
mtrixok szorzsa:
dim hanyszor hanyas rsz szorozzunk ssze 
return a vgeredmny
(max 4)
*/
MATRIX MATRIX::Mult(MATRIX &ezzel,BYTE dim)
{
	if(dim<2 || dim>4) dim = 4; // no foolishness pleeze

	int i,u,k;
	float osszeg;
	MATRIX uj; 
	if(dim<4) uj.Identity(); // ez is kellhet

	float *m1 = &_11;
	float *m2 = &ezzel._11;
	float *mu = &uj._11;

	for(i=0;i<dim;i++) // az j matrix minden sorra
	{
		for(u=0;u<dim;u++)  // az j mtrix minden sornak egy elemre
		{
			osszeg=0.f;
			for(k=0;k<dim;k++) // minden elemre sszegezve
			{
				// m1 bl van a sor m2 -bl az oszlop
				osszeg+=(m1[i*4+k]*m2[u+k*4]);
			}
			mu[i*4+u] = osszeg;
		}
	}

	return uj;
}

// mtrixok szorzsa
MATRIX MATRIX::operator*(MATRIX &ezzel)
{
	return Mult(ezzel,4);
}

// szorzs
MATRIX& MATRIX::operator*=(MATRIX &ezzel)
{
	(*this) = Mult(ezzel,4);
	return *this;
}

// eltols - CSAK BERJA A NEGYEDIK SORBA NINCS IDENTITY !
MATRIX& MATRIX::TransFloats(float x, float y, float z)
{
	_41 = x;
	_42 = y;
	_43 = z;
	return *this;
}

// identity + eltols
MATRIX& MATRIX::Translation(float x, float y, float z)
{
	Identity();
	_41 = x;
	_42 = y;
	_43 = z;
	return *this;
}


// D3DXMatrixRotationYawPitchRoll - lal megegyzik
MATRIX& MATRIX::RotXYZ(float degY, float degX, float degZ)
{
	// visszafele kell haladni.

	_41=_42=_43=_14=_24=_34=0.f; _44=1.f;
	MATRIX mat[3];

	char ad[3]; ad[0]=ad[1]=ad[2]=0; // mely mtrix van hasznlva
	if(degZ) {mat[0].RotZ(degZ); ad[0]=1;}
	if(degX) {mat[1].RotX(degX); ad[1]=1;}
	if(degY) {mat[2].RotY(degY); ad[2]=1;}

	int i,was=0;
	for(i=0;i<3;i++)
	{
		if(ad[i])
		{
			if(!was) // ez az els nem res
			{
				was=1;
				(*this) = mat[i];
			}
			else
			{
				(*this) = this->Mult(mat[i],4); // 3*3- as elg itt
			}
		}
	}

	if(!was) this->Identity();

	return *this;
}



MATRIX MATRIX::operator +(MATRIX &ezzel)
{
	MATRIX uj;
	float *m1 = &_11;
	float *m2 = &ezzel._11;
	float *m3 = &uj._11;
	int i;
	for(i=0;i<16;i++) (*m3++)=(*m1++)+(*m2++);

	return uj;
}

// vektor szorzasa matrixxal (vec.W=0 teht csak forgatsra!)
// azaz csak a 3*3-as rszt hasznlja..
VECTOR MATRIX::operator *(VECTOR &ezzel)
{
	VECTOR uj;
	uj.x= _11*ezzel.x + _21*ezzel.y + _31*ezzel.z;
	uj.y= _12*ezzel.x + _22*ezzel.y + _32*ezzel.z;
	uj.z= _13*ezzel.x + _23*ezzel.y + _33*ezzel.z;
	return uj;
}

// pozci transzformlsa
VECTOR MATRIX::operator*(VECTOR4 &ezzel)
{
	VECTOR uj;
	uj.x= _11*ezzel.x + _21*ezzel.y + _31*ezzel.z + _41*ezzel.w;
	uj.y= _12*ezzel.x + _22*ezzel.y + _32*ezzel.z + _42*ezzel.w;
	uj.z= _13*ezzel.x + _23*ezzel.y + _33*ezzel.z + _43*ezzel.w;	
	return uj;
}

/*
zaxis = normal(At - Eye)
xaxis = normal(cross(Up, zaxis))
yaxis = cross(zaxis, xaxis)

 xaxis.x           yaxis.x           zaxis.x          0
 xaxis.y           yaxis.y           zaxis.y          0
 xaxis.z           yaxis.z           zaxis.z          0
-dot(xaxis, eye)  -dot(yaxis, eye)  -dot(zaxis, eye)  1
*/

// lookat (view transform) ellltsa pont mint a D3DXMatrixLookAtLH fv
void MATRIX::LookatLH(VECTOR *eye, VECTOR *lookat, VECTOR *up)
{
	VECTOR z,x,y;

	z = (*lookat) - (*eye); z.Normalize();
	x = (*up) * z;			x.Normalize();
	y = z*x;

	_11 = x.x;	_12 = y.x;	_13 = z.x;	_14 = 0.f;
	_21 = x.y;	_22 = y.y;	_23 = z.y;	_24 = 0.f;
	_31 = x.z;	_32 = y.z;	_33 = z.z;	_34 = 0.f;

	_41 = -(x.DotProduct(*eye));
	_42 = -(y.DotProduct(*eye));
	_43 = -(z.DotProduct(*eye));

	_44 = 1.f; // jajh de tyok tymts kell ide
}

// egyenl-e a kt mtrix tartalma (4. tizedesjegyig)
bool MATRIX::operator ==(MATRIX &ezzel)
{
	double d;
	float *m1 = (float*)&_11;
	float *m2 = (float*)&ezzel._11;

	for(int i=0;i<16;i++) 
	{
		d=m1[i]-m2[i];
		if(d>FL_EQ || d<-FL_EQ) return false;
	}
	return true;
}

bool MATRIX::operator ==(D3DXMATRIX &ezzel)
{
	double d;
	float *m1 = (float*)&_11;
	float *m2 = (float*)&ezzel._11;

	for(int i=0;i<16;i++) 
	{
		d=m1[i]-m2[i];
		if(d>FL_EQ || d<-FL_EQ) return false;
	}

	return true;
}

/* 
projekcis mtrixot csinl (bal kezes)
fieldOviewYdegree : y nylsszg FOKBAN
acpectratio : fgg/vzszintes arnya (4/3 - 3/4?) - mindeki mst r
nearZ : kzeli vgsk
farZ  : tvoli vgsk (ezek kztt van a Z-buffer elosztva)
*/
void MATRIX::PerspectiveFovLH(float fieldOviewYdegree, float acpectratio, float nearZ, float farZ)
{
	ZeroMe();
	float w,h,z1,z2;

	h = float(1/tan( (fieldOviewYdegree / 2)*ONE_RAD ) );
	w = h / acpectratio;

	z1 = (farZ/(farZ-nearZ));
	z2 = -((nearZ*farZ)/(farZ-nearZ));

	_11 = w;	_22 = h;	_33 = z1;	_43 = z2;	_34 = 1.f;
}