#include "PLANE.h"

VECTOR PLANE::GetNormal()
{
	return(VECTOR(A,B,C));
}

// els 
void PLANE::Make(const VECTOR &masik,float dd)
{
	A=masik.x;
	B=masik.y;
	C=masik.z;
	D=dd;

}

// msodik
void PLANE::Make(float a, float b, float c, float d)
{
	A=a;
	B=b;
	C=c;
	D=d;
}

// |norma| == 1 (is a must)
void PLANE::Make(VECTOR *pointonplane, VECTOR *planenormal)
{
	if(!pointonplane || !planenormal)
	{
		A=B=C=D=0.0;
		return;
	}

	// esetleg nem egysg hossz a norma?
	float h_sq=planenormal->DotProduct(*planenormal);
	if(h_sq<1-VECTOR_EQUAL_PRECISION || h_sq>1+VECTOR_EQUAL_PRECISION) 
	{
		VECTOR norma = (*planenormal);
		norma.Normalize();
		A=norma.x;
		B=norma.y;
		C=norma.z;
		D=-( pointonplane->DotProduct(norma) );
		return;
	}

	A=planenormal->x;
	B=planenormal->y;
	C=planenormal->z;
	D=-( pointonplane->DotProduct((*planenormal)) );
}

float PLANE::GetDist(VECTOR *vec)
{
	return( vec->x*A + vec->y*B + vec->z*C + D);
}


// ennl jobb az IsEQUAL
bool PLANE::operator ==(const PLANE &masik)
{
	float d; // prblom az fabs()-t kikerlni, htha gy gyosabb lesz, de bnbb...
	d=A-masik.A;
	if(d<0.0f) {if(d<-PLANE_IS_EQUAL_WHEN_CLOSER) return false;}
	else {if(d>PLANE_IS_EQUAL_WHEN_CLOSER) return false;}

	d=B-masik.B;
	if(d<0.0f) {if(d<-PLANE_IS_EQUAL_WHEN_CLOSER) return false;}
	else {if(d>PLANE_IS_EQUAL_WHEN_CLOSER) return false;}

	d=C-masik.C;
	if(d<0.0f) {if(d<-PLANE_IS_EQUAL_WHEN_CLOSER) return false;}
	else {if(d>PLANE_IS_EQUAL_WHEN_CLOSER) return false;}

	d=D-masik.D;
	if(d<0.0f) {if(d<-PLANE_IS_EQUAL_WHEN_CLOSER) return false;}
	else {if(d>PLANE_IS_EQUAL_WHEN_CLOSER) return false;}

	return true;
}

// megfordtja a skot
void PLANE::Neg()
{
	A=-A;
	B=-B;
	C=-C;
	D=-D;
}

// gy is lehessen
void PLANE::Make(VECTOR *trivec)
{
	VECTOR a,b,n;
	a=trivec[0]-trivec[1];
	b=trivec[1]-trivec[2];
	n=a*b;
	n.Normalize();
	A=n.x;
	B=n.y;
	C=n.z;
	D=-(trivec[0].DotProduct(n));
}

// rajta van a skon (kb)
bool PLANE::PointOnPlane(VECTOR *pont)
{
	float dif=pont->x*A+pont->y*B+pont->z*C+D;
	if(dif<0.0) {if (dif<-PLANE_IS_EQUAL_WHEN_CLOSER) return false;else return true;} // de kk!
	if(dif>0.0) {if (dif> PLANE_IS_EQUAL_WHEN_CLOSER) return false;else return true;}
	return true; // csak hogy ne legyen warning (vagy ha potn 0.0f a tv)
}

// ez csak azt adja vissza mennyivel kell megszorozni a end-start vektort, hogy megkapjuk a hitpontot
float PLANE::TheArany(VECTOR *start, VECTOR *end)
{
	float d1=-GetDist(start);
	VECTOR n(A,B,C),irany=(*end)-(*start);
	float d2=n.DotProduct(irany);
	if(d2==0.0f) return 0.0f; // ha az irany (0,0,0) - ez elfordulhat (Trace*Shere)
	return(d1/d2);
}

// detto duplapontosan
double PLANE::TheAranyD(VECTOR *start, VECTOR *end)
{
	double d1=-((double)start->x*A+start->y*B+start->z*C+D);
	VECTOR irany=(*end)-(*start); //n(A,B,C)
	double d2=A*irany.x+B*irany.y+C*irany.z; // dotpoduct a norml s az irny kztt
	if(d2==0.0) return 0.0; // ha az irany (0,0,0) - ez elfordulhat (Trace*Shere)
	return(d1/d2);
}

// skot toljuk el a normlja irnyba ennyivel
void PLANE::ShiftPlane(float value)
{
	D-=value;
}

// pont sktl val tvja (double)
double PLANE::GetDistDouble(VECTOR *vec)
{
	return( double(vec->x*A) + vec->y*B + vec->z*C + D);
}

// vekorral is el lehet tolni (D-=vec.dotp(norma))
void PLANE::ShiftPlaneVEC(VECTOR *vec)
{
	D-=vec->DotProduct(A,B,C);
}

// levetti a pontot a skra..
VECTOR PLANE::ProjectPoint(VECTOR *point)
{
	float tav=point->x*A+point->y*B+point->z*C+D;
	float x=point->x-A*tav;
	float y=point->y-B*tav;
	float z=point->z-C*tav;
	return VECTOR(x,y,z);
	
}

// return=1 ha mind eltte vagy rajta van.. (sec-ofset)
int PLANE::IsAllFrontVector(VECTOR *vec, int vecnum)
{
	int i;
	float d;
	VECTOR *v;
	for(i=0;i<vecnum;i++)
	{
		v=&vec[i];
		d= v->x * A + v->y * B + v->z * C + D;
		if(d<-PLANE_IS_EQUAL_WHEN_CLOSER) return 0;
	}
	return 1;
}

bool PLANE::IsEQUAL(PLANE &ezzel, float smallv)
{
	float d;
	d=A-ezzel.A;
	if(d<0.0f) {if(d<-smallv) return false;}
	else {if(d>smallv) return false;}

	d=B-ezzel.B;
	if(d<0.0f) {if(d<-smallv) return false;}
	else {if(d>smallv) return false;}

	d=C-ezzel.C;
	if(d<0.0f) {if(d<-smallv) return false;}
	else {if(d>smallv) return false;}

	d=D-ezzel.D;
	if(d<0.0f) {if(d<-smallv) return false;}
	else {if(d>smallv) return false;}

	return true;
}
