#include "VECTOR.h"

VECTOR VECTOR::operator + (const VECTOR& ezzel )
{
	VECTOR ret;
	ret.x=x+ezzel.x;
	ret.y=y+ezzel.y;
	ret.z=z+ezzel.z;
	return ret;
}

VECTOR VECTOR::operator - (const VECTOR& ezzel )
{
	VECTOR ret;
	ret.x=x-ezzel.x;
	ret.y=y-ezzel.y;
	ret.z=z-ezzel.z;
	return ret;
}

VECTOR VECTOR::operator * (float szorzo) // vektor hosszt 
{
	VECTOR ret;
	ret.x=x*szorzo;
	ret.y=y*szorzo;
	ret.z=z*szorzo;
	return ret;
}

void VECTOR::operator *= (float szorzo) // vektor hosszt 
{
	x*=szorzo;
	y*=szorzo;
	z*=szorzo;
}

void VECTOR::operator *= (double szorzo) // vektor hosszt 
{
	x=float(x*szorzo);
	y=float(y*szorzo);
	z=float(z*szorzo);
}

VECTOR VECTOR::operator * (const VECTOR& b) // cross product
{
	VECTOR n;
	n.x = y*b.z - z*b.y;
	n.y = z*b.x - x*b.z;
	n.z = x*b.y - y*b.x;
	return n;
}


VECTOR VECTOR::operator / (float ezzel)
{
	VECTOR ret;
	ret.x=x/ezzel;
	ret.y=y/ezzel;
	ret.z=z/ezzel;
	return ret;
}

void VECTOR::operator /= (float ezzel)
{
	x/=ezzel;
	y/=ezzel;
	z/=ezzel;
}

VECTOR::operator += (const VECTOR& eztadd)
{
	x+=eztadd.x;
	y+=eztadd.y;
	z+=eztadd.z;

}

VECTOR::operator -= (const VECTOR& eztadd)
{
	x-=eztadd.x;
	y-=eztadd.y;
	z-=eztadd.z;

}

double VECTOR::Normalize()
{
	double hosz=sqrt(double(x)*x+double(y)*y+double(z)*z);
	if(hosz==0.0) {x=0;y=0;z=0;return 0.0;}
	x=(float)(x/hosz);
	y=(float)(y/hosz);
	z=(float)(z/hosz);
	return hosz;
}

// dot-product
float VECTOR::operator % (const VECTOR& dp)
{
	return (x*dp.x+y*dp.y+z*dp.z);
}

bool VECTOR::operator == (const VECTOR& ezzel)
{
	float d;
	d=x-ezzel.x;
	if(d<0) {if(d<-VECTOR_EQUAL_PRECISION) return false;}
	else {if(d>VECTOR_EQUAL_PRECISION) return false;}

	d=y-ezzel.y;
	if(d<0) {if(d<-VECTOR_EQUAL_PRECISION) return false;}
	else {if(d>VECTOR_EQUAL_PRECISION) return false;}

	d=z-ezzel.z;
	if(d<0) {if(d<-VECTOR_EQUAL_PRECISION) return false;}
	else {if(d>VECTOR_EQUAL_PRECISION) return false;}

	return true;
}


float VECTOR::DotProduct(VECTOR &ezzel)
{
	return (x*ezzel.x+y*ezzel.y+z*ezzel.z);

}
// kt vektor tvolsgnak a ngyzete (ciklikus sszehasonltshoz, pl melyik a legkzelebbi stb.)
double VECTOR::GetSubLenSquared(const VECTOR &ezzel)
{
	double sx=double(x)-ezzel.x;
	double sy=double(y)-ezzel.y;
	double sz=double(z)-ezzel.z;
	return (sx*sx+sy*sy+sz*sz); //remlem gy gyorsabb
}

double VECTOR::GetLen()
{
	return(sqrt(x*x+y*y+z*z) );
}

VECTOR VECTOR::GetNeg()
{
	return VECTOR(-x,-y,-z);
}

// kell a dupla pontossg nem is gondoln az ember mennyire..
double VECTOR::DotProductDouble(VECTOR &ezzel)
{
	return (double(x)*ezzel.x+y*ezzel.y+z*ezzel.z);
}

VECTOR VECTOR::operator * (double szorzo) // vektor hosszt 
{
	VECTOR ret;
	ret.x=float(x*szorzo);
	ret.y=float(y*szorzo);
	ret.z=float(z*szorzo);
	return ret;
}

bool VECTOR::IsZero()
{
	if( fabs(x-0.0)<VECTOR_EQUAL_PRECISION &&
		fabs(y-0.0)<VECTOR_EQUAL_PRECISION &&
		fabs(z-0.0)<VECTOR_EQUAL_PRECISION
		)
		return true;
	return false;
}

float VECTOR::DotProduct(float xx, float yy, float zz)
{
	return (x*xx+y*yy+z*zz);

}

// hossznak ngyzete
float VECTOR::GetLenSQ()
{
	return (x*x + y*y + z*z);
}

// |v|=1? -VECTOR_EQUAL_PRECISION
bool VECTOR::IsNorma()
{
	float len=GetLenSQ();
	if(len<(1.f-VECTOR_EQUAL_PRECISION) || len>(1.f+VECTOR_EQUAL_PRECISION)) return false;
	return true;
}

// merleges vektort ad vissza ha lehet s normlja a normalize>0
// vigyzat usethisvec_pleeze esetn usethisvec_pleeze*this (BALRA FORGAT)
VECTOR VECTOR::GetAPerpendicular(char normalize,VECTOR* usethisvec_pleeze)
{
	VECTOR n=*this;
	if(n.IsZero()) {n=VNULL;return n;} // nincs mit tenni


	if(usethisvec_pleeze) // van mivel normat csinlni
	{
		VECTOR mv=(*usethisvec_pleeze)*n;
		if(!mv.IsZero()) 
		{
			mv.Normalize();
			return mv;
		}
		// nem lehet vele egy egyenesre esnek.. menjnk tovbb
	}

	n.x=-y; n.y=x; n.z=0.f;

	if(n.IsZero())
	{
		n.x=-z; n.y=0.f; n.z=x;
		if(n.IsZero())
		{
			n.x=0.f; n.y=-z; n.z=y;
		}
	}

	if(normalize) n.Normalize();

	return n;
}

void VECTOR::neg()
{
	x=-x;y=-y;z=-z;
}

bool VECTOR::operator !=(VECTOR &ezzel)
{
	float d;
	d=x-ezzel.x;
	if(d<0) {if(d<-VECTOR_EQUAL_PRECISION) return true;}
	else {if(d>VECTOR_EQUAL_PRECISION) return true;}

	d=y-ezzel.y;
	if(d<0) {if(d<-VECTOR_EQUAL_PRECISION) return true;}
	else {if(d>VECTOR_EQUAL_PRECISION) return true;}

	d=z-ezzel.z;
	if(d<0) {if(d<-VECTOR_EQUAL_PRECISION) return true;}
	else {if(d>VECTOR_EQUAL_PRECISION) return true;}

	return false;
}

// norml polivektorokbl
bool VECTOR::IamPoliNormal(VECTOR *polivec, int vecnum)
{
	if(vecnum<3) return false;
	(*this)=(polivec[0]-polivec[1]) * (polivec[1]-polivec[2]);
	Normalize();
	return true;
}

// 2 vektor elg kzeli-e egymshoz koordintk alapjn no sqrt()
int VECTOR::CoordEQ(VECTOR *masik, float diff)
{
	float d;
	d = x-masik->x; if(d<0) d=-d;
	if(d>diff) return 0;
	d = y-masik->y; if(d<0) d=-d;
	if(d>diff) return 0;
	d = z-masik->z; if(d<0) d=-d;
	if(d>diff) return 0;
	return 1;
}
