#include "WinDraw.h"

char	CWinInfo::KEY[KEY_num];
HWND	CWinInfo::AblakHandle=NULL;
int		CWinInfo::TerminateProgram=0;
int		CWinInfo::Windowed=0;

CWinDraw::CWinDraw()
{
	CWinInfo cwi;
	memset(cwi.KEY,0,KEY_num);
	Mywnd  = NULL;	

}

CWinDraw::~CWinDraw()
{
	Call_X_EndWindow();	// vge az ablaknak
}

// az ablak flslegess vlsa esetn ki lehet kapcsolni ezzel
// (destruktor is megteszi)
void CWinDraw::Call_X_EndWindow()
{
	UnregisterClass(WindowName,Myinstance);
	Mywnd  = NULL;	// kikapcs.
}


// ennek a fggvnynek a cme kerl be, mint az a cm amelyre kerljn a vezrls
// ha zenet rkezik az ablaknak
// billenty lenyomsra a megfelel KEY[index] rtk 0-1-lesz s ebbe kerlnek az egr
// gombok is
LRESULT CALLBACK CWinDraw::WndProc(HWND hwnd, UINT message,WPARAM wparam, LPARAM lparam)
{
	switch (message)
	{
		case WM_DESTROY:
		PostQuitMessage(0); // megrkezett az jobb sarokba a kattints: kilps
		return 0;
		// Keyboard ------------------------------
		case WM_KEYDOWN:
		CWinInfo::KEY[wparam]=1;
		return 0;
		case WM_KEYUP:
		CWinInfo::KEY[wparam]=0;
		return 0;
		// Mouse ------------------------
		case WM_LBUTTONDOWN:
		CWinInfo::KEY[MOUSE_LB]=1;
		return 0;
		case WM_LBUTTONUP:
		CWinInfo::KEY[MOUSE_LB]=0;
		return 0;
		case WM_RBUTTONDOWN:
		CWinInfo::KEY[MOUSE_RB]=1;
		return 0;
		case WM_RBUTTONUP:
		CWinInfo::KEY[MOUSE_RB]=0;
		return 0;
		case WM_MBUTTONDOWN:
		CWinInfo::KEY[MOUSE_MB]=1;
		return 0;
		case WM_MBUTTONUP:
		CWinInfo::KEY[MOUSE_MB]=0;
		return 0; // next : MWHEEL
   } 
   return DefWindowProc(hwnd, message, wparam, lparam);
}

/* 
Ablak ltrehozsa:
	title : ablak neve
	windowed = 1 alakban fut
	x_,y_size ablak mrete
	background httr BGR sznkomponense
*/
bool CWinDraw::Call_1_MakeWindow(char *title,int windowed,int x_size,int y_size,DWORD backgroundcolor)
{
	Myinstance=GetModuleHandle(0);

	int cx=(GetSystemMetrics(SM_CXSCREEN) >> 1) - (x_size >> 1),
		cy=(GetSystemMetrics(SM_CYSCREEN) >> 1) - (y_size >> 1); // ablak balfels sarka

	if(!windowed) // full scr
	{
		cx=cy=0;
		x_size=GetSystemMetrics(SM_CXSCREEN);
		y_size=GetSystemMetrics(SM_CYSCREEN);
	}

	WNDCLASS wd;
	wd.cbClsExtra=0;
	wd.cbWndExtra=0;
	wd.hCursor=LoadCursor(NULL,IDC_CROSS); // CURSOR ALAKJA: kereszt (mi ms lehetne!)
	wd.hbrBackground=CreateSolidBrush(backgroundcolor);// Httr szne (HBRUSH)GetStockObject(background); // httr szne: fekete
	wd.hIcon=NULL;
	wd.hInstance=Myinstance; // kell -ezt kaptuk a winmain-be a belpskor a rendszertl
	wd.lpfnWndProc=WndProc; // egy fggvny neve, mely kezeli az ablakzeneteket (lsd egyel fejjebb)
	wd.lpszClassName=TEXT("MyD3D");  // az osztlyunk neve
	wd.lpszMenuName=TEXT("");		// nincs mennk (gy neve se).
	wd.style=CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS; 

	RegisterClass(&wd); // sajt ablak-osztlyunk regisztrcija

	DWORD fullscr = (WS_TILEDWINDOW | WS_POPUP); // alap: ablakban fut
	if(!windowed) fullscr = WS_POPUP;


	Mywnd=CreateWindowEx(
		0,//WS_EX_TOPMOST, // ekkor mindg fell van
		TEXT("MyD3D"),
		TEXT(title),
		fullscr,
		cx,cy, // ablak bal fels sarka a kpernyn.
		x_size,  // kperny mrete
		y_size,
		NULL, // a szlablak hwnd-je
		NULL, // ablak menu
		Myinstance,
		NULL  // MDi fle struktra
		);

	if (!Mywnd)
	{
		MessageBox(NULL,"Nem sikerlt ablakot ltrehozni!","FATAL ERROR - No window created!",MB_OK);
		return false;
	}

	WindoweD=windowed;  
	ScrSizeX=x_size;
	ScrSizeY=y_size;

	ShowWindow(Mywnd,SW_SHOW); // ablak indul!!!
	UpdateWindow(Mywnd); // sok pldba benne van.. de ide nem igazn fontos
	SetFocus(Mywnd); // az ablakunk kapja a meg a vezrlst

	strcpy(WindowName,title);

	MessagePump.AblakHandle=Mywnd; // legyen meg az ablak handle mindenhol (static miatt)
	MessagePump.Windowed=windowed;

	return true;
}

// ha esetleg kellene az ablak handle-je
HWND CWinDraw::GetWnd()
{
	return Mywnd;
}


// ablak zeneteket innen is lehet lekrdezni
int CWinDraw::Call_2_GetMessage()
{
	return MessagePump.GetMeAMessage();
}
