// camera.cpp: implementation of the Ccamera class.
//
//////////////////////////////////////////////////////////////////////

#include "camera.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Ccamera::Ccamera()
{
	v_pos		=VECTOR(0,0,0);	// hol van a kamera
	v_direction	=VECTOR(0,0,1);	// merre nz (+v_eye)
	v_up		=VECTOR(0,1,0);	// merre van neki a felfele
	ResetDegrees();
	FocalPixelDegreeResolution = 0.2f;
	P_FocalAngle = 45.f;
	P_NearPlane  = 0.2f;
	P_FarPlane   = 500.f;
	VectorsIsComputed = 0;
	MatrixIsComputed=0;
}


// ktfle belltsi lehetsg van, vagy a vektorokat mindet direct 
// vagy az elforduls szgeit + post
// amelyiket nem akarjuk belltani, lehet NULL-t adni neki!
void Ccamera::Call_SetVECTORS(VECTOR* pos,VECTOR* direction,VECTOR* up)
{
	if(pos)			v_pos		= (*pos);
	if(direction)	v_direction	= (*direction);
	if(up)			v_up		= (*up);
		else v_up	= VECTOR(0,1,0);

	if(direction)
	{
		genaretedegreesfromvec();
		VectorsIsComputed = 1; // vektorok vannak belltva
	}
	MatrixIsComputed=0;

}


void Ccamera::Call_SetDegrees(VECTOR* pos,float yaw, float pitch, float roll)
{
	v_pos		= (*pos);
	YawDegree	= yaw;	
	PitchDegree	= pitch;	
	RollDegree	= roll;	

	VectorsIsComputed=0; 
	MatrixIsComputed=0;
}

// szgek
void Ccamera::Call_Get_degrees(float *yaw, float *pitch, float *roll)
{
	(*yaw)		= YawDegree;
	(*pitch)	= PitchDegree;
	if(roll)	(*roll)	= RollDegree;
}

// kamera pos
VECTOR Ccamera::Get_eye(VECTOR *eye)
{	
	if(eye) (*eye)=v_pos;
	return v_pos;
}

// GetV_lookat volt de talaktottam!
// return : amerre nz nem a lookat!
VECTOR Ccamera::Get_direction(VECTOR *dir)
{
	if(!VectorsIsComputed) computevectorsfromangle(); // ha nincsennek kiszmolva : legyenek!

	if(dir) (*dir) = v_direction;
	return v_direction;
}

// ilyet is lehessen, hozzadja a szgeket
void Ccamera::Call_AddDegrees(float yaw, float pitch, float roll)
{
	const float max_p = 88.f;
	// ennl tbb nem kellhet:
	if(pitch>max_p) pitch=max_p;
	else
	if(pitch<-max_p) pitch=-max_p;

	YawDegree+=yaw;	
	PitchDegree+=pitch;	
	RollDegree+=roll;

	// nzzk nem mentek-e tl (amgy nincs nagy baj vele csak a 2.nl)
	// yaw 0-360, pitch -89.99 -> +89.99

	if(YawDegree>360.0) YawDegree-=(int(YawDegree/360)*360);
	else
	if(YawDegree<0.0) YawDegree+=(DWORD(YawDegree/360)+1)*360.f;     //((int(YawDegree/360)+1)*360);


	if(PitchDegree>max_p) PitchDegree = max_p; //(int(PitchDegree/max_p)*max_p);
	else
	if(PitchDegree<-max_p) PitchDegree= -max_p; // ((int(PitchDegree/max_p)-1)*max_p);


	if(RollDegree>360.0) RollDegree-=(int(RollDegree/360)*360);
	else
	if(RollDegree<0.0) RollDegree+=(DWORD(RollDegree/360)+1)*360.f;

	VectorsIsComputed=0;
	MatrixIsComputed=0;
}

// minden nulla
void Ccamera::ResetDegrees()
{
	YawDegree=PitchDegree=RollDegree=0.0f;
	VectorsIsComputed=0;
	MatrixIsComputed=0;
}

// lltsuk be a nzs ltszgt, meg a legkzelebbi, legtvolabbi dolgot, amit ltunk
// FONTOS!
int Ccamera::Call_1_SetFrustrum(float latoszog, float kozel,float tavol)
{
	P_FocalAngle = latoszog;
	P_NearPlane	 = kozel;
	P_FarPlane	 = tavol;


	MATRIX proj;
	proj.PerspectiveFovLH(latoszog,float(4)/3,kozel,tavol);
	DeviceInfo.GetDevice()->SetTransform(D3DTS_PROJECTION, (D3DXMATRIX*)&proj);
	return 1;
}

// kiszmolja a szgeket az egr elmozdulsbl
// az rzkenysggel
// az egr RELATV elmozdulsa kell (eljeles . directinputbl lett visszabuttva)
void Ccamera::Call_SpinCameraToMouse(int mousex, int mousey)
{
	computedegrees(mousex,mousey);
}

// kiszmtja az egr rzkenygbl s a ltszgbl mennyit mozduljon el a kamera 
// ltszge (eredetileg directinput-bl szrmaznak az egrcoo-k, gy negatvak is lehetnek)
void Ccamera::computedegrees(int x, int y)
{
	// minl kisebb a ltszg (snipy) annl kevesebb szggel fordul
	float pix = FocalPixelDegreeResolution * (P_FocalAngle / 45.f); // 1 pixelre es fokelforduls
	Call_AddDegrees(x*pix,y*pix,0);
}

// ezt meg lehet hni hogy kiszmolja a view mtrixot az adataibl 
// kzvetlen (szg vec) bellts utn
void Ccamera::creatematrix(MATRIX* pView)
{
	VECTOR l;

	if(!VectorsIsComputed) computevectorsfromangle(); // ha mg nem lennnek vektorok

	l = v_pos + v_direction; // lookat

	View.LookatLH(&v_pos,&l,&v_up); // view mtrix kiszmolsa
	MatrixIsComputed=1;

	if(pView) (*pView) = View; 
}

// szgekbl kiszmolja a vektorokat...
void Ccamera::computevectorsfromangle()
{
	if(!VectorsIsComputed) // nincsennek tlleg kiszmolva?
	{
		MATRIX mat;
		mat.RotXYZ(YawDegree,PitchDegree,RollDegree);
		v_direction = mat * VECTOR(0,0,1); 
		v_up = mat * VECTOR(0,1,0); // up
		VectorsIsComputed = 1;
	}
}

// az egr egy pixel elmozdulsra hny fokot mozduljon el (tnyleg ms felbontsnl ms lesz az rzkenysg?)
void Ccamera::Call_SetMouseResPerPixel(float degree)
{
	if(degree>2.f || degree<-2.f) degree = 0.1f; // elvileg negatvnak nem kne lennie mert megfordul az irnyts
	FocalPixelDegreeResolution = degree;
}


// szgek kiszmolsa vektorbl (lookat)
// bug: ha fgglegesen felfele mutatna (nem szabad!) akkor ugye a yaw-t nem lehet kiszmolni
void Ccamera::genaretedegreesfromvec()
{

	// vzszintes vetlet:
	VECTOR horiz = v_direction;
	horiz.y = 0.0f;
	horiz.Normalize();
	if(!horiz.IsZero()) // nem nulla a vektor mrete
	{
		// tlet : igaz hogy : horiz.z = horiz.DotProduct(VECTOR(0,0,1)) ? 
		double yaw = ONE_DEG * acos(horiz.DotProduct(VECTOR(0,0,1))); // elforduls radinban * ONE_DEG
		YawDegree = float (yaw); 
		// most nzzk a kt vektor normjt (jobbra forgat) ha felfele nz akkor a szg 0-180
		// ha lefele akkor 360-yaw - csak nem ad vissza negatv szget..
		VECTOR n = horiz * VECTOR(0,0,1);
		if(n.y<0) // >180 
			YawDegree = 360-YawDegree;
	}
	else YawDegree = 0.f;

	// fggleges forduls
	VECTOR vertic = v_direction;
	vertic.x = 0.0f;
	vertic.Normalize();
	if(!vertic.IsZero()) // nem nulla a vektor mrete
	{
		double pitch = ONE_DEG * acos(vertic.DotProduct(VECTOR(0,0,1))); // elforduls radinban * ONE_DEG
		PitchDegree = float (pitch); 
		VECTOR n = vertic * VECTOR(0,0,1);
		if(n.x<0) // >180 
			PitchDegree = 360-PitchDegree;
	}
	else PitchDegree = 0.f;

}

// view mtrix lekrdezse - return==1 akkor rvnyes
char Ccamera::Call_GetViewMatrix(MATRIX **pMatrix)
{
	(*pMatrix) = &View;
	return MatrixIsComputed;
}

// simn a post lehet megadni
void Ccamera::Call_SetPos(VECTOR *pos)
{
	v_pos = (*pos);
}

// csak a nzs irnya
void Ccamera::Call_SetDirection(VECTOR *direction)
{
	v_direction	= (*direction);
	VectorsIsComputed = 1; // vektorok vannak belltva
	v_up = VECTOR(0,1,0); // hogy ez is be legyen lltva ?
	genaretedegreesfromvec();
}

// a forgats s mozgats vgn ezt kell hvni, ez lltja el a 
// d3d-s view mtrixot
void Ccamera::Call_MAKEVIEWMATRIX(MATRIX *pView)
{
	creatematrix(&View);
	if(pView) pView = &View;
}

// ezt meghvva lltja be d3d-ben is a mtrixot (eddig csak kiszmolta)
// ha param nem NULL akkor onnan veszi a mtrixot
// else a bels haszn. ha egyik se j, vagy nincs d3d, akkor ret = 0
char Ccamera::Call_SETMATRIXtoGPU(MATRIX *pView)
{
	MATRIX *m=pView;
	if(!pView) 
	{
		if(!MatrixIsComputed) return 0;
		m = &View;
	}

	if(!DeviceInfo.GetDevice()) return 0;

	DeviceInfo.GetDevice()->SetTransform(D3DTS_VIEW,((D3DXMATRIX*)m));

	return 1;
}
