/*
kamera class:
	fontosabb adatok:
		pozcija
		irnya - vektorral vagy szgekkel
		up vector (0,1,0) ltalban
		nylsszge
		kptl arnya (4/3)
*/

#if !defined(AFX_CAMERA_H__4543A29F_5D4C_42D2_8FD8_4D82526B7F94__INCLUDED_)
#define AFX_CAMERA_H__4543A29F_5D4C_42D2_8FD8_4D82526B7F94__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "d3dDevice.h"
#include "vector.h"
#include "matrix.h"

class Ccamera  
{
public:
	char Call_SETMATRIXtoGPU(MATRIX* pView=NULL);
	void Call_SetVECTORS(VECTOR* pos,VECTOR* direction,VECTOR* up=NULL);
	void Call_SetDegrees(VECTOR* pos,float yaw, float pitch, float roll);
	void Call_Get_degrees(float *yaw, float *pitch, float *roll);
	VECTOR Get_eye(VECTOR *eye=NULL);
	VECTOR Get_direction(VECTOR *dir=NULL);
	void Call_AddDegrees(float yaw, float pitch, float roll);
	void ResetDegrees();
	int Call_1_SetFrustrum(float latoszog, float kozel,float tavol);
	void Call_SpinCameraToMouse(int mousex, int mousey);
	void Call_SetMouseResPerPixel(float degree);
	char Call_GetViewMatrix(MATRIX **pMatrix);
	void Call_SetPos(VECTOR *pos);
	void Call_SetDirection(VECTOR *direction);
	void Call_MAKEVIEWMATRIX(MATRIX *pView=NULL);
	Ccamera();
	~Ccamera() {};
protected:
	float FocalPixelDegreeResolution; // adott ltszg esetn hny fokot forduljon a kamera 1 pixel elm-ra.
	float P_FocalAngle;	// hny fokos a ltszg.
	float P_NearPlane;	// igen
	float P_FarPlane;	// igen 2 frustrum belltsa - kztk a z buffer

	VECTOR v_pos;		// (eye)hol van a kamera
	VECTOR v_direction;	// (lookat-eye) merre nz (+v_eye = lookat)
	VECTOR v_up;		// merre van neki a felfele
	char VectorsIsComputed; // ha ==1 akkor ki van mr szmolva a szgekbl az irny+up,ha 0 akkor mg ki kell szmolni
	char MatrixIsComputed;	// ha ==1 akkor view mtrix ki van szmolva

	float YawDegree;		// y krl
	float PitchDegree;		// x krl
	float RollDegree;		// z krl - spec effect?

	MATRIX View;			// view mtrix

	CDeviceInfo DeviceInfo;	// adatok a kperny mretrl

	void computedegrees(int x, int y);
	void computevectorsfromangle();
	void genaretedegreesfromvec();
	void creatematrix(MATRIX* pView);

};

#endif // !defined(AFX_CAMERA_H__4543A29F_5D4C_42D2_8FD8_4D82526B7F94__INCLUDED_)
