;Dialog p/ comear um novo jogo
alias pacman {
  if (-* iswm $1) {
    if (c isincs $1) { pac.config }
    if (e isincs $1) { pac.novo }
    if (a isincs $1) { pac.abrir }
  }
  else { pac.njogo }
}
alias -l pac.njogo { dialog - $+ $iif($dialog(pac.njogo),v,m) pac.njogo pac.njogo }
dialog pac.njogo {
  icon $pac.ico
  title "Pacman - New Game"
  size -1 -1 110 100
  box "", 1, 0 0 110 70
  radio "Levels", 2, 5 10 88 15
  radio "Specified", 3, 5 26 70 15
  combo 4, 5 43 100 50, disabled size drop
  button "Ok", 5, 5 75 50 20
  button "Close", 6, 55 75 50 20, cancel
}
on *:dialog:pac.njogo:*:*: {
  if ($devent == INIT) {
    did -c $dname 2
    pac.lista normal pac.njogo 4
    did -c $dname 4 1
  }
  if ($devent == SCLICK) { 
    if ($did isnum 2-3) { did - $+ $iif($did == 2,-b,-e) $dname 4 }
    if ($did == 5) {
      if ($did(2).state) { set %pacj.rodada 1 | pac.inicia | dialog -x $dname }
      elseif ($did(4).sel) { set %pacj.rodada 1 | pac.inicia $ifmatch | dialog -x $dname }
    }
  }
}
;Dialog de configuraes
alias -l pac.config { dialog $+(-,$iif($dialog(pac.config),v,m)) pac.config pac.config }
dialog pac.config {
  icon $pac.ico
  title "Pacman - Config"
  size -1 -1 90 72
  option dbu
  box "Config", 2, 0 1 90 71
  text "Lifes:", 3, 3 10 17 8
  button "&Ok", 5, 27 60 35 9
  combo 6, 20 9 17 50, size drop
  box "Speed", 7, 2 22 86 4
  text "Move each", 8, 3 30 36 8
  edit "", 9, 39 29 17 10, autohs
  text "miliseconds", 10, 57 30 33 8
  box "Sound Effects", 11, 2 40 86 4, disable
  check "Sound", 12, 3 47 26 10, disable
  check "Music", 13, 36 47 31 10, disable
  box "", 14, 2 54 86 4
  icon 15, 71 6 32 32, $pac.ico
}
on *:dialog:pac.config:*:*: {
  if ($devent == INIT) { 
    didtok $dname 6 32 1 2 3
    did -c $dname 6 %pacn.vidas
    did -a $dname 9 %pacn.velo
    if (%pacn.sons) { did -c $dname 12 }
    if (%pacn.music) { did -c $dname 13 }
  }
  if ($devent == SCLICK) {
    if ($did == 6) { set %pacn.vidas $did(6).sel }
    if ($did == 12) { set %pacn.sons $did(12).state }
    if ($did == 13) { set %pacn.music $did(13).state }
    if ($did == 5) {
      if ($did(9) !isnum) { return $input(The speed should be a number!,516,Pacman) }
      set %pacn.velo $did(9)
      dialog -x $dname
    }
  }
}
;Inicia o jogo
alias -l pac.inicia {
  set %pacj.fase $iif($0,$1,1)
  if (%pacj.rodada) {
    set %pacj.modo $iif($0,normal,fase)
    if (!$window(@Pacman)) {
      window -BCpkhad +tn @Pacman -1 -1 358 400 $pac.ico
      window -ph +d @Pacman.h -1 -1 354 354
      window -ph +d @Pacman.h2 -1 -1 354 354
      window -ph +d @Pacman.h3 -1 -1 354 354
      window -ph +d @Pacman.h4 -1 -1 354 354
    }
  }
  set %pacj.cordeboa 0
  set %pacj.cornumpassa 255
  set %pacj.corcomidinha 65280
  set %pacj.corcomidona 16711680
  set %pacj.corbrutos 65535
  set %pacj.ler $+(%pacj.fase,,%pacj.modo)

  var %mapa = $readini($pac.img(mapas.ini),%pacj.ler,mapa),%pac.xy = $readini($pac.img(mapas.ini),%pacj.ler,pacman)
  set %pacj.mapasel $gettok(%mapa,1,181)
  set %pacj.mapa $gettok(%mapa,2,181)
  set %pacj.x $calc($gettok(%pac.xy,1,32) *32)
  set %pacj.y $calc($gettok(%pac.xy,2,32) *32)

  drawrect -fr @Pacman 0 1 0 0 354 400
  drawrect -fr @Pacman.h3 %pacj.cordeboa 1 0 0 354 354

  drawline -r @Pacman 16777215 1 105 121 248 121 105 121 105 169
  drawline -r @Pacman 8421504 1 105 169 248 169 248 169 248 121
  drawtext -r @Pacman 13027014 Verdana 12 135 124 Loading:
  var %t = $iif(%pacj.fase,Level %pacj.fase,Specified)
  drawtext -r @Pacman 16777215 Verdana 12 $calc((233-106/2) - ($width(%t,Verdana,12) /2)) 138 %t
  drawrect -r @Pacman 13027014 1 115 156 123 8

  var %a = $readini($pac.img(mapas.ini),%pacj.ler,fantasmas),%b = $numtok(%a,32),%c,%d
  while (%b) {
    var %c = $gettok(%a,%b,32),%d = $left(%c,1)
    set $($+(%,pacj.fant.x.,%d)) $calc($gettok(%c,2,181) *32)
    set $($+(%,pacj.fant.y.,%d)) $calc($gettok(%c,3,181) *32)
    dec %b
  }
  var %x = 0,%y = 0,%c = 1,%d,%e,%f,%g,%h,%i
  while (%y < 11) && (%c < 122) {
    if (%x > 10) { var %x = 0 | inc %y }
    var %d = $mid(%pacj.mapa,%c,1),%e = $calc(%x *32),%f = $calc(%y *32),%g = $pac.abrircor(%d),%h = $iif(%g == 65280,14,$iif(%g == 16711680,11,0)),%i = $iif(%g == 65280,4,$iif(%g == 16711680,9,32))
    drawpic -c @Pacman.h $calc(%x *32) $calc(%y *32) 0 $calc(%pacj.mapasel *32) 32 32 $pac.bmp

    if (%d != 1) {
      drawpic -ct @Pacman.h $pac.t %e %f $pac.abrirxy(%d,%pacj.mapasel) 32 32 $pac.bmp
      drawrect -rf @Pacman.h3 %g 1 $calc(%e + %h) $calc(%f + %h) %i %i
    }
    drawrect -rf @Pacman 16777215 1 117 158 $calc(120* %c /122) 4
    inc %x
    inc %c
  }

  drawcopy @Pacman.h 0 0 354 354 @Pacman.h2 0 0
  drawcopy @Pacman.h3 0 0 354 354 @Pacman.h4 0 0
  drawpic -tc @Pacman.h2 $pac.t %pacj.x %pacj.y 0 160 32 32 $pac.bmp

  if (%pacj.fant.x.v != $null) { drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.v %pacj.fant.y.v 0 352 32 32 $pac.bmp | drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.v %pacj.fant.y.v 96 320 32 32 $pac.bmp | drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.v +4) $calc(%pacj.fant.y.v +1) 23 29 }
  if (%pacj.fant.x.m != $null) { drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.m %pacj.fant.y.m 32 352 32 32 $pac.bmp | drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.m %pacj.fant.y.m 96 320 32 32 $pac.bmp | drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.m +4) $calc(%pacj.fant.y.m +1) 23 29 }
  if (%pacj.fant.x.r != $null) { drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.r %pacj.fant.y.r 64 352 32 32 $pac.bmp | drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.r %pacj.fant.y.r 96 320 32 32 $pac.bmp | drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.r +4) $calc(%pacj.fant.y.r +1) 23 29 }
  if (%pacj.fant.x.a != $null) { drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.a %pacj.fant.y.a 96 352 32 32 $pac.bmp | drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.a %pacj.fant.y.a 96 320 32 32 $pac.bmp | drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.a +4) $calc(%pacj.fant.y.a +1) 23 29 }
  if (%pacj.fant.x.l != $null) { drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.l %pacj.fant.y.l 128 352 32 32 $pac.bmp | drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.l %pacj.fant.y.l 96 320 32 32 $pac.bmp | drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.l +4) $calc(%pacj.fant.y.l +1) 23 29 }

  drawcopy @Pacman.h2 0 0 354 354 @Pacman 0 0
  drawline -r @Pacman 16777215 1 0 352 354 352
  drawrect -r @Pacman 16777215 1 1 354 350 20
  drawrect -r @Pacman 16777215 1 3 356 42 16
  if (!%pacj.vidas) { set %pacj.vidas %pacn.vidas }
  pac.vidas
  if (!%pacj.pts) { set %pacj.pts 0 }
  drawrect -r @Pacman 16777215 1 46 356 60 16
  drawtext -r @Pacman 13027014 "Ms Serif" 13 $iif(%pacj.fase,58,48) 356 $iif(%pacj.fase,Level %pacj.fase,Specified)
  drawrect -r @Pacman 16777215 1 107 356 109 16
  drawtext -r @Pacman 13027014 "Ms Serif" 13 113 356 Speed: %pacn.velo ms
  drawrect -r @Pacman 16777215 1 217 356 132 16
  drawtext -r @Pacman 13027014 "Ms Serif" 13 226 356 Points: $base(%pacj.pts,10,10,5) pts.
  set %pacj.pacdirecao 160
  set %pacj.b 0
  set %pacj.bb 0
  if (%pacj.fant.x.v != $null) { set %pacj.v.dir $calc($r(0,3) *32) }
  if (%pacj.fant.x.m != $null) { set %pacj.m.dir $calc($r(0,3) *32) }
  if (%pacj.fant.x.r != $null) { set %pacj.r.dir $calc($r(0,3) *32) }
  if (%pacj.fant.x.a != $null) { set %pacj.a.dir $calc($r(0,3) *32) }
  if (%pacj.fant.x.l != $null) { set %pacj.l.dir $calc($r(0,3) *32) }
  .timerPAC -m 0 %pacn.velo pac.pacman
}
;Alias onde o jogo  atualizado
alias -l pac.pacman {
  if (%pacj.rodada) { unset %pacj.rodada }
  if (!$count(%pacj.mapa,4)) && (!$count(%pacj.mapa,5)) { pac.passou | return }
  drawcopy @Pacman.h 0 0 354 354 @Pacman.h2 0 0
  drawcopy @Pacman.h3 0 0 354 354 @Pacman.h4 0 0

  if (32 // %pacj.x) {
    if (%pacj.direspera == 256) && (%pacj.pacdirecao != 256) && ($getdot(@Pacman.h4,$calc(%pacj.x +16),$calc(%pacj.y -1)) != %pacj.cornumpassa) { set %pacj.pacdirecao 256 }
    elseif (%pacj.direspera == 192) && (%pacj.pacdirecao != 192) && ($getdot(@Pacman.h4,$calc(%pacj.x +16),$calc(%pacj.y +33)) != %pacj.cornumpassa) { set %pacj.pacdirecao 192 }
  }
  if (32 // %pacj.y) {
    if (%pacj.direspera == 224) && (%pacj.pacdirecao != 224) && ($getdot(@Pacman.h4,$calc(%pacj.x -1),$calc(%pacj.y +16)) != %pacj.cornumpassa) { set %pacj.pacdirecao 224 }
    elseif (%pacj.direspera == 160) && (%pacj.pacdirecao != 160) && ($getdot(@Pacman.h4,$calc(%pacj.x +33),$calc(%pacj.y +16)) != %pacj.cornumpassa) { set %pacj.pacdirecao 160 }
  }
  if (!%pacj.morrer) {
    if ($getdot(@Pacman.h4,$iif($istok(160.224,%pacj.pacdirecao,46),$calc(%pacj.x $pac.sinal(s) $pac.sinal(t)),$calc(%pacj.x +16)),$iif($istok(192.256,%pacj.pacdirecao,46),$calc(%pacj.y $pac.sinal(s) $pac.sinal(t)),$calc(%pacj.y +16))) != %pacj.cornumpassa) {
      if ($istok(160.192,%pacj.pacdirecao,46)) && ($calc($iif(%pacj.pacdirecao == 160,%pacj.x,%pacj.y) +33) < 352) { pac.id }
      if ($istok(224.256,%pacj.pacdirecao,46)) && ($calc($iif(%pacj.pacdirecao == 224,%pacj.x,%pacj.y) -1) > 0) { pac.id }
    }
    var %gx = $iif($istok(160.224,%pacj.pacdirecao,46),$calc(%pacj.x + $iif(%pacj.pacdirecao == 160,28,2)),$calc(%pacj.x +16))), %gy = $iif($istok(192.256,%pacj.pacdirecao,46),$calc(%pacj.y + $iif(%pacj.pacdirecao == 192,28,2)),$calc(%pacj.y +16)))
    if ($getdot(@Pacman.h4,%gx,%gy) == %pacj.corcomidinha) {
      drawpic -ct @Pacman.h $pac.t $calc($int($calc(%gx /32)) *32) $calc($int($calc(%gy /32)) *32) 0 $calc(%pacj.mapasel *32) 32 32 $pac.bmp
      drawrect -rf @Pacman.h3 %pacj.cordeboa 1 $calc($int($calc(%gx /32)) *32) $calc($int($calc(%gy /32)) *32) 32 32
      pac.escrevej $pac.mcalcj($int($calc(%gx /32)),$int($calc(%gy /32)))
      inc %pacj.pts 5
      pac.updpts
    }
    elseif ($getdot(@Pacman.h4,%gx,%gy) == %pacj.corcomidona) {
      var %w = $calc($int($calc(%gx /32)) *32),%z = $calc($int($calc(%gy /32)) *32)
      drawpic -ct @Pacman.h $pac.t %w %z 0 $calc(%pacj.mapasel *32) 32 32 $pac.bmp
      drawrect -rf @Pacman.h3 %pacj.cordeboa 1 %w %z 32 32
      pac.escrevej $pac.mcalcj($int($calc(%gx /32)),$int($calc(%gy /32)))
      inc %pacj.pts 10
      pac.updpts
      set %pacj.ff 1
      set %pacj.f 1
    }
  }
  if (%pacj.f) {
    inc %pacj.f
    set %pacj.ff $iif(%pacj.ff,0,1)
    if (%pacj.f > 50) { unset %pacj.f %pacj.ff }
  }
  if (%pacj.fant.x.v != $null) {
    pac.meche.fant v
    if (!%pacj.ff) {
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.v %pacj.fant.y.v 0 352 32 32 $pac.bmp
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.v %pacj.fant.y.v %pacj.v.dir 320 32 32 $pac.bmp
    }
    drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.v + 4) $calc(%pacj.fant.y.v + 1) 23 29
  }
  if (%pacj.fant.x.m != $null) {
    pac.meche.fant m
    if (!%pacj.ff) {
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.m %pacj.fant.y.m 32 352 32 32 $pac.bmp
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.m %pacj.fant.y.m %pacj.m.dir 320 32 32 $pac.bmp
    }
    drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.m + 4) $calc(%pacj.fant.y.m + 1) 23 29
  }
  if (%pacj.fant.x.r != $null) {
    pac.meche.fant r
    if (!%pacj.ff) {
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.r %pacj.fant.y.r 64 352 32 32 $pac.bmp
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.r %pacj.fant.y.r %pacj.r.dir 320 32 32 $pac.bmp
    }
    drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.r + 4) $calc(%pacj.fant.y.r + 1) 23 29
  }
  if (%pacj.fant.x.a != $null) {
    pac.meche.fant a
    if (!%pacj.ff) {
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.a %pacj.fant.y.a 96 352 32 32 $pac.bmp
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.a %pacj.fant.y.a %pacj.a.dir 320 32 32 $pac.bmp
    }
    drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.a + 4) $calc(%pacj.fant.y.a + 1) 23 29
  }
  if (%pacj.fant.x.l != $null) {
    pac.meche.fant l
    if (!%pacj.ff) {
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.l %pacj.fant.y.l 128 352 32 32 $pac.bmp
      drawpic -tc @Pacman.h2 $pac.t %pacj.fant.x.l %pacj.fant.y.l %pacj.l.dir 320 32 32 $pac.bmp
    }
    drawrect -fr @Pacman.h4 %pacj.corbrutos 1 $calc(%pacj.fant.x.l + 4) $calc(%pacj.fant.y.l + 1) 23 29
  }
  if (!%pacj.morrer) {
    if (%pacj.pisca) {
      inc %pacj.pisca
      if (2 // %pacj.pisca) { drawpic -tc @Pacman.h2 $pac.t %pacj.x %pacj.y $calc(%pacj.b *32) %pacj.pacdirecao 32 32 $pac.bmp }
      if (%pacj.pisca > 50) { unset %pacj.pisca }
    }
    else {
      drawpic -tc @Pacman.h2 $pac.t %pacj.x %pacj.y $calc(%pacj.b *32) %pacj.pacdirecao 32 32 $pac.bmp
      var %vx1 = $calc(%pacj.x +28),%vx2 = $calc(%pacj.x +2),%vx3 = $calc(%pacj.x +16),%vy1 = $calc(%pacj.y +28),%vy2 = $calc(%pacj.y +2),%vy3 = $calc(%pacj.y +16),%cb = %pacj.corbrutos,%verif = $pac.verif(%vx1,%vy3) $pac.verif(%vx3,%vy1) $pac.verif(%vx2,%vy3) $pac.verif(%vx3,%vy2)
      ;verifica se o pacman no bateu em nenhum fantasma
      if ($istok(%verif,%cb,32)) {
        if (%pacj.f) {
          if ($int($calc(%pacj.fant.x.v /32)) == $int($calc(%pacj.x /32))) && ($int($calc(%pacj.fant.y.v /32)) == $int($calc(%pacj.y /32))) { set %pacj.fant.x.v 0 | set %pacj.fant.y.v 0 }
          if ($int($calc(%pacj.fant.x.m /32)) == $int($calc(%pacj.x /32))) && ($int($calc(%pacj.fant.y.m /32)) == $int($calc(%pacj.y /32))) { set %pacj.fant.x.m 0 | set %pacj.fant.y.m 0 }
          if ($int($calc(%pacj.fant.x.r /32)) == $int($calc(%pacj.x /32))) && ($int($calc(%pacj.fant.y.r /32)) == $int($calc(%pacj.y /32))) { set %pacj.fant.x.r 0 | set %pacj.fant.y.r 0 }
          if ($int($calc(%pacj.fant.x.a /32)) == $int($calc(%pacj.x /32))) && ($int($calc(%pacj.fant.y.a /32)) == $int($calc(%pacj.y /32))) { set %pacj.fant.x.a 0 | set %pacj.fant.y.a 0 }
          if ($int($calc(%pacj.fant.x.l /32)) == $int($calc(%pacj.x /32))) && ($int($calc(%pacj.fant.y.l /32)) == $int($calc(%pacj.y /32))) { set %pacj.fant.x.l 0 | set %pacj.fant.y.l 0 }
        }
        else {
          set %pacj.morrer 1
          set %mp 0
          dec %pacj.vidas
          pac.vidas
        }
      }
    }
    inc %pacj.bb
    if (%pacj.bb > 3) {
      inc %pacj.b
      if (%pacj.b > 2) { set %pacj.b 0 | set %pacj.bb 0 }
    }
  }
  else {
    drawpic -tc @Pacman.h2 $pac.t %pacj.x %pacj.y $calc(%mp * 32) 288 32 32 $pac.bmp
    inc %mpp
    if (%mpp > 4) {
      inc %mp
      set %mpp 0
      if (%mp > 3) {
        unset %pacj.morrer %mpp %mp
        if (%pacj.vidas < 1) { pac.fim | halt }
        set %pacj.pisca 1
      }
    }
  }
  drawcopy @Pacman.h2 0 0 354 354 @Pacman 0 0
}
;Aliases do jogo
alias -l pac.verif { return $getdot(@Pacman.h4,$1,$2) }
alias -l pac.sinal { if ($istok(160.192,%pacj.pacdirecao,46)) { return $iif($1 == s,+,33) } | else { return $iif($1 == s,-,1) } }
alias -l pac.id {
  if ($istok(160.192,%pacj.pacdirecao,46)) { if (%pacj.pacdirecao == 160) { inc %pacj.x 6.4 } | else { inc %pacj.y 6.4 } }
  else { if (%pacj.pacdirecao == 224) { dec %pacj.x 6.4 } | else { dec %pacj.y 6.4 } }
}
alias -l pac.vidas {
  drawrect -fr @Pacman 1 1 4 357 40 13
  var %a = 0
  while (%a < %pacj.vidas) {
    drawpic -tc @Pacman $pac.t $calc(5 + (%a * 13)) 358 144 0 12 12 $pac.bmp
    inc %a
  }
}
alias -l pac.passou {
  .timerPAC off
  inc %pacj.pts 20
  if (%pacj.modo == fase) {
    inc %pacj.fase
    var %a = $+(%pacj.fase,,fase)
    if ($ini($pac.img(mapas.ini),%a)) { pac.inicia %pacj.fase }
    else { goto hoon }
    return
    :hoon
  }
  drawrect -fr @Pacman 0 1 0 0 354 400
  drawtext -r @Pacman 13027014 "Ms Serif" 20 80 70 End Game
  drawtext -r @Pacman 13027014 "Ms Serif" 20 80 100 Points: $base(%pacj.pts,10,10,5) pts.
}

;Inteligncia Artificial dos Fantasmas
alias -l pac.meche.fant {
  var %fx = $($+(%,pacj.fant.x.,$1),2), %fy = $($+(%,pacj.fant.y.,$1),2)
  if (32 // %fx) && (32 // %fy) {
    var %r = $r(1,2)
    if (%r == 2) { set $($+(%,pacj.,$1,.dir)) $iif(%pacj.x <= %fx,0,64) }
    else { set $($+(%,pacj.,$1,.dir)) $iif(%pacj.y <= %fy,32,96) }
    :shannon
    if ($($+(%,pacj.,$1,.dir),2) == 0) && (($getdot(@Pacman.h4,$calc(%fx -1),$calc(%fy +16)) == %pacj.cornumpassa) || ($calc(%fx -1) < 0)) {
      set $($+(%,pacj.,$1,.dir)) $gettok(32.64.96,$r(1,3),46)
      goto shannon
    }
    if ($($+(%,pacj.,$1,.dir),2) == 32) && (($getdot(@Pacman.h4,$calc(%fx +16),$calc(%fy -1)) == %pacj.cornumpassa) || ($calc(%fy -1) < 0)) {
      set $($+(%,pacj.,$1,.dir)) $gettok(0.64.96,$r(1,3),46)
      goto shannon
    }
    if ($($+(%,pacj.,$1,.dir),2) == 64) && (($getdot(@Pacman.h4,$calc(%fx +33),$calc(%fy +16)) == %pacj.cornumpassa) || ($calc(%fx +33) > 352)) {
      set $($+(%,pacj.,$1,.dir)) $gettok(0.32.96,$r(1,3),46)
      goto shannon
    }
    if ($($+(%,pacj.,$1,.dir),2) == 96) && (($getdot(@Pacman.h4,$calc(%fx +16),$calc(%fy +33)) == %pacj.cornumpassa) || ($calc(%fy +33) > 352)) {
      set $($+(%,pacj.,$1,.dir)) $gettok(0.32.64,$r(1,3),46)
      goto shannon
    }
    pac.id.fant $1
  }
  else { pac.id.fant $1 }
}
alias -l pac.id.fant {
  if ($istok(64.96,$($+(%,pacj.,$1,.dir),2),46)) {
    if ($($+(%,pacj.,$1,.dir),2) == 64) { inc $($+(%,pacj.fant.x.,$1)) 6.4 }
    else { inc $($+(%,pacj.fant.y.,$1)) 6.4 }
  }
  else {
    if ($($+(%,pacj.,$1,.dir),2) == 0) { dec $($+(%,pacj.fant.x.,$1)) 6.4 }
    else { dec $($+(%,pacj.fant.y.,$1)) 6.4 }
  }
}
alias -l pac.mcalcj { return $calc(($1 +1) + ($2 *11)) }
alias -l pac.escrevej { set %pacj.mapa $+($left(%pacj.mapa,$calc($1 -1)),1,$right(%pacj.mapa,- $+ $1)) }
alias -l pac.updpts {
  drawrect -rf @Pacman 0 1 218 357 129 13
  drawtext -r @Pacman 13027014 "Ms Serif" 13 226 356 Points: $base(%pacj.pts,10,10,5) pts.
}
alias -l pac.fim { .timerPAC off }

;Evento das teclas direcionais
on *:KEYDOWN:@Pacman:*:{
  if ($keyval == 38) { set %pacj.direspera 256 }
  if ($keyval == 40) { set %pacj.direspera 192 }
  if ($keyval == 37) { set %pacj.direspera 224 }
  if ($keyval == 39) { set %pacj.direspera 160 }
}

;Dialog p/ fazer um novo mapa
alias -l pac.novo { dialog $+(-,$iif($dialog(pac.novo),v,m)) pac.novo pac.novo }
dialog pac.novo {
  icon $pac.img(pacman.ico)
  title "Pacman - New Map"
  size -1 -1 88 72
  option dbu
  box "", 11, 0 0 88 72
  text "Set map type:", 6, 3 6 63 8
  combo 7, 3 15 62 50, size drop
  box "", 8, 3 25 82 4
  box "Preview", 9, 2 30 84 27
  icon 10, 19 38 50 15 0, $pac.ico, noborder
  icon 12, 68 8 32 32, $pac.ico
  button "&Ok", 13, 14 59 30 10, ok
  button "&Close", 14, 45 59 30 10, cancel
}
on *:dialog:pac.novo:*:*: {
  tokenize 32 $devent $did $dname
  if ($1 == init) {
    didtok $3 7 46 Estilo 1.Estilo 2.Estilo 3.Estilo 4.Estilo 5 | did -c $3 7 1 | var %a 1, %b 6
    while (%a < %b) {
      var %c = $+(@pac.estilo,%a) | window -ph +d %c 0 0 96 32 | drawrect -rf %c $rgb(face) 1 0 0 96 32
      drawpic -ct %c $pac.t 0 0 0 $calc((%a - 1) * 32) 96 32 $pac.bmp | drawsave %c $pac.img($+(estilo,%a,.bmp))
      window -c %c | inc %a
    }
    did -g $3 10 $pac.img(estilo1.bmp)
  }
  if ($1 == sclick) {
    if ($2 == 7) { did -g $3 10 $pac.img($+(estilo,$did(7).sel,.bmp)) }
    if ($2 == 13) { if (!$hget(pac.editor)) { hmake pac.editor 10 } | hadd pac.editor mapasel $calc($did(7).sel - 1) | pac.remover | pac.editor -n $calc($did(7).sel - 1) }
    if ($2 == 14) { pac.remover }
  }
}

;Dialog para abrir um mapa pronto
alias -l pac.abrir { dialog $+(-,$iif($dialog(pac.abrir),v,m)) pac.abrir pac.abrir }
dialog pac.abrir {
  icon $pac.img(pacman.ico)
  title "Pacman - Open Map"
  size -1 -1 77 85
  option dbu
  box "", 1, 0 0 77 85
  combo 2, 3 6 71 50, size drop
  list 3, 3 18 71 50, size
  box "", 4, 3 66 71 4
  button "&Ok", 5, 8 72 30 10, ok, disabled
  button "&Close", 6, 39 72 30 10, cancel
}
on *:dialog:pac.abrir:*:*: {
  tokenize 32 $devent $did $dname
  if ($1 == init) { did -a $3 2 Level maps | did -a $3 2 Separated maps | did -c $3 2 1 | pac.lista fase pac.abrir 3 }
  if ($1 == sclick) {
    if ($2 == 2) { did -b $3 5 | if ($did($2).sel == 1) { pac.lista fase pac.abrir 3 } | elseif ($did($2).sel == 2) { pac.lista normal pac.abrir 3 } }
    if ($2 == 3) { if ($did($2).sel) { did -e $3 5 } | else { did -b $3 5 } }
    if ($2 == 5) { pac.editor -a $did(3).sel $iif($did(2).sel == 1,fase,normal) }
  }
  if ($1 == dclick) {
    if ($2 == 3) { pac.editor -a $did(3).sel $iif($did(2).sel == 1,fase,normal) | dialog -x $3 }
  }
}
;/pac.editor <-na> <numero do mapa|numero do mapa*> <condio>
;-n cria um novo mapa
;-a abre um mapa j pronto
;numero do mapa  o nmero do estilo do mapa (usado em conjunto com -n)
;;0 - Estilo 1; 1 - Estilo 2; 2 - Estilo 3; 3 - Estilo 4; 4 - Estilo 5
;numero do mapa*  o nmero do mapa a ser aberto (usado em conjunto com -a)
;;Vide mapas.ini
;condio especifica se o mapa a ser aberto  fase ou um mapa especfico (usado em conjunto com -a)
alias -l pac.editor {
  if (!$window(@Editor)) {
    window -BCpkhad +tn @Editor -1 -1 358 460 $pac.img(pacman.ico)
    window -ph +d @Editor.h -1 -1 354 354
    window -ph +d @Editor.h2 -1 -1 354 354
    window -ph +d @Editor.h3 -1 -1 354 354
  }
  drawrect -rf @Editor 13684944 1 0 0 358 460
  if ($1 == -n) {
    var %a 0, %b 0
    while (%b < 11) {
      if (%a > 10) { var %a = 0 | inc %b }
      drawpic -c @Editor.h $calc(%a * 32) $calc(%b * 32) 0 $calc($2 * 32) 32 32 $pac.bmp
      inc %a
    }
    hadd pac.editor sel 1 11 3 0 $calc($hget(pac.editor,mapasel) * 32)
    hadd pac.editor mapa $str(1,121)
    drawcopy @Editor.h 0 0 354 354 @Editor 0 0
    drawcopy @Editor.h 0 0 354 354 @Editor.h2 0 0
    drawcopy @Editor.h 0 0 354 354 @Editor.h3 0 0
  }
  if ($1 == -a) {
    unset %pac.come.*
    var %a 0, %b 0, %c 1, %d $+($2,,$3), %k $gettok($readini($pac.img(mapas.ini),$+($2,,$3),mapa),1,181)
    while (%b < 11) && (%c < 122) {
      var %e = $mid($gettok($readini($pac.img(mapas.ini),%d,mapa),2,181),%c,1)
      if (%a > 10) { var %a = 0 | inc %b }
      drawpic -c @Editor.h $calc(%a * 32) $calc(%b * 32) 0 $calc(%k * 32) 32 32 $pac.bmp
      drawpic -c @Editor.h3 $calc(%a * 32) $calc(%b * 32) 0 $calc(%k * 32) 32 32 $pac.bmp
      if (%e != 1) { drawpic -ct @Editor.h $pac.t $calc(%a * 32) $calc(%b * 32) $gettok($pac.abrirxy(%e,%k),1,32) $gettok($pac.abrirxy(%e,%k),2,32) 32 32 $pac.bmp }
      inc %a
      inc %c
    }
    if (!$hget(pac.editor)) { hmake pac.editor 10 }
    hadd pac.editor mapasel %k
    hadd pac.editor sel 1 11 3 0 $calc(%k * 32)
    hadd pac.editor mapa $gettok($readini($pac.img(mapas.ini),%d,mapa),2,181)
    set %pac.come.xy 1 | set %pac.come.x $gettok($readini($pac.img(mapas.ini),%d,pacman),1,32) | set %pac.come.y $gettok($readini($pac.img(mapas.ini),%d,pacman),2,32)
    drawpic -ct @Editor.h $pac.t $calc(%pac.come.x * 32) $calc(%pac.come.y * 32) 0 160 32 32 $pac.bmp
    var %1 = $readini($pac.img(mapas.ini),%d,fantasmas), %2 $numtok(%1,32)
    while (%2) {
      set %pac.come. $+ $gettok($gettok(%1,%2,32),1,181) 1
      set %pac.come. $+ $+($gettok($gettok(%1,%2,32),1,181),x) $gettok($gettok(%1,%2,32),2,181)
      set %pac.come. $+ $+($gettok($gettok(%1,%2,32),1,181),y) $gettok($gettok(%1,%2,32),3,181)
      var %# = $gettok($gettok(%1,%2,32),1,181)
      var %x % [ $+ [ pac.come. [ $+ [ $+(%#,x) ] ] ] ], %y % [ $+ [ pac.come. [ $+ [ $+(%#,y) ] ] ] ]
      drawpic -ct @Editor.h $pac.t $calc(%x * 32) $calc(%y * 32) $iif(%# == v,0,$iif(%# == m,32,$iif(%# == r,64,$iif(%# == a,96,$iif(%# == l,128))))) 352 32 32 $pac.bmp
      drawpic -ct @Editor.h $pac.t $calc(%x * 32) $calc(%y * 32) 96 320 32 32 $pac.bmp
      dec %2
    }
  }
  drawline -r @Editor 8421504 1 0 352 358 352
  drawline -r @Editor 16777215 1 0 353 358 353
  drawline -r @Editor 8421504 1 4 402 346 402
  drawline -r @Editor 16777215 1 4 403 346 403
  $button(@Editor,23,410,55,20,13684944,16777215,8421504,pac.limpar,3,0,1,Clear,0,Ms sans,12)
  $button(@Editor,84,410,55,20,13684944,16777215,8421504,pac.salvar,3,0,1,Save,0,Ms sans,12)
  $button(@Editor,145,410,55,20,13684944,16777215,8421504,pac.abrir,3,0,1,Open,0,Ms sans,12)
  drawline -r @Editor 8421504 1 206 407 206 432
  drawline -r @Editor 16777215 1 207 407 207 432
  $button(@Editor,214,410,55,20,13684944,16777215,8421504,$iif($isfile($scriptdirpacman.txt),run " $+ $scriptdirpacman.txt"),3,0,1,Help,0,Ms sans,12)
  $button(@Editor,275,410,55,20,13684944,16777215,8421504,pac.fechar 1,3,0,1,Close,0,Ms sans,12)
  hadd pac.editor fantcor 1
  pac.tool 11 3 0 $calc($hget(pac.editor,mapasel) * 32) 2 1 hash
  pac.tool 55 3 32 $calc($hget(pac.editor,mapasel) * 32) 1 1 hash
  pac.tool 99 3 64 $calc($hget(pac.editor,mapasel) * 32) 1 1 hash
  pac.tool 143 3 128 320 1 1 hash
  pac.tool 187 3 160 320 1 1 hash
  pac.tool 231 3 0 160 1 1 hash
  pac.tool 275 3 0 352 1 2 hash
}
;;;Alias da toolbar do editor
;/pac.tool <x y> <x2 y2> <N> <N2> [N3]
;x - coordenada x do boto da toolbar
;y - coordenada y do boto da toolbar
;x2 - coordenada x da imagem do boto no pacman.bmp
;y2 - coordenada y da imagem do boto no pacman.bmp
;N - 1 para normal; 2 para checado; 3 para mouse em cima
;N2 - 2 para copiar para a janela principal, 1 para no copiar
;N3 - qualquer valor para adicionar na hash table
alias -l pac.tool {
  if (!$window(@Pac.tool)) { 
    window -ph +tn @Pac.tool 358 46
    drawrect -rf @Pac.tool 13684944 1 0 0 358 46
  }
  drawrect -rf @Pac.tool 13684944 1 $calc($1 - 1) $2 42 41
  if ($7) {
    if (!$hget(pac.tools)) { hmake pac.tools 7 }
    var %a = $hget(pac.tools,0).item
    hadd pac.tools $+(pac.tools,.,$calc(%a + 1)) $calc(%a + 1) $1 $2 $3 $4 $5 $6
  }
  if ($5 != 1) { 
    drawline -r @Pac.tool $iif($5 == 2,8421504,16777215) 1 $1 $2 $calc($1 + 39) $2 $1 $2 $1 $calc($2 +39)  
    drawline -r @Pac.tool $iif($5 == 2,16777215,8421504) 1 $1 $calc($2 + 39) $calc($1 + 40) $calc($2 + 39) $calc($1 + 40) $calc($2 + 39) $calc($1 + 40) $calc($2 - 1)
  }
  if ($5 == 2) { drawrect -rf @Pac.tool 15132390 1 $calc($1 + 1) $calc($2 + 1) 39 38 }
  drawpic -ct @Pac.tool $pac.t $calc($1 + $iif($5 == 2,5,4)) $calc($2 + $iif($5 == 2,5,4)) $3 $4 32 32 $pac.bmp
  if ($1 == 275) { drawpic -ct @Pac.tool $pac.t $calc($1 + $iif($5 == 2,5,4)) $calc($2 + $iif($5 == 2,5,4)) 96 320 32 32 $pac.bmp }
  drawpic -c @Pac.tool 317 3 $iif($gettok($hget(pac.tools,pac.tools.7),6,32) == 3,112,96) 0 16 40 $pac.bmp
  if ($6 == 2) { drawcopy @Pac.tool 0 0 358 46 @Editor 1 354 }
}
;Eventos do mouse no editor
menu @Editor {
  sclick: {
    var %i = 1
    while ($hget(button. $+ $active,%i)) {
      tokenize 59 $ifmatch
      if ($inrect($mouse.x,$mouse.y,$1,$2,$3,$4)) {
        hadd -m history. $+ $active 0 %i
        click 1 %i
        break
      }
      inc %i
    }
    if ($inrect($mouse.x,$mouse.y,0,0,351,351)) {
      var %sel $gettok($hget(pac.editor,sel),1,32)
      if (%sel == 6) && (!%pac.come.xy) {
        set %pac.come.xy 1
        set %pac.come.x $pac.x
        set %pac.come.y $pac.y
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 0 $calc($hget(pac.editor,mapasel) * 32) 32 32 $pac.bmp
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) $gettok($hget(pac.editor,sel),4-,32) 32 32 $pac.bmp
        pac.escreve 1 $pac.mcalc
        pac.unsetfant
        pac.dcps
      }
      if (%sel != 6) && ($pac.x == %pac.come.x) && ($pac.y == %pac.come.y) {
        if (%sel == 7) && (% [ $+ [ $+(pac.come.,$pac.nc($hget(pac.editor,fantcor))) ] ]) { goto ok }
        unset %pac.come.x %pac.come.y %pac.come.xy 
      }
      :ok
      if (%sel == 7) && (!% [ $+ [ $+(pac.come.,$pac.nc($hget(pac.editor,fantcor))) ] ]) {
        pac.unsetfant
        set %pac.come. $+ $pac.nc($hget(pac.editor,fantcor)) 1
        set %pac.come. $+ $+($pac.nc($hget(pac.editor,fantcor)),x) $pac.x
        set %pac.come. $+ $+($pac.nc($hget(pac.editor,fantcor)),y) $pac.y
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 0 $calc($hget(pac.editor,mapasel) * 32) 32 32 $pac.bmp
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) $gettok($hget(pac.editor,sel),4-,32) 32 32 $pac.bmp
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 96 320 32 32 $pac.bmp
        pac.escreve 1 $pac.mcalc
        pac.dcps
      }
      if (%sel != 6) && (%sel != 7) {
        pac.unsetfant
        pac.escreve $gettok($hget(pac.editor,sel),1,32) $pac.mcalc
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 0 $calc($hget(pac.editor,mapasel) * 32) 32 32 $pac.bmp
        drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) $gettok($hget(pac.editor,sel),4-,32) 32 32 $pac.bmp
        pac.dcps
      }
    }
    var %a $hget(pac.tools,0).item, %b
    while ($hget(pac.tools,%a).item) {
      var %b = $hget(pac.tools,$ifmatch)
      tokenize 32 %b
      if ($inrect($mouse.x,$mouse.y,$2,$calc($3 + 354),40,40) && $6 != 2) { 
        pac.tool $gettok($hget(pac.editor,sel),2-,32) 1 1
        pac.tool $2 $3 $4 $5 2 2
        hadd pac.tools $+(pac.tools,.,$gettok($hget(pac.editor,sel),1,32)) $gettok($hget(pac.editor,sel),1-,32) 1 $7
        hadd pac.tools $+(pac.tools,.,$1) $1 $2 $3 $4 $5 2 $7
        hadd pac.editor sel $1 $2 $3 $4 $5
      }
      dec %a
    }
    if ($inrect($mouse.x,$mouse.y,318,357,15,40)) {
      drawpic -c @Pac.tool 317 3 128 0 16 40 $pac.bmp
      drawcopy @Pac.tool 0 0 358 46 @Editor 1 354
      pac.menu $mouse.x $mouse.y
    }
  }
  mouse: {
    if ($hget(history. $+ $active,0)) { click 2 $ifmatch }
    if ($inrect($mouse.x,$mouse.y,0,0,351,351)) {
      if ($mouse.key & 1) {
        var %sel $gettok($hget(pac.editor,sel),1,32)
        if (%sel == 6) && (!%pac.come.xy) {
          set %pac.come.xy 1
          set %pac.come.x $pac.x
          set %pac.come.y $pac.y
          drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 0 $calc($hget(pac.editor,mapasel) * 32) 32 32 $pac.bmp
          drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) $gettok($hget(pac.editor,sel),4-,32) 32 32 $pac.bmp
          pac.escreve 1 $pac.mcalc
          pac.unsetfant
          pac.dcps
        }
        if (%sel != 6) && ($pac.x == %pac.come.x) && ($pac.y == %pac.come.y) {
          if (%sel == 7) && (% [ $+ [ $+(pac.come.,$pac.nc($hget(pac.editor,fantcor))) ] ]) { goto ok }
          unset %pac.come.x %pac.come.y %pac.come.xy 
        }
        :ok
        if (%sel == 7) && (!% [ $+ [ $+(pac.come.,$pac.nc($hget(pac.editor,fantcor))) ] ]) {
          pac.unsetfant
          set %pac.come. $+ $pac.nc($hget(pac.editor,fantcor)) 1
          set %pac.come. $+ $+($pac.nc($hget(pac.editor,fantcor)),x) $pac.x
          set %pac.come. $+ $+($pac.nc($hget(pac.editor,fantcor)),y) $pac.y
          drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 0 $calc($hget(pac.editor,mapasel) * 32) 32 32 $pac.bmp
          drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) $gettok($hget(pac.editor,sel),4-,32) 32 32 $pac.bmp
          pac.escreve 1 $pac.mcalc
          pac.dcps
        }
        if (%sel != 6) && (%sel != 7) {
          pac.unsetfant
          pac.escreve $gettok($hget(pac.editor,sel),1,32) $pac.mcalc
          drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) 0 $calc($hget(pac.editor,mapasel) * 32) 32 32 $pac.bmp
          drawpic -ct @Editor.h $pac.t $calc($pac.x * 32) $calc($pac.y * 32) $gettok($hget(pac.editor,sel),4-,32) 32 32 $pac.bmp
          pac.dcps
          drawline -r @Editor 8421504 1 0 352 358 352
        }
      }
      else {
        drawpic -ct @Editor.h2 $pac.t $calc($int($calc($mouse.x / 32)) * 32) $calc($int($calc($mouse.y / 32)) * 32) 129 288 32 32 $pac.bmp
        drawcopy @Editor.h2 0 0 354 354 @Editor 0 0
        drawcopy @Editor.h 0 0 354 354 @Editor.h2 0 0
      }
    }
    else {
      drawcopy @Editor.h2 0 0 354 354 @Editor 0 0
      drawcopy @Editor.h 0 0 354 354 @Editor.h2 0 0
    }
    var %a $hget(pac.tools,0).item, %b
    while ($hget(pac.tools,%a).item) {
      var %b = $hget(pac.tools,$ifmatch)
      tokenize 32 %b
      if ($inrect($mouse.x,$mouse.y,$2,$calc($3 + 354),$iif($1 == 7,60,40),40) && $6 != 2) { 
        pac.tool $2 $3 $4 $5 3 2
        hadd pac.tools $+(pac.tools,.,$1) $1 $2 $3 $4 $5 3 $7
      }
      elseif ($6 == 3) { 
        hadd pac.tools $+(pac.tools,.,$1) $1 $2 $3 $4 $5 1 $7
        pac.tool $2 $3 $4 $5 1 2 
      }
      dec %a
    }
    if (!$pac.dll && $inrect($mouse.x,$mouse.y,318,357,15,40) && $gettok($hget(pac.tools,pac.tools.7),6,32) == 2) {
      drawpic -c @Pac.tool 317 3 112 0 16 40 $pac.bmp
      drawcopy @Pac.tool 0 0 358 46 @Editor 1 354
    }
    elseif (!$inrect($mouse.x,$mouse.y,318,357,15,40) && !$pac.dll && $gettok($hget(pac.tools,pac.tools.7),6,32) == 2) {
      drawpic -c @Pac.tool 317 3 96 0 16 40 $pac.bmp
      drawcopy @Pac.tool 0 0 358 46 @Editor 1 354
    }
  }
  uclick: {
    if ($hget(history. $+ $active,0)) click 3 $ifmatch
    if ($inrect($mouse.x,$mouse.y,0,0,351,351)) {
      drawpic -ct @Editor.h2 $pac.t $calc($int($calc($mouse.x / 32)) * 32) $calc($int($calc($mouse.y / 32)) * 32) 129 288 32 32 $pac.bmp
      drawcopy @Editor.h2 0 0 354 354 @Editor 0 0
      drawcopy @Editor.h 0 0 354 354 @Editor.h2 0 0
    }
  }
  leave: {
    drawcopy @Editor.h2 0 0 354 354 @Editor 0 0
    drawcopy @Editor.h 0 0 354 354 @Editor.h2 0 0
    var %a $hget(pac.tools,0).item, %b
    while ($hget(pac.tools,%a).item) {
      var %b = $hget(pac.tools,$ifmatch)
      tokenize 32 %b
      if ($6 == 3) { 
        pac.tool $2 $3 $4 $5 1 2
        hadd pac.tools $+(pac.tools,.,$1) $1 $2 $3 $4 $5 1 $7
        if ($!pac.dll && $gettok($hget(pac.tools,pac.tools.7),6,32) == 2) {
          drawpic -c @Pac.tool 317 3 96 0 16 40 $pac.bmp
          drawcopy @Pac.tool 0 0 358 46 @Editor 1 354
        }
      }
      dec %a
    }
    if (!$pac.dll) {
      drawpic -c @Pac.tool 317 3 96 0 16 40 $pac.bmp
      drawcopy @Pac.tool 0 0 358 46 @Editor 1 354
    }
  }
  New Map:{
    hfree pac.editor
    hfree pac.tools
    unset %pac.come.*
    pac.novo
  }
}
;Aliases do editor
alias -l pac.x { return $int($calc($mouse.x / 32)) }
alias -l pac.y { return $int($calc($mouse.y / 32)) }
alias -l pac.mcalc { return $calc(($pac.x + 1) + ($pac.y * 11)) }
alias -l pac.escreve {
  var %' $hget(pac.editor,mapa)
  hadd pac.editor mapa $+($left(%',$calc($2 - 1)),$1,$right(%',$+(-,$2)))
}
alias -l pac.img { return $+(",$scriptdir,$1-,") }
alias -l pac.ico  { return $pac.img(pacman.ico) }
alias -l pac.bmp { return $pac.img(pacman.bmp) }
alias -l pac.t { return 16711935 }
alias -l pac.nc { return $replace($1,1,v,2,m,3,r,4,a,5,l) }
alias -l pac.limpar {
  hadd pac.editor mapa $str(1,121)
  unset %pac.come.*
  drawcopy @Editor.h3 0 0 354 354 @Editor 0 0
  drawcopy @Editor.h3 0 0 354 354 @Editor.h 0 0
  drawcopy @Editor.h3 0 0 354 354 @Editor.h2 0 0
}
alias -l pac.salvar {
  if (!%pac.come.r) && (!%pac.come.a) && (!%pac.come.m) && (!%pac.come.v) && (!%pac.come.l) {
    var %e $input(The map need a ghost!,516,Pacman)
    halt
  }
  if (!%pac.come.xy) {
    var %e $input(Set start position of the pacman!,516,Pacman)
    halt
  }
  var %n.autor $input(Author Name:,133,Pacman)
  if ($input(Added this map to levels pack?,136,Pacman)) {
    var %f $pac.lista(fase)
    writeini -n $pac.img(mapas.ini) $+(%f,,fase) autor $iif(%n.autor,%n.autor,Anonymous)
    writeini -n $pac.img(mapas.ini) $+(%f,,fase) mapa $+($hget(pac.editor,mapasel),,$hget(pac.editor,mapa))
    writeini -n $pac.img(mapas.ini) $+(%f,,fase) pacman %pac.come.x %pac.come.y
    writeini -n $pac.img(mapas.ini) $+(%f,,fase) fantasmas $iif(%pac.come.v,$+(v,,%pac.come.vx,,%pac.come.vy)) $iif(%pac.come.m,$+(m,,%pac.come.mx,,%pac.come.my)) $iif(%pac.come.r,$+(r,,%pac.come.rx,,%pac.come.ry)) $iif(%pac.come.a,$+(a,,%pac.come.ax,,%pac.come.ay)) $iif(%pac.come.l,$+(l,,%pac.come.lx,,%pac.come.ly))
  }
  else {
    var %n $pac.lista(normal)
    writeini -n $pac.img(mapas.ini) $+(%n,,normal) autor $iif(%n.autor,%n.autor,Anonymous)
    writeini -n $pac.img(mapas.ini) $+(%n,,normal) mapa $+($hget(pac.editor,mapasel),,$hget(pac.editor,mapa))
    writeini -n $pac.img(mapas.ini) $+(%n,,normal) pacman %pac.come.x %pac.come.y
    writeini -n $pac.img(mapas.ini) $+(%n,,normal) fantasmas $iif(%pac.come.v,$+(v,,%pac.come.vx,,%pac.come.vy)) $iif(%pac.come.m,$+(m,,%pac.come.mx,,%pac.come.my)) $iif(%pac.come.r,$+(r,,%pac.come.rx,,%pac.come.ry)) $iif(%pac.come.a,$+(a,,%pac.come.ax,,%pac.come.ay)) $iif(%pac.come.l,$+(l,,%pac.come.lx,,%pac.come.ly))
  }
}
alias -l pac.ini {
  var %a $ini($pac.img(mapas.ini),0), %b 0
  while (%a) {
    if ($gettok($ini($pac.img(mapas.ini),%a),2,181) == fase) && ($1 == fase) { inc %b }
    elseif ($gettok($ini($pac.img(mapas.ini),%a),2,181) == normal) && ($1 == normal) { inc %b }
    dec %a
  }
  return $calc(%b + 1)
}
alias -l pac.lista {
  if (!$isid) { did -r $2 $3 }
  var %a 1, %b $ini($pac.img(mapas.ini),0), %c 0
  while (%a <= %b) {
    if ($gettok($ini($pac.img(mapas.ini),%a),2,181) == $1) {
      if (!$isid) { did -a $2 $3 Map $gettok($ini($pac.img(mapas.ini),%a),1,181) }
      else { inc %c }
    }
    inc %a
  }
  if ($isid) { return $calc(%c + 1) }
}
alias -l pac.dcps { drawcopy @Editor.h 0 0 354 354 @Editor 0 0 | drawcopy @Editor.h 0 0 354 354 @Editor.h2 0 0 }
alias -l pac.unsetfant {
  var %a $var(%pac.come.*x,0)
  while (%a) {
    if ($len($var(%pac.come.*x,%a)) == 12) {
      if ($pac.x == $var(%pac.come.*x,%a).value) && ($pac.y == $var(%pac.come.*y,%a).value) { 
        unset % [ $+ [ $+(pac.come.,$mid($var(%pac.come.*x,%a),11,1),*) ] ]     
      }
    }
    elseif ($gettok($hget(pac.editor,sel),1,32) == 7) {
      if ($pac.x == %pac.come.x) && ($pac.y == %pac.come.y) { unset %pac.come.x %pac.come.y %pac.come.xy }
    }
    dec %a
  }
}
alias -l pac.remover {
  var %a = 5
  while (%a) {
    if ($exists($pac.img($+(estilo,%a,.bmp)))) { .remove $pac.img($+(estilo,%a,.bmp)) }
    dec %a
  }
}
alias -l pac.dll {
  var %d $dll(0)
  while (%d) {
    if (%d == $pac.img(flatpopz.dll)) { var %s 1 }
    dec %d
  }
  return $iif(%s,1,0)
}
alias -l pac.menu {
  var %a $pac.img(flatpopz.dll)
  dll %a FlatCoords $1 $2
  dll %a FlatTextColor 0
  dll %a FlatBackColor 13684944
  dll %a FlatBorderColor 8421504
  dll %a FlatBarColor 8421504
  dll %a FlatBarText 13684944
  dll %a FlatGrayColor 8421504
  dll %a FlatFont 8 > Verdana
  dll %a FlatAppend 0 > +bx > &Select the ghost color
  dll %a FlatAppend 0 > + > -
  dll %a FlatAppend 1 > $iif($hget(pac.editor,fantcor) == 1,+gx,+) > Green
  dll %a FlatAppend 2 > $iif($hget(pac.editor,fantcor) == 2,+gx,+) > Red
  dll %a FlatAppend 3 > $iif($hget(pac.editor,fantcor) == 3,+gx,+) > Purple
  dll %a FlatAppend 4 > $iif($hget(pac.editor,fantcor) == 4,+gx,+) > Yellow
  dll %a FlatAppend 5 > $iif($hget(pac.editor,fantcor) == 5,+gx,+) > Orange
  var %pac.menu $dll($pac.img(flatpopz.dll),Activate,$window(@Editor).hwnd)
  dll -u $pac.img(flatpopz.dll)
  if (%pac.menu isnum) { 
    var %a 275 3 $calc((%pac.menu - 1) * 32) 352 $gettok($hget(pac.tools,pac.tools.7),6,32) 2
    hadd pac.editor fantcor %pac.menu
    pac.tool %a
    hadd pac.tools pac.tools.7 7 %a
    if ($gettok($hget(pac.tools,pac.tools.7),6,32) == 2) { hadd pac.editor sel $gettok($hget(pac.editor,sel),1-3,32) $calc((%pac.menu - 1) * 32) $gettok($hget(pac.editor,sel),-1,32) }
  }
}
alias -l pac.abrirxy {
  if ($1 == 2) { return 32 $calc($2 *32) }
  if ($1 == 3) { return 64 $calc($2 *32) }
  if ($1 == 4) { return 128 320 }
  if ($1 == 5) { return 160 320 }
}
alias -l pac.abrircor {
  if ($1 == 2) || ($1 == 3) { return %pacj.cornumpassa }
  if ($1 == 4) { return %pacj.corcomidinha }
  if ($1 == 5) { return %pacj.corcomidona }
}
on *:close:@Editor: { pac.fechar }
alias -l pac.fechar {
  if ($1) { window -c @Editor }
  unset %pac.come.*
  if ($hget(pac.editor)) { hfree pac.editor }
  if ($hget(pac.tools)) { hfree pac.tools }
  if ($hget(button.@Editor,1)) hfree button.@Editor
  if ($window(@Editor.h)) { window -c @Editor.h }
  if ($window(@Editor.h2)) { window -c @Editor.h2 }
  if ($window(@Editor.h3)) { window -c @Editor.h3 }
  if ($window(@Pac.tool)) { window -c @Pac.tool }
}
on *:close:@Pacman: { pac2.fechar }
alias -l pac2.fechar {
  unset %pacj.*
  if ($window(@Pacman.h)) { window -c @Pacman.h }
  if ($window(@Pacman.h2)) { window -c @Pacman.h2 }
  if ($window(@Pacman.h3)) { window -c @Pacman.h3 }
  if ($window(@Pacman.h4)) { window -c @Pacman.h4 }
  if ($timer(PAC)) { .timerPAC off }
}
menu query,channel,pvt,menubar,nicklist {
  %izeka GameZ %izeka2
  .PacMaN
  ..New Game:pac.njogo
  ..-
  ..Maps Editor
  ...New:pac.novo
  ...Open:pac.abrir
  ..Config:pac.config
}

;$button by SirNo3DfX
;$button(<window>,<x>,<y>,<w>,<h>,<button-colour>,<light-border-colour>,<dark-border-colour>,<command>,<1/2/3>,<0/1>,<1/2/3>,<button-text>,<text-colour>,<font>,<font-size>)
alias button {
  if (!$window($1)) || (!$12) return
  var %f = $iif($15,$+(",$15,"),Fixedsys),%s = $iif($16,$16,9),%x = $calc($2 + (($4 - $width($13,%f,%s,0,0))/2) $iif($12 == 2,+1)),%y = $calc(($3 +($5 - $height($13,%f,%s))/2) $iif($12 == 2,+1)),%d $iif($12 == 2,$8,$7),%a $iif($12 == 2,$7,$8),%t drawrect -nfr $1,%l drawline -nr $1,%p drawtext -nr $1,%i 1,%- $calc($5 -1),%. 6,%r1,%r2,%1 $calc($2 +$4 -1),%2 $calc(6+$3),%3 $calc($3 +$5 -6),%4 $calc($2 +$4 -6),%5 $calc($3 +$5 -1),%6 $calc(5+$2),%7 = $calc(1+$2),%8 = $calc(%1 -1),%9 = $calc(3+$3),%10 = $calc(%5 -2),%11 = $calc(2+$2)
  if ($11 == 1) %a = %d  
  if ($10 isnum 2-3) { while (%- >= 0) { $iif(%. != 0 && %- > 4,dec %.,$iif(%- <= 4,inc %.)) | %l $6 1 $calc(%. +$2) $calc(%- +$3) $calc(($2 +$4)-%.) $calc(%- +$3) | dec %- } }
  if ($10 == 2) { %r1 = %11 %10 %7 $calc(%5 -4) $2 %3 $2 $calc(5+$3) $calc(1+$2) $calc(4+$3) $calc(1+$2) %9 %6 $3 %4 $3 $calc(%1 -2) $calc(2+$3) %8 %9 | %r2 = %8 %9 %1 %2 %1 %3 $calc(3+%4) $calc(3+%3) %4 $calc(5+%3) %4 %5 $calc(5+$2) %5 %11 %10 | %l %d 1 %r1 | %l %a 1 %r2 }
  if ($10 == 3) { %r1 = $2 %3 $2 $calc(5+$3) %6 $3 %6 $3 %4 $3 $calc($2 +$4) %2 | %r2 = %1 %2 %1 %3 %4 %5 %6 %5 $2 %3 | %l %d 1 %r1 | %l %a 1 %r2 }
  if ($10 == 1) { %t %a 1 $2 $3 $4 $5 | %t %d 1 $2 $3 $calc($4 -1) $calc($5 -1) | %t $6 1 $calc(1+$2) $calc(1+$3) $calc($4 -2) $calc($5 -2) | %r1 = $2 $3 %1 $3 %1 %5 $2 %5 }
  if ($12 == 3) { %c = $8 | %p $7 %f %s $calc(1+%x) $calc(1+%y) $13 }
  else %c = $iif($14,$14,0)
  if ($13) %p %c %f %s %x %y $13
  drawdot $1
  while ($hget(button. $+ $1,%i)) inc %i
  if (!$prop) && ($12 == 1) hadd -m button. $+ $1 %i $+($2,;,$3,;,$4,;,$5,;,$6,;,$7,;,$8,;,$9,;,$10,;,$11,;,$13,;,$14,;,$15,;,$16)
}
alias -l click {
  var %t = $1
  tokenize 59 $hget(button. $+ $active,$2)
  if (%t == 2) && ($inrect($mouse.x,$mouse.y,$1,$2,$3,$4)) return
  if (%t != 1) hfree history. $+ $active 
  $button($active,$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$iif(%t == 1,2,1),$11,$12,$13,$14).c
  if (%t == 3) $8
}
