//**********************************************************************
//     Saver   -   DRAWWND.CPP
//     Copyright (c) $time(%Y/-), Thees Ch. Winkler
//     All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//    * Redistributions of source code must retain the 
// 	    above copyright notice, this list of conditions and 
// 	    the following disclaimer.
//    * Redistributions in binary form must reproduce the above 
//      copyright notice, this list of conditions and the following 
//      disclaimer in the documentation and/or other materials 
//      provided with the distribution.
//    * Neither the name of the <ORGANIZATION> nor the names of its 
//      contributors may be used to endorse or promote products 
//      derived from this software without specific prior written 
//      permission.
// 
// 	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
//  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
//  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
//  INCIDENTAL,	SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
//  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
//  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
//  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN 
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
//**********************************************************************

// Includes

#include "stdafx.h"
#include "Saver.h"
#include "drawwnd.h"
#include "math.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

LPCTSTR CDrawWnd::m_lpszClassName = NULL;

#define TIMER_DRAW 2
#define TIMER_ERASE 3


UINT UWM_ON_CHAT = ::RegisterWindowMessage("UWM_ON_CHAT-759000E8-63CA-44CC-93BF-B7A03872E60B");
HWND g_hMXWindow = 0;

enum modes{
	
	MODE_STAT = 0,
	MODE_DOWN,
	MODE_UP,
	MODE_ONLINE
};

/////////////////////////////////////////////////////////////////////////////
// CDrawWnd


BOOL CALLBACK CDrawWnd::EnumWindowsProc(HWND hWnd, LPARAM lParam)
{
	BOOL bReturn = TRUE;
	char *buffer = new char[400];
	::GetWindowText(hWnd, buffer, 400);

    if(strstr(buffer, "WinMX v3.31") != NULL){

		g_hMXWindow = hWnd;
		bReturn = FALSE;
	}
	
	delete buffer;
	buffer = NULL;
	return bReturn;
}

CDrawWnd::CDrawWnd(BOOL bAutoDelete)
{
	m_bAutoDelete = bAutoDelete;
	m_bErase = TRUE;
	m_nMode = MODE_STAT;
	m_nAngle = 0;
	m_nSig = 1;
}

CDrawWnd::~CDrawWnd()
{
}


BEGIN_MESSAGE_MAP(CDrawWnd, CWnd)
	//{{AFX_MSG_MAP(CDrawWnd)
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_REGISTERED_MESSAGE(UWM_ON_CHAT, OnChat)
END_MESSAGE_MAP()



void CDrawWnd::DrawSTAT(CDC &dc)
{

	char buffer[256];
	CString strText, strVersion, strUploads, strDownloads, strOnline;
	::GetWindowText(g_hMXWindow, buffer, 255);
	strText = buffer;
	strVersion = strText.Left(11);
	strVersion.Replace("WinMX", "WinMX Version:");
	int nStart = 0, nEnd = 0;
	
	if((nStart = strText.Find("DL")-2) >= 0){

		nEnd = strText.Find("B/s", nStart) + 3;
		strDownloads = strText.Mid(nStart, nEnd-nStart);
		strDownloads.Insert(0, "Downloads: ");
		strDownloads.Replace("DL @", " file(s) at");
	}
	else{

		strDownloads = "Downloads: 0 files at 0 B/s";
	}
	
	if((nStart = strText.Find("UL")-2) >= 0){

		nEnd = strText.Find("B/s", nStart) + 3;
		strUploads = strText.Mid(nStart, nEnd-nStart);
		strUploads.Insert(0, "Uploads: ");
		strUploads.Replace("UL @", " file(s) at");
	}
	else{

		strUploads = "Uploads: 0 files at 0 B/s";
	}
	
	if((nStart = strText.Find("<Online ")) >= 0){

		strOnline = strText.Mid(nStart);
		strOnline.Replace("<Online ", "Online: ");
		strOnline.Replace(">", "");
	}
	else{

		strOnline = "Online: Unknown";
	}

	CRect rect;
	GetClientRect(&rect);

	HDC hMemDC;
	HBITMAP hbmScreen;
	HBITMAP hPicture = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_STAT),IMAGE_BITMAP,400, 200, LR_DEFAULTCOLOR);
	//SelectObject(hMemDC, brush);
	

	//FloodFill(hMemDC, 0, 0, 0);

	BITMAP bm;
	GetObject(hPicture, sizeof (BITMAP), (LPSTR)&bm);

	hMemDC = CreateCompatibleDC(dc);
	


	HBITMAP hOldBMP = (HBITMAP)SelectObject(hMemDC, hPicture);

	int nWidthB = bm.bmWidth;
	int nHeightB = bm.bmHeight;
	
	HFONT hFont = CreateFont(24, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	SetBkMode(hMemDC,TRANSPARENT);
	SetTextColor(hMemDC, RGB(10, 200, 0));
	SetTextAlign(hMemDC, TA_CENTER);

	//SetBkColor(hMemDC, RGB(15, 0, 127));

	TextOut(hMemDC, 200, 40, strVersion, strVersion.GetLength());
	TextOut(hMemDC, 200, 70, strDownloads, strDownloads.GetLength());
	TextOut(hMemDC, 200, 100, strUploads, strUploads.GetLength());
	TextOut(hMemDC, 200, 130, strOnline, strOnline.GetLength());
	// Create the DC
	//hdcCompatible = CreateCompatibleDC(dc);    
	// Temporary memory bitmap
	hbmScreen = CreateCompatibleBitmap(dc, nWidthB, nHeightB);


	// select bitmap into dc
	SelectObject(dc, hbmScreen);
	
	BitBlt(dc, m_nX, m_nY, nWidthB, nHeightB, hMemDC, 0, 0, SRCCOPY);

	SelectObject(hMemDC, hOldBMP);

	// Release temporary stuff
	DeleteDC(hMemDC);
	DeleteObject(hbmScreen);
	DeleteObject(hPicture);
}

void CDrawWnd::DrawOnline(CDC &dc)
{

	char buffer[256];
	CString strText, strOnline;
	::GetWindowText(g_hMXWindow, buffer, 255);
	strText = buffer;
	int nStart = 0, nEnd = 0;
	if((nStart = strText.Find("<Online ")) >= 0){

		strOnline = strText.Mid(nStart);
		strOnline.Replace("<Online ", "");
		strOnline.Replace(">", "");
	}
	else{

		DrawTime(dc);
	}

	HDC hMemDC;
	HBITMAP hbmScreen;
	HBITMAP hPicture = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_STAT),IMAGE_BITMAP,400, 200, LR_DEFAULTCOLOR);
	//SelectObject(hMemDC, brush);
	

	//FloodFill(hMemDC, 0, 0, 0);

	BITMAP bm;
	GetObject(hPicture, sizeof (BITMAP), (LPSTR)&bm);

	hMemDC = CreateCompatibleDC(dc);
	

	HBITMAP hOldBMP = (HBITMAP)SelectObject(hMemDC, hPicture);

	int nWidthB = bm.bmWidth;
	int nHeightB = bm.bmHeight;
	
	HFONT hFont = CreateFont(20, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	SetBkMode(hMemDC,TRANSPARENT);
	SetTextColor(hMemDC, RGB(146, 255, 161));
	TextOut(hMemDC, 25, 20, "Time Online:", 12);

	SetTextAlign(hMemDC, TA_CENTER);

	hFont = CreateFont(80, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	TextOut(hMemDC, 200, 70, strOnline, strOnline.GetLength());
	// Create the DC
	//hdcCompatible = CreateCompatibleDC(dc);    
	// Temporary memory bitmap
	hbmScreen = CreateCompatibleBitmap(dc, nWidthB, nHeightB);


	// select bitmap into dc
	SelectObject(dc, hbmScreen);
	
	BitBlt(dc, m_nX, m_nY, nWidthB, nHeightB, hMemDC, 0, 0, SRCCOPY);

	SelectObject(hMemDC, hOldBMP);

	// Release temporary stuff
	DeleteDC(hMemDC);
	DeleteObject(hbmScreen);
	DeleteObject(hPicture);
}

void CDrawWnd::DrawTime(CDC &dc)
{

	HDC hMemDC;
	HBITMAP hbmScreen;
	HBITMAP hPicture = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_STAT),IMAGE_BITMAP,400, 200, LR_DEFAULTCOLOR);
	//SelectObject(hMemDC, brush);
	

	//FloodFill(hMemDC, 0, 0, 0);

	BITMAP bm;
	GetObject(hPicture, sizeof (BITMAP), (LPSTR)&bm);

	hMemDC = CreateCompatibleDC(dc);
	

	HBITMAP hOldBMP = (HBITMAP)SelectObject(hMemDC, hPicture);

	int nWidthB = bm.bmWidth;
	int nHeightB = bm.bmHeight;
	
	HFONT hFont = CreateFont(20, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	SetBkMode(hMemDC,TRANSPARENT);
	SetTextColor(hMemDC, RGB(145, 195, 255));
	TextOut(hMemDC, 25, 20, "Current Time:", 13);

	hFont = CreateFont(100, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	//SetBkColor(hMemDC, RGB(15, 0, 127));

	CString strTime;
	SYSTEMTIME time;
	GetLocalTime(&time);
	strTime.Format("%02d:%02d.%02d", time.wHour, time.wMinute, time.wSecond);

	TextOut(hMemDC, 25, 50, strTime, strTime.GetLength());
	// Create the DC
	//hdcCompatible = CreateCompatibleDC(dc);    
	// Temporary memory bitmap
	hbmScreen = CreateCompatibleBitmap(dc, nWidthB, nHeightB);


	// select bitmap into dc
	SelectObject(dc, hbmScreen);
	
	BitBlt(dc, m_nX2, m_nY2, nWidthB, nHeightB, hMemDC, 0, 0, SRCCOPY);

	SelectObject(hMemDC, hOldBMP);

	// Release temporary stuff
	DeleteDC(hMemDC);
	DeleteObject(hbmScreen);
	DeleteObject(hPicture);
}

void CDrawWnd::DrawUP(CDC& dc)
{

	char buffer[256];
	CString strText, strUploads, strRate;
	::GetWindowText(g_hMXWindow, buffer, 255);
	strText = buffer;
	int nStart = 0, nEnd = 0;
	if((nStart = strText.Find("UL")-2) >= 0){

		strUploads = strText.Mid(nStart, 2);
		strUploads.Insert(0, "Uploads: ");
		strUploads += " file(s)";
		
		nStart += 2;
		nEnd = strText.Find("B/s", nStart) + 3;
		strRate = strText.Mid(nStart, nEnd-nStart);
		strRate.Replace("UL @ ", "Upload Rate: ");

	}
	else{

		strUploads = "Uploads: 0 files";
		strRate      = "Upload Rate: 0 B/s";
	}

	HDC hMemDC;
	HBITMAP hbmScreen;
	HBITMAP hPicture = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_STAT),IMAGE_BITMAP,400, 200, LR_DEFAULTCOLOR);

	BITMAP bm;
	GetObject(hPicture, sizeof (BITMAP), (LPSTR)&bm);

	hMemDC = CreateCompatibleDC(dc);
	

	HBITMAP hOldBMP = (HBITMAP)SelectObject(hMemDC, hPicture);

	int nWidthB = bm.bmWidth;
	int nHeightB = bm.bmHeight;
	
	HFONT hFont = CreateFont(40, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	SetBkMode(hMemDC,TRANSPARENT);
	SetTextColor(hMemDC, RGB(255, 144, 144));
	SetTextAlign(hMemDC, TA_CENTER);

	TextOut(hMemDC, 200, 50, strUploads, strUploads.GetLength());

	hFont = CreateFont(30, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	TextOut(hMemDC, 200, 100, strRate, strRate.GetLength());
	// Create the DC
	//hdcCompatible = CreateCompatibleDC(dc);    
	// Temporary memory bitmap
	hbmScreen = CreateCompatibleBitmap(dc, nWidthB, nHeightB);


	// select bitmap into dc
	SelectObject(dc, hbmScreen);
	
	BitBlt(dc, m_nX, m_nY, nWidthB, nHeightB, hMemDC, 0, 0, SRCCOPY);

	SelectObject(hMemDC, hOldBMP);

	// Release temporary stuff
	DeleteDC(hMemDC);
	DeleteObject(hbmScreen);
	DeleteObject(hPicture);

}

void CDrawWnd::DrawDown(CDC &dc)
{

	char buffer[256];
	CString strText, strDownloads, strRate;
	::GetWindowText(g_hMXWindow, buffer, 255);
	strText = buffer;
	int nStart = 0, nEnd = 0;
	if((nStart = strText.Find("DL")-2) >= 0){

		strDownloads = strText.Mid(nStart, 2);
		strDownloads.Insert(0, "Downloads: ");
		strDownloads += " file(s)";
		
		nStart += 2;
		nEnd = strText.Find("B/s", nStart) + 3;
		strRate = strText.Mid(nStart, nEnd-nStart);
		strRate.Replace("DL @ ", "Download Rate: ");

	}
	else{

		strDownloads = "Downloads: 0 files";
		strRate      = "Download Rate: 0 B/s";
	}


	HDC hMemDC;
	HBITMAP hbmScreen;
	HBITMAP hPicture = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_STAT),IMAGE_BITMAP,400, 200, LR_DEFAULTCOLOR);
	//SelectObject(hMemDC, brush);
	

	//FloodFill(hMemDC, 0, 0, 0);

	BITMAP bm;
	GetObject(hPicture, sizeof (BITMAP), (LPSTR)&bm);

	hMemDC = CreateCompatibleDC(dc);
	

	HBITMAP hOldBMP = (HBITMAP)SelectObject(hMemDC, hPicture);

	int nWidthB = bm.bmWidth;
	int nHeightB = bm.bmHeight;
	
	HFONT hFont = CreateFont(40, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	SetBkMode(hMemDC,TRANSPARENT);
	SetTextColor(hMemDC, RGB(255, 240, 159));
	SetTextAlign(hMemDC, TA_CENTER);

	TextOut(hMemDC, 200, 50, strDownloads, strDownloads.GetLength());

	hFont = CreateFont(30, 0, 0, 0, FW_BOLD, 
 							FALSE, FALSE, FALSE, 
   							ANSI_CHARSET,
                OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,
                PROOF_QUALITY,
                VARIABLE_PITCH | 0x04 | FF_DONTCARE,
                (LPTSTR)_T("Arial"));

	SelectObject(hMemDC, hFont);

	TextOut(hMemDC, 200, 100, strRate, strRate.GetLength());
	// Create the DC
	//hdcCompatible = CreateCompatibleDC(dc);    
	// Temporary memory bitmap
	hbmScreen = CreateCompatibleBitmap(dc, nWidthB, nHeightB);


	// select bitmap into dc
	SelectObject(dc, hbmScreen);
	
	BitBlt(dc, m_nX, m_nY, nWidthB, nHeightB, hMemDC, 0, 0, SRCCOPY);

	SelectObject(hMemDC, hOldBMP);

	// Release temporary stuff
	DeleteDC(hMemDC);
	DeleteObject(hbmScreen);
	DeleteObject(hPicture);
}

void CDrawWnd::Draw(CDC &dc)
{

	if(m_bErase){

		HBITMAP hBackground = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BG),  IMAGE_BITMAP, 295, 230, LR_DEFAULTCOLOR);
		CRect rect;
		GetClientRect(&rect);
		FillRect(dc, &rect, CreatePatternBrush(hBackground)); //(HBRUSH)GetStockObject(BLACK_BRUSH));
		m_bErase = FALSE;
	}

	
	switch(m_nMode){

	case MODE_UP:
		DrawUP(dc);
		DrawTime(dc);
		break;
	case MODE_DOWN:
		DrawDown(dc);
		DrawTime(dc);
		break;
	case MODE_ONLINE:
		DrawOnline(dc);
		DrawTime(dc);
		break;
	default: // STAT
		DrawSTAT(dc);
		DrawTime(dc);
	}

}


/////////////////////////////////////////////////////////////////////////////
// CDrawWnd message handlers

void CDrawWnd::OnTimer(UINT nIDEvent)
{

	if(nIDEvent == TIMER_DRAW){

		CClientDC dc(this);
		Draw(dc);
	}
	else if(nIDEvent == TIMER_ERASE){

		m_bErase = TRUE;
		m_nMode = rand()%4;
		m_nX2 = m_nX;
		m_nY2 = m_nY;
		CRect rect2(CPoint(m_nX2, m_nY2), CPoint(m_nX2+420, m_nY2+220));
		int m_nSave = 0;
		do{

			TRACE("Randomizing\n");
			m_nX = rand()%(m_nSW-400);
			m_nY = rand()%(m_nSH-200);
			m_nSave++;
		}while((
				rect2.PtInRect(CPoint(m_nX, m_nY)) ||
				rect2.PtInRect(CPoint(m_nX, m_nY+200)) ||
				rect2.PtInRect(CPoint(m_nX+400, m_nY)) ||
				rect2.PtInRect(CPoint(m_nX+400, m_nY+200))
				) && (m_nSave < 20)
			  );
		m_cColor = rand()%RGB(0,255,255);
		m_nAngle = (m_nMode == MODE_DOWN ? 0 : rand()%10000);
	}
	CWnd::OnTimer(nIDEvent);
}

void CDrawWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	HBITMAP hBackground = (HBITMAP)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_BG),  IMAGE_BITMAP, 295, 230, LR_DEFAULTCOLOR);
	CRect rect;
	GetClientRect(&rect);
	FillRect(dc, &rect, CreatePatternBrush(hBackground)); //(HBRUSH)GetStockObject(BLACK_BRUSH));
}

void CDrawWnd::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);
	m_nSW = cx;
	m_nSH = cy;
}

int CDrawWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	EnumWindows(EnumWindowsProc, 0);
	if(g_hMXWindow == 0){

		AfxMessageBox("Error, could not find WinMX Window");
	}

	CRect rect;
	GetClientRect(&rect);

	srand(GetTickCount());
	m_cColor = RGB(255,255,255);
	m_bErase = TRUE;
	m_nMode = rand()%5;
	m_nSW = rect.Width();
	m_nSH = rect.Height();
	m_nX = rand()%(m_nSW-400);
	m_nY = rand()%(m_nSH-200);

	CRect rect2(CPoint(m_nX, m_nY), CPoint(m_nX+420, m_nY+220));
	int m_nSave = 0;
	do{

		TRACE("Randomizing\n");
		m_nX2 = rand()%(m_nSW-400);
		m_nY2 = rand()%(m_nSH-200);
		m_nSave++;
	}while((
			rect2.PtInRect(CPoint(m_nX2, m_nY2)) ||
			rect2.PtInRect(CPoint(m_nX2, m_nY2+200)) ||
			rect2.PtInRect(CPoint(m_nX2+400, m_nY)) ||
			rect2.PtInRect(CPoint(m_nX2+400, m_nY2+200))
			) && (m_nSave < 20)
		  );
	


	m_nSig = 0;
	m_nSig2 = 0;
	CClientDC dc(this);
	Draw(dc);
	SetTimer(TIMER_DRAW, 500, 0);
	SetTimer(TIMER_ERASE, 20000, 0);

	return 0;
}

BOOL CDrawWnd::Create(DWORD dwExStyle, DWORD dwStyle, const RECT& rect,
	CWnd* pParentWnd, UINT nID, CCreateContext* pContext)
{
	// Register a class with no cursor
	if (m_lpszClassName == NULL)
	{
		m_lpszClassName = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,
			::LoadCursor(AfxGetResourceHandle(),
			MAKEINTRESOURCE(IDC_NULLCURSOR)));
	}

	// TODO: Add your specialized code here and/or call the base class
	return CreateEx(dwExStyle, m_lpszClassName, _T(""), dwStyle,
		rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top,
		pParentWnd->GetSafeHwnd(), NULL, NULL );
}

void CDrawWnd::PostNcDestroy()
{
	if (m_bAutoDelete)
		delete this;
}

UINT CDrawWnd::OnChat(WPARAM wParam, LPARAM lParam)
{

	return 0;
}
