Attribute VB_Name = "WinMX"
Option Explicit

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)

Public Const WANLANConnected        As Long = 99999
Public lngConnectionHandle          As Long
Public boocnnFlip                   As Boolean
Public booConnected                 As Boolean

Public collPlaylist                 As Collection

Public Func                         As Functions

'Filters / Settings
Public minSizeFilter                        As Long
Public maxSizeFilter                        As Long
Public SwearingFilter                       As Integer
Public AllowPassiveSearching                As Integer
Public ShowTracksThatHaveComplete           As Integer
Public ShowTracksThatHaveInComplete         As Integer
Public AllowActiveSearching                 As Integer
Public LyricAutoGetLyricsIfOneResult        As Integer
Public MaxDownloadsBeforeActiveSearching    As Integer
Public ActiveSearchReconnectionCycle        As Integer
Public PlayTrackOnDownloadCompletion        As Integer


Public Amp                          As Winamp

Type MyLong
    Value As Long
End Type

Type MyIP
    A As Byte
    b As Byte
    C As Byte
    d As Byte
End Type

Public Enum napResponses
    napSuccess
    napIdle
    napTimeout
    napPortClosedOnDataSend
End Enum

Public Enum MxConnectionType
    ConnectOnly
    MxReady
    MxGetIP
End Enum
Private booInitPattern               As Boolean

Public NickName                     As String
Public GlobalDownloadPath           As String
Public lngServer(1 To 7)            As Long
Public Const WinMxReady             As String = "1"
Public strPattern(0 To 3)           As String

Private Function GetValue(intPos As Integer, bytArr() As Byte, intLen As Integer) As Byte
    On Local Error Resume Next
    If intPos < 0 Then
        GetValue = bytArr(intLen + intPos) Xor bytArr(intLen + intPos - 1)
    Else
        GetValue = bytArr(intPos)
    End If

End Function

Public Function Decode(strData As String) As String
    If Len(strData) < 5 Then Decode = strData: Exit Function
    
    Dim bytArrIN()                  As Byte
    Dim bytArrOUT()                 As Byte
    Dim intLen                      As Integer
    Dim intI                        As Integer
        
    intLen = Len(strData)
    ReDim bytArrIN(0 To intLen - 1) As Byte
    ReDim bytArrOUT(0 To intLen - 1) As Byte
    
    For intI = 0 To intLen - 1: bytArrIN(intI) = Asc(Mid(strData, intI + 1, 1)): Next intI
    For intI = 0 To intLen - 1
        bytArrOUT(intI) = GetValue(intI - 5, bytArrIN(), intLen) Xor GetValue(intI - 4, bytArrIN(), intLen) Xor GetValue(intI - 1, bytArrIN(), intLen) Xor GetValue(intI, bytArrIN(), intLen)
    Next intI
    bytArrOUT(0) = bytArrOUT(0) Xor (intLen Mod 256) Xor bytArrOUT(intLen - 1)
    For intI = 0 To intLen - 1: Decode = Decode & Chr(bytArrOUT(intI)): Next intI

End Function

Public Sub InitialisePattern()

    strPattern(0) = "1,1,1,0,0,0,0,1"
    strPattern(1) = "0,1,1,1,1,0,0,0"
    strPattern(2) = "0,1,0,0,1,0,1,1"
    strPattern(3) = "0,0,1,0,1,1,0,1"
    booInitPattern = True
    
End Sub

Private Function EncodeOne(bytValue As Byte, ByRef arrOut() As Byte, intPos As Integer, intLen As Integer, arrPatt As Variant) As Byte

    Dim intI                        As Integer
    
    For intI = 0 To intPos - 1
        If arrPatt(7 - (intPos - 1 - intI) Mod 4) Then arrOut(intI) = arrOut(intI) Xor bytValue
    Next intI
    For intI = intPos To intLen - 1
        If arrPatt((intI - intPos) Mod 8) Then arrOut(intI) = arrOut(intI) Xor bytValue
    Next intI

End Function

Public Function Encode(strData As String) As String
    
    Dim arrIn()                     As Byte
    Dim arrOut()                    As Byte
    Dim arrPatternChosen            As Variant
    Dim intI                        As Integer
    Dim intLen                      As Integer
    Dim intPattern                  As Integer
    
    If Not booInitPattern Then InitialisePattern
    
    intLen = Len(strData)
    intPattern = intLen Mod 4
    arrPatternChosen = Split(strPattern(intPattern), ",")
    
    ReDim arrIn(0 To intLen - 1)
    ReDim arrOut(0 To intLen - 1)
    For intI = 0 To intLen - 1: arrIn(intI) = Asc(Mid(strData, intI + 1, 1)):  Next intI
    
    EncodeOne arrIn(0) Xor intLen, arrOut(), 0, intLen, arrPatternChosen
    For intI = 1 To intLen - 1
        EncodeOne arrIn(intI), arrOut(), intI, intLen, arrPatternChosen
    Next intI
    For intI = 0 To intLen - 1
        Encode = Encode & Chr(arrOut(intI))
    Next intI

End Function

Public Function ConnectMx(sck As MSWinsockLib.Winsock, strIPAddress As String, lngPortNumber As Long, Optional sngTimeOut As Single = 3, Optional cnnType As Long = 0) As Integer
    
'    Dim sngTimer                As Single
'
'    ConnectMx = 0
'    sngTimer = Timer
'    With sck
'        .Close
'        DoEvents
'        strRecieve = vbNullString
'        .LocalPort = 0
'        .RemotePort = lngPortNumber
'        .RemoteHost = strIPAddress
'        .Connect
'        Do
'            DoEvents
'        Loop Until (cnnType = 2 And Len(strRecieve) > 11) Or (cnnType = 0 And sck.State = 7) Or (cnnType = 1 And strRecieve = "1") Or sngTimer + sngTimeOut < Timer
'        If (cnnType = 2 And Len(strRecieve) > 11) Or (cnnType = 0 And sck.State = 7) Or (cnnType = 1 And strRecieve = "1") Then
'            ConnectMx = 1
'        Else
'            sck.Close
'        End If
'    End With

End Function

Public Sub GetIpPort(ByVal strData1 As String, ByRef strIP As String, ByRef lngPort As Long)

    Dim arrVar              As Variant
    If Len(strData1) Then
        arrVar = Split(Decode(strData1), ":")
        strIP = arrVar(0)
        lngPort = CLng(Val(arrVar(1)))
    End If
    
End Sub

Public Function sLoHi(intData As Integer) As String
    Dim s               As String
    s = String(2, 0)
    CopyMemory ByVal s, intData, 2
    sLoHi = s
End Function
Public Function iLoHi(strData As String) As Integer
    Dim i               As Integer
    CopyMemory i, ByVal strData, 2
    iLoHi = i
End Function
Public Function GetDataLength(strDataPacket As String) As Integer
    GetDataLength = Abs(iLoHi(Mid(strDataPacket, 1, 2)))
End Function
Public Function GetDataType(strDataPacket As String) As Integer
    GetDataType = iLoHi(Mid(strDataPacket, 3, 2))
End Function
Public Function napPacket(CommandType As Integer, DataPacket As String) As String
    napPacket = sLoHi(Len(DataPacket)) & sLoHi(CommandType) & DataPacket
End Function

Public Function mxPacket(CommandType As Integer, DataPacket As String) As String
    mxPacket = sLoHi(Len(DataPacket)) & Encode(sLoHi(CommandType) & DataPacket)
End Function
Public Function mxPacket2(DataPacket As String) As String
    mxPacket2 = sLoHi(Len(DataPacket)) & Encode(DataPacket)
End Function

Public Function Quote(ByVal strData As String) As String
    Quote = Chr(34) & Replace(strData, Chr(34), " ") & Chr(34)
End Function
Public Function napSendDataDirect(sck As Winsock, ByVal strDataPacket As String) As Integer
    With sck
        If .State = sckConnected Then
            .SendData strDataPacket
            napSendDataDirect = 0
        Else
            napSendDataDirect = 1
        End If
    End With
End Function
Public Function ExtractData(strDataPacket As String) As String
    ExtractData = Mid(strDataPacket, 5, GetDataLength(strDataPacket))
End Function
Public Function sql(strArtist As String, FindType As String) As String
    Select Case FindType
        Case "Music"
            sql = "FILENAME CONTAINS " & Quote(strArtist) & " MAX_RESULTS 50 LINESPEED " & Quote("AT LEAST") & " 4 BITRATE " & Quote("AT LEAST") & " " & Quote("160") & " FREQ " & Quote("EQUAL TO") & " " & Quote("44100")
        Case Else
            sql = "FILENAME CONTAINS " & Quote(strArtist) & " MAX_RESULTS 50 LINESPEED " & Quote("AT LEAST") & " 4" ' BITRATE " & Quote("AT LEAST") & " " & Quote("160") & " FREQ " & Quote("EQUAL TO") & " " & Quote("44100")
    End Select
End Function
Public Function IPToString(Value As Double) As String

    Dim l                   As MyLong
    Dim i                   As MyIP
    
    l.Value = DoubleToLong(Value)
    LSet i = l
    IPToString = i.A & "." & i.b & "." & i.C & "." & i.d

End Function

Private Function DoubleToLong(Value As Double) As Long

    If Value <= 2147483647 Then
        DoubleToLong = Value
    Else
        DoubleToLong = -(4294967296# - Value)
    End If

End Function

Public Function GetNow() As Double
    GetNow = Fix(CDbl(Now) * 100000)
End Function

Public Function StringToIP(IPAddress As String) As String

    Dim varSplit            As Variant
    Dim ip                  As MyIP
    Dim l                   As MyLong
    Dim dblIP               As Double
    
    varSplit = Split(IPAddress, ".", 4)
    
    ip.A = CByte(Val(varSplit(0)))
    ip.b = CByte(Val(varSplit(1)))
    ip.C = CByte(Val(varSplit(2)))
    ip.d = CByte(Val(varSplit(3)))

    dblIP = ip.A
    dblIP = dblIP + (ip.b * 256#)
    dblIP = dblIP + (ip.C * 256# * 256#)
    dblIP = dblIP + (ip.d * 256# * 256# * 256#)
    
    StringToIP = Trim(Str(dblIP))
    
End Function

Public Function GetRandomNick() As String

    Dim varArr                  As Variant
    Dim intMaxChars             As Integer
    Dim intLoop                 As Integer
    
    varArr = Split("a,b,c,d,e,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z", ",")
    intMaxChars = (Rnd * 10) + 8

    GetRandomNick = vbNullString
    For intLoop = 1 To intMaxChars
        GetRandomNick = GetRandomNick & varArr(Fix((Rnd * UBound(varArr))) + 1)
    Next intLoop

End Function

Public Function napSendData(sck As Winsock, ByVal strDataPacket As String, Optional Timeout As Single = 5) As Integer
    
    Dim intResult           As Integer
    Dim sngTimer            As Single
    
    sngTimer = Timer
    With sck
        If .State = sckConnected Then
            intResult = 0
            .SendData strDataPacket
            Do
                DoEvents
            Loop Until intResult > 0 Or sngTimer + Timeout < Timer
            napSendData = intResult
        Else
            napSendData = 11
        End If
    End With
    
End Function

Public Function ExtractCommand(strData As String) As Integer
    ExtractCommand = iLoHi(Left(strData, 2))
End Function

Public Sub DealWith(Cnn As Connector, intCommand As Integer, strData As String)

    Select Case intCommand
        Case 0      'Error
        
        Case 3      'Login Ack
            Cnn.LoginOK = True
        Case 214    'Status Message
            Cnn.LoginOK = True
        Case 201    'Query Result
            'AddQueryToGrid strData
        Case 202    'Send File List Complete
            Stop
    
    End Select

End Sub


Public Function ExtractTrackName(strPath As String, Optional strArtist As String = "Test Pointer") As String
    
    On Local Error GoTo errETN
    
    Dim intTempFile         As Integer
    Dim strTemp             As String
    Dim intEndPoint         As Integer
    Dim intPoint            As Integer
    Dim strTempSql          As String
    
    strTemp = UCase(Mid(strPath, InStrRev(strPath, "\") + 1))
    intEndPoint = InStr(strTemp, ".MP") - 1
    If intEndPoint Then strTemp = Mid(strTemp, 1, intEndPoint)
    strTemp = Replace(strTemp, "_", " ")
    strTempSql = strArtist
    If InStr(strTempSql, "THE") = 1 And strTempSql <> "THE THE" Then strTempSql = Trim(Replace(strTempSql, "THE", vbNullString))
    intPoint = InStr(strTemp, strTempSql)
    If intPoint Then strTemp = Mid(strTemp, intPoint + Len(strTempSql) + 1)
    intPoint = InStrRev(strTemp, "-")
    If intPoint > 0 And intPoint < Len(strTemp) Then strTemp = Mid(strTemp, intPoint + 1)
    strTemp = Replace(strTemp, "-", vbNullString)
    If InStr(strTemp, strTempSql) Then strTemp = Replace(strTemp, strTempSql, vbNullString)
    For intPoint = 1 To 9: strTemp = Replace(strTemp, "(" & intPoint & ")", vbNullString): Next intPoint
    If SwearingFilter Then
        strTemp = Replace(UCase(strTemp), "FUCK", "XXXX")
        strTemp = Replace(UCase(strTemp), "CUNT", "XXXX")
        strTemp = Replace(UCase(strTemp), "COCK", "XXXX")
        strTemp = Replace(UCase(strTemp), "TWAT", "XXXX")
    End If
    strTemp = Replace(strTemp, "@", vbNullString)
    strTemp = Replace(strTemp, "=", vbNullString)
    strTemp = Replace(strTemp, "'", vbNullString)
    strTemp = Replace(strTemp, "~", vbNullString)
    strTemp = Replace(strTemp, "%20", vbNullString)
    strTemp = Replace(strTemp, "`", vbNullString)
    strTemp = Replace(strTemp, UCase(strArtist), vbNullString)
    strTemp = Trim(strTemp)
    Do While InStr("0123456789(). []`{};:#!,/\", Left(strTemp, 1)) > 0 And Len(strTemp) > 1: strTemp = Mid(strTemp, 2): Loop
    If Len(strTemp) < 3 Then
        ExtractTrackName = vbNullString
    Else
        ExtractTrackName = Trim(StrConv(strTemp, vbProperCase))
    End If
Exit Function
errETN:
    ExtractTrackName = vbNullString
    
End Function


'====================================
' The C Version
'unsigned char get(int pos, const unsigned char* in, int length)
'{
'  if (pos<0) return in[length+pos]  ^ in[length+pos-1];
'  return in[pos];
'}
'
'void decode(const unsigned char* in, char* out, int length)
'{
'  int i;
'  for(i=0; i<length; ++i)
'  {
'    out[i] = get(i-5, in, length)
'           ^ get(i-4, in, length)
'           ^ get(i-1, in, length)
'           ^ get(i-0, in, length);
'  }
'  out[0] ^= length ^ out[length-1];
'}
'
'// === ENCODING
'
'// the four patterns are '000-' '-000' '-0--' and '--0-'. The second
'// half of a pattern is the same as the first one, but logically
'// reversed (1 <-> 0).
'static const unsigned char patterns[4][8] =
'{ { 1, 1, 1, 0, 0, 0, 0, 1 },
'  { 0, 1, 1, 1, 1, 0, 0, 0 },
'  { 0, 1, 0, 0, 1, 0, 1, 1 },
'  { 0, 0, 1, 0, 1, 1, 0, 1 } };
'
'void encodeOne(char ch, unsigned char* out, int pos, int length, const unsigned char *pattern)
'{
'  int i;
'  // encode before position
'  for(i=0; i<pos; ++i)
'    if (pattern[7-(pos-1-i)%4]) out[i] ^= ch;
'  // encode after position
'  for(i=pos; i<length; ++i)
'    if (pattern[(i-pos)%8])     out[i] ^= ch;
'}
'
'void encode(const char* in, unsigned char* out, int length)
'{
'  int i;
'  // choose pattern
'  const unsigned char *pattern = patterns[length % 4];
'
'  // encode
'  memset(out, 0, length);
'  encodeOne(in[0] ^ length, out, 0, length, pattern);
'  for(i=1; i<length; ++i)
'    encodeOne(in[i], out, i, length, pattern);
'}

Public Sub WriteFile(strData As String, Optional intLen As Integer = 0)

    Dim TFile               As Integer
    
    TFile = FreeFile
    Open "C:\Debug.txt" For Append As TFile
    Print #TFile, Format(Len(strData) - 2, "00") & " [" & Format(intLen, "00") & "] " & strData
    Close TFile

End Sub

Public Sub AddConnector(strArtist As String, FindType As String)
    
    frmMain.mxbTrackSearch.Enabled = False
   
    Dim intIndex                As Integer
    Dim strIndex                As String
    Dim intLoop                 As Integer
    Dim strTxt                  As String
    
    intIndex = 0
    With frmMain.flexSearch
        For intLoop = 1 To 5
            strIndex = Left(.TextMatrix(intLoop, 1), 4)
            If strIndex = "Idle" Or strIndex = vbNullString Then
                intIndex = intLoop
                Exit For
            End If
        Next intLoop
        If intIndex Then
            .TextMatrix(intIndex, 1) = "Connecting..."
            .TextMatrix(intIndex, 3) = strArtist
            frmMain.Connector(intIndex).ConnectMe
            frmMain.Connector(intIndex).FindType = FindType
            frmMain.Connector(intIndex).SearchKey = StrConv(strArtist, vbProperCase)
        End If
    End With
    frmMain.mxbTrackSearch.Enabled = True

End Sub

Public Function AddBuddy(FileName As String, Artist As String, Track As String, Optional Size As Long = 0) As Integer
   
    Dim intLoop                 As Integer
    Dim strTxt                  As String
    Dim lngKey                  As Long
    Dim lngByteStart            As Long
    Dim lngArtistID             As Long
    
    lngArtistID = GetArtistID(Artist)
    AddBuddy = 0
    If dbs.OpenRecordset("SELECT * FROM tblTracks WHERE ArtistID = " & lngArtistID & " AND [Track Name] Like '" & Track & "*'", dbOpenSnapshot, dbForwardOnly).EOF Then
        lngKey = GetResumeID(lngArtistID, Track, Size, lngByteStart)
        If lngKey Then
            With frmMain.flexDownload
                For intLoop = 1 To 5
                    strTxt = Left(.TextMatrix(intLoop, 0), 4)
                    If strTxt = "Idle" Or strTxt = vbNullString Then AddBuddy = intLoop: Exit For
                Next intLoop
                If AddBuddy Then
                    frmMain.Buddy(AddBuddy).pFullPath = FileName
                    frmMain.Buddy(AddBuddy).EstSize = Size
                    frmMain.Buddy(AddBuddy).pTrackOnly = Track
                    frmMain.Buddy(AddBuddy).ResumeKey = lngKey
                    frmMain.Buddy(AddBuddy).pByteStart = lngByteStart
                    frmMain.Buddy(AddBuddy).pPathFromSlash = Artist & " - " & Track & ".mp3"
                    .TextMatrix(AddBuddy, 0) = "Waiting For Response"
                    .TextMatrix(AddBuddy, 1) = Artist & " - " & Track
                    .TextMatrix(AddBuddy, 2) = vbNullString
                    .TextMatrix(AddBuddy, 3) = vbNullString
                    .TextMatrix(AddBuddy, 4) = vbNullString
                    .TextMatrix(AddBuddy, 5) = vbNullString
                    .TextMatrix(AddBuddy, 6) = vbNullString
                    .TextMatrix(AddBuddy, 7) = vbNullString
                End If
            End With
        End If
    End If
    
End Function


Public Function Quality(intValue As Integer) As String

    Select Case intValue
        Case Is < 128
            Quality = "]"
        Case Is = 128
            Quality = "]]"
        Case 129 To 159
            Quality = "]]]"
        Case 160 To 180
            Quality = "]]]]"
        Case 181 To 192
            Quality = "]]]]]"
        Case 193 To 220
            Quality = "]]]]]]"
        Case 221 To 256
            Quality = "]]]]]]]"
        Case Is > 256
            Quality = "]]]]]]]]"
    End Select

End Function

Public Sub Wait(Delay As Single)

    Dim sngTimer            As Single
    
    sngTimer = Timer
    Do
        DoEvents
    Loop Until sngTimer + Delay < Timer
    
End Sub

Public Function WorkOutRate(dblStartPoint As Double, lngByteCount As Long) As String
    'just maths
    
    On Local Error Resume Next

    Dim lngSecondsPassed            As Long
    Dim lngbytesPerSec              As Long

    WorkOutRate = "?"
    lngSecondsPassed = CLng(GetNow - dblStartPoint)
    If lngByteCount > 0 And lngSecondsPassed > 0 Then
        lngbytesPerSec = lngByteCount / lngSecondsPassed
        If lngbytesPerSec > 0 Then
            WorkOutRate = Format(lngbytesPerSec / 1000, "#,###,##0.00")
        End If
    End If

End Function


Public Function OpenFile(ByRef FileName As String, ByRef FileNumber As Integer) As Integer

    On Local Error GoTo errOpenFile

    Dim errNo               As Integer
    Dim intLoop             As Integer
    Dim strFileName         As String
    
    OpenFile = 0
    errNo = 0
    FileNumber = FreeFile
    strFileName = FileName
    Open FileName For Append As FileNumber
    If errNo Then
        For intLoop = 1 To 20
            errNo = 0
            FileNumber = FreeFile
            strFileName = Mid(FileName, 1, InStrRev(FileName, ".") - 1) & " (" & intLoop & ")." & Right(FileName, 3)
            Open strFileName For Append As FileNumber
            If errNo = 0 Then OpenFile = 1: Exit For
        Next intLoop
    Else
        OpenFile = 1
    End If
    If OpenFile = 0 Then FileName = strFileName
    
Exit Function

errOpenFile:
    errNo = Err.Number
    Resume Next
    
End Function

Public Function PlayFile(lngKey As Long, Optional Path As String = vbNullString)

    Dim strPath             As String
    Dim rsTrackData         As DAO.Recordset
    Dim lngLength           As Long
            
    Set rsTrackData = dbs.OpenRecordset("SELECT tblTracks.[Full Path], tblTracks.[Track Length], tblTracks.[Track Name], tblArtist.[Artist Name] FROM tblTracks INNER JOIN tblArtist ON tblTracks.ArtistID = tblArtist.ArtistID WHERE TrackID = " & lngKey, dbOpenSnapshot, dbOpenForwardOnly)
    If Not rsTrackData.EOF Then
        strPath = rsTrackData![Full Path]
        lngLength = rsTrackData![Track Length]
        dbs.Execute "UPDATE tblTracks SET [Times Played] = [Times Played] + 1, [Last Played] = " & DateDiff("d", "01/01/1998", Now) & " WHERE TrackID = " & lngKey
        Amp.wPlayNOW strPath
        mdiMain.sldTrack.Max = lngLength
        mdiMain.lblTrack.Caption = rsTrackData![Artist Name] & " - " & rsTrackData![Track Name] & "  [" & Format(lngLength \ 60, "00") & ":" & Format(lngLength Mod 60, "00") & "]"
    End If
    Set rsTrackData = Nothing

End Function

Public Function FormatTime(lngTime As Long) As String
    If lngTime = 0 Then FormatTime = "var": Exit Function
    FormatTime = Format(lngTime \ 60, "#0") & ":" & Format(lngTime Mod 60, "00")
End Function

Public Sub UpdatePlaylistCombo(Optional lngID As Long = 1)

    Dim lngPoint                As Long
    Dim intPoint                As Integer

    With frmDatabase.cmbPlaylist
        .Enabled = False
        .Clear
        With dbs.OpenRecordset("SELECT * FROM tblPlaylists ORDER BY [Playlist Name] ASC", dbOpenSnapshot, dbOpenForwardOnly)
            Do While Not .EOF
                If lngID = ![PlayListID] Then lngPoint = intPoint
                frmDatabase.cmbPlaylist.AddItem ![PlayList Name] & Space(60) & ![PlayListID]
                .MoveNext
                intPoint = intPoint + 1
            Loop
        End With
        If lngPoint >= 0 Then .ListIndex = lngPoint
        .Enabled = True
    End With
    
End Sub

Public Function InsertTrack(ByRef strArtist As String, strTrack As String) As Long

    Dim lngArtistID             As Long
    Dim strSqlExecute           As String
    Dim lngCount                As Long
    
    strTrack = StrConv(deCrap(strTrack), vbProperCase)
    strArtist = StrConv(deCrap(strArtist), vbProperCase)
    lngArtistID = GetArtistID(strArtist)
        
    lngCount = dbs.OpenRecordset("SELECT COUNT(*) FROM tblTracks WHERE ArtistID = " & lngArtistID & " AND [Track Name] = '" & strTrack & "'", dbOpenSnapshot, dbOpenForwardOnly).Fields(0).Value
    If lngCount Then InsertTrack = -1: Exit Function
    lngCount = dbs.OpenRecordset("SELECT COUNT(*) FROM tblIncomplete WHERE ArtistID = " & lngArtistID & " AND [Track Name] = '" & strTrack & "'", dbOpenSnapshot, dbOpenForwardOnly).Fields(0).Value
    If lngCount Then InsertTrack = -2: Exit Function
    
    InsertTrack = 0
    strSqlExecute = "INSERT INTO tblIncomplete (ArtistID, [Track Name], [Bytes So Far], [Expected Size], [Full Path]) VALUES (" & lngArtistID & ",'" & strTrack & "',0,0,'???')"
    dbs.Execute strSqlExecute
       
    
End Function
