#ifndef D2_STRUCTS_H
#define D2_STRUCTS_H

#define CELLNO_MYSHRINES 1176
#define CELLNO_WAYPOINT 307
#define CELLNO_SHRINE 310
#define NUMOF_SHRINES 23

#define ITEMFLAG_SOCKETED 0x800
#define ITEMFLAG_ETHEREAL 0x400000
#define OBJ_CHEST_LOCKED 0x80


//d2 structures etc

enum UIVar {
	UIVAR_UNK0 = 0, // always 1
	UIVAR_INVENTORY = 1, // hotkey 'B'
	UIVAR_STATS = 2, // hotkey 'C'
	UIVAR_CURRSKILL = 3, // left or right hand skill selection
	UIVAR_SKILLS = 4, // hotkey 'T'
	UIVAR_CHATINPUT = 5, // chat with other players, hotkey ENTER
	UIVAR_NEWSTATS = 6, // new stats button
	UIVAR_NEWSKILL = 7, // new skills button
	UIVAR_INTERACT = 8, // interact with NPC
	UIVAR_GAMEMENU = 9, // hotkey ESC
	UIVAR_ATUOMAP = 10, // hotkey TAB
	UIVAR_CFGCTRLS = 11, // config control key combination
	UIVAR_NPCTRADE = 12, // trade, game, repair with NPC
	UIVAR_SHOWITEMS = 13, // hotkey ALT
	UIVAR_MODITEM = 14, // add socket, imbue item
	UIVAR_QUEST = 15, // hotkey 'Q'
	UIVAR_UNK16 = 16,
	UIVAR_NEWQUEST = 17, // quest log button on the bottom left screen
	UIVAR_UNK18 = 18, // lower panel can not redraw when set
	UIVAR_UNK19 = 19, // init 1
	UIVAR_WAYPOINT = 20,
	UIVAR_MINIPANEL = 21,
	UIVAR_PARTY = 22, // hotkey 'P'
	UIVAR_PPLTRADE = 23, // trade, exchange items with other player
	UIVAR_MSGLOG = 24,
	UIVAR_STASH = 25,
	UIVAR_CUBE = 26,
	UIVAR_UNK27 = 27,
	UIVAR_INVENTORY2 = 28,
	UIVAR_INVENTORY3 = 29,
	UIVAR_INVENTORY4 = 30,
	UIVAR_BELT = 31,
	UIVAR_UNK32 = 32,
	UIVAR_HELP = 33, // help scrren, hotkey 'H'
	UIVAR_UNK34 = 34,
	UIVAR_UNK35 = 35, // init 1
	UIVAR_PET = 36, // hotkey 'O'
	UIVAR_QUESTSCROLL = 37, // for showing quest information when click quest item.
};


enum UnitStat {
	STAT_LIFE		= 0x06,
	STAT_MAXLIFE	= 0x07,
	STAT_LEVEL		= 0x0c,
	STAT_GOLD		= 0x0e,
	STAT_MAGIC_DAMAGE_REDUCED = 0x23,
	STAT_DAMAGE_REDUCED = 0x24,
	STAT_MAGIC_RESIST = 0x25,
	STAT_FIRE_RESIST = 0x27,
	STAT_LIGHTING_RESIST = 0x29,
	STAT_COLD_RESIST = 0x2B,
	STAT_POSION_RESIST = 0x2D,
	STAT_LIFE_LEECH = 0x3c,
	STAT_MANA_LEECH	= 0x3e,
	STAT_EXTRA_GOLD = 0x4f,
	STAT_MAGIC_FIND = 0x50,
	STAT_IAS		= 0x5d,
	STAT_FRW		= 0x60,
	STAT_FHR		= 0x63,
	STAT_FBR		= 0x66,
	STAT_FCR		= 0x69,
	STAT_DAMAGE_TAKEN_GOES_TO_MANA = 0x72,
	STAT_CRUSHING_BLOW = 0x88,
	STAT_MANA_AFTER_EACH_KILL = 0x8a,
	STAT_FIRE_ABSORB = 0x8f,
	STAT_LIGHTING_ABSORB = 0x91,
	STAT_COLD_ABSORB = 0x94,
	STAT_NUMSOCKETS	= 0xc2,
	STAT_UNK1		= 0x100,
	STAT_MAGIC_ABSORB = 0,
	STAT_DEADLY_STRIKE = 0,
	STAT_PIERCING_ATTACK = 0,
	STAT_BLESSED_AIM = 0,
	STAT_REGENERATE_MANA = 0
};

enum UnitNo {
	UNITNO_PLAYER	= 0,
	UNITNO_MONSTER	= 1,
	UNITNO_OBJECT	= 2,
	UNITNO_MISSILE	= 3,
	UNITNO_ITEM		= 4,
	UNITNO_ROOMTILE	= 5
};

struct DrlgRoom2;
struct DrlgLevel;
struct DrlgMisc;
struct DrlgAct;
struct UnitAny;

struct D2Seed {
	DWORD d1,d2;
};

struct PresetUnit_110 {
	DWORD nUnitType; //+00
	DWORD nTxtFileNo; //+04
	DWORD _1[1];
	DWORD xPos; //+0c
	DWORD yPos; //+10
	DWORD _2[2];
	PresetUnit_110 *pNext; //+1c
};

struct PresetUnit {
	DWORD _1[2];
	DWORD yPos; //+08
	DWORD nTxtFileNo; //+0c
	DWORD _2[1];
	PresetUnit *pNext; //+1c
	DWORD xPos; //+20
	DWORD nUnitType; //+24
};

struct RoomTile_110 {
	DrlgRoom2 *pRoom2; //+00
	DWORD *nNum; //+04
	DWORD _1[3];
	RoomTile_110 *pNext; //+14
};

struct RoomTile {
	DWORD _1;
	DrlgRoom2 *pRoom2; //+04
	RoomTile *pNext; //+08
	DWORD *nNum; //+0c
};

struct DrlgRoom1_110 {
	DWORD xpos1; //+00
	DWORD ypos1; //+04
	DWORD xsize1; //+08
	DWORD ysize1; //+0c
	DWORD xpos2; //+10
	DWORD ypos2; //+14
	DWORD xsize2; //+18
	DWORD ysize2; //+1c
	DWORD _1[1];
	DrlgRoom1_110 **paRoomsNear; //+24
	DWORD nRoomsNear; //+28;
	UnitAny *pUnitFirst; //+2c
	DWORD _2[2];
	DrlgRoom2 *pRoom2; //+38
	D2Seed seed; //+3c
	DWORD _3[14];
	DrlgRoom1_110 *pNext; // +7c
};

struct DrlgRoom1 {
	D2Seed seed; //+00
	DWORD xpos1; //+08
	DWORD ypos1; //+0c
	DWORD xsize1; //+10
	DWORD ysize1; //+14
	DWORD xpos2; //+18
	DWORD ypos2; //+1c
	DWORD xsize2; //+20
	DWORD ysize2; //+24
	DWORD _2[3];
	DrlgRoom1 **paRoomsNear; //+34
	DrlgRoom2 *pRoom2; //+38
	UnitAny *pUnitFirst; //+3c
	DWORD _3[13];
	DrlgRoom1 *pNext; // +74
	DWORD _4;
	DWORD nRoomsNear; //+7c
};

struct DrlgRoom2_110 {
	DrlgLevel *pDrlgLevel; //+00
	DWORD xPos; //+04
	DWORD yPos; //+08
	DWORD xPos1; // +0c
	DWORD yPos1; // +10
	DWORD _1[2];
	DWORD nPresetType; //+1c
	DWORD *nPresetType2No; //+20
	DWORD _2[39];
	DrlgRoom2 **paRoomsNear; //+c0
	DWORD nRoomsNear; //+c4
	RoomTile *pRoomTiles; //+c8
	PresetUnit *pPresetUnits; //+cc
	DWORD _3[1];
	D2Seed seed; //+d4
	DWORD _3b[2];
	DrlgRoom1 *pRoom1; //+e4
	DrlgRoom2 *pNext; //+e8
};

struct DrlgRoom2 {
	RoomTile *pRoomTiles; //
	DWORD _1[1];
	DWORD nPresetType; //+8
	DWORD _2[1];
	DWORD nRoomsNear; //+10
	DWORD _2a[2];
	DrlgLevel *pDrlgLevel; //+1c
	DWORD xPos; //+20
	DWORD yPos; //+24
	DWORD xPos1; //+28
	DWORD yPos1; //+2c
	DrlgRoom2 **paRoomsNear; //+30
	PresetUnit *pPresetUnits; //+34
	DrlgRoom2 *pNext; //+38
	DWORD _4[38];
	D2Seed seed; //+d4
	DWORD *nPresetType2No; //+dc
	DWORD _5[2];
	DrlgRoom1 *pRoom1; //+e8
};

struct DrlgLevel_110 {
	DrlgMisc *pDrlgMisc; //+00
	DWORD nLevelNo; //+04
	DWORD _1[3];
	D2Seed seed; //+14
	DWORD _2[5];
	DrlgRoom2 *pRoom2First; //+30
	DWORD _3[126];
	DrlgLevel *pLevelNext; //+22c
};

struct DrlgLevel { //sizeof(DrlgLevel) = 0x230
	DWORD _1[5];
	DWORD nLevelNo; //+14
	DWORD _1a[120];
	D2Seed seed; //+1f8
	DWORD _2[1];
	DrlgRoom2 *pRoom2First; //+204
	DrlgMisc *pDrlgMisc; //+208
	DWORD _3[8];
	DrlgLevel *pLevelNext; //+22c
};

struct DrlgMisc {
	DWORD _1[33];
	DrlgAct *pDrlgAct; //+84
	DWORD nBossTombLvl; //+88
	DWORD _2[248];
	DrlgLevel *pLevelFirst; //+46c
	DWORD _3[2];
	DWORD nStaffTombLvl; // +478
};

struct DrlgMisc_110 {
	DrlgLevel *pLevelFirst; //+00
	DWORD _1[2];
	DrlgAct *pDrlgAct; //+0c
	DWORD _2[250];
	DWORD nStaffTombLvl; // +3f8
	DWORD nBossTombLvl; //+3fc
};

struct DrlgMisc_109 {
	DrlgLevel *pLevelFirst; //+00
	DWORD _1[2];
	DrlgAct *pDrlgAct; //+0c
	DWORD _2[249];
	DWORD nStaffTombLvl; //+3f4
	DWORD nBossTombLvl; //+3f8
};

struct DrlgAct {
	DWORD _1;
	DrlgRoom1 *pRoom1; //+04
	DrlgMisc *pDrlgMisc; //+08
};

struct DrlgAct_109 {
	DWORD _1[2];
	DrlgMisc *pDrlgMisc; //+08
};

struct AutomapCell {
	DWORD fSaved; //+00
	WORD nCellNo; //+04
	WORD xPixel; //+06
	WORD yPixel; //+08
	WORD wWeight; //+a = -1, 0, 1
	AutomapCell *pLess; //+0c
	AutomapCell *pMore; //+10
};

struct AutomapLayer {
	DWORD nLayerNo;
	DWORD fSaved;
	AutomapCell *pFloors; //+08
	AutomapCell *pWalls; //+0c
	AutomapCell *pObjects; //+10
	AutomapCell *pExtras; //+14
	AutomapLayer *pNextLayer; // +18
};

struct AutomapLayer2 {
	DWORD _1[2];
	DWORD nLayerNo; //+08
};

struct ObjectTxt {
	char szName[0x40];	// +00
	wchar_t wszName[0x40]; // +40
	BYTE _1[4]; // +c0
	BYTE nSelectable0; //+c4
	BYTE _2[0x87];
	BYTE nOrientation; //+14c
	BYTE _2b[0x19];
	BYTE nSubClass; // +166
	BYTE _3[0x11];
	BYTE nParm0; //+178
	BYTE _4[0x39];
	BYTE nPopulateFn; //+1b2
	BYTE nOperateFn; //+1b3
	BYTE _5[8];
	DWORD nAutoMap; // +1bb
};

struct ObjectTxt_109 {
	BYTE _1[0xc4];
	BYTE nSelectable0; //+c4
	BYTE _2[0x87];
	BYTE nOrientation; //+14c
	BYTE _2b[0x2a];
	BYTE nSubClass; //+177
	BYTE _3[0x10];
	BYTE nParm0; //+188
	BYTE _4[0x39];
	BYTE nPopulateFn; //+1c2
	BYTE nOperateFn; //+1c3
	BYTE _5[8];
	DWORD nAutoMap; //+1cc
};

struct ObjgroupTxt {
	DWORD nId[8]; //+00
	BYTE nDensity[8]; //+20
	BYTE nProb[8]; //+28
};

struct LevelTxt {
	BYTE _1[0xf5];
	char cszName[40]; //+f5
	char cszName2[40]; //+11d
	char szLvlDesc[41]; //+145
	wchar_t szName[40]; //+16e
	wchar_t szName2[40]; //+16e
	BYTE nObjGrp[8]; // unk
	BYTE nObjPrb[8]; // unk
	BYTE _1b[0x79];
};

struct LevelTxt_109 {
	BYTE _1[0x18d];
	BYTE nObjGrp[8]; //+18d
	BYTE nObjPrb[8]; //+195
	BYTE _1b[0x79];
	wchar_t szName[40]; //+216
};

struct ItemTxt {
	wchar_t szName2[0x40]; //+00
	union {
		DWORD dwCode; // +80
		char szCode[4];
	};
	BYTE _2[0x70]; // +84
	WORD nLocaleTxtNo; // +f4
	BYTE _2a[0x28]; // +f6
	BYTE nType; // +11e
	BYTE _3[0x0d];
	BYTE fQuest; // +12a
};

struct ItemTxt_109 {
	char szName[0x40]; //+00
	wchar_t szName2[0x40]; //+40
	BYTE _1[0x84];
	union {
		DWORD dwCode; //+144
		char szCode[4];
	};
	BYTE _2[0x6b];
	BYTE nType; //+1b3
	BYTE _3[4];
	BYTE fQuest; //+1b8
};

struct MonsterTxt {
	BYTE _1[0x6];
	WORD nLocaleTxtNo; // +06
	WORD flag; // +08
	WORD _1a;
	union {
		DWORD flag1; // +0c
		struct {
			BYTE flag1a; // +0c
			BYTE flag1b; // +0d
			BYTE flag1c[2]; // +0e
		};
	};
	BYTE _2[0x22]; // +10
	WORD velocity; // +32
	BYTE _2a[0x52]; // +34
	WORD tcs[3][4]; //+86
	BYTE _2b[0x52]; // +9e
	wchar_t szDescriptor[0x3c]; //+f0
	BYTE _3[0x1a0];
};

struct MonsterTxt_109 {
	BYTE _1[0xf0];
	wchar_t szDescriptor[0x3c]; //+f0
	BYTE _2[0x1a0];
	DWORD tcs[3][4]; //+308
};

struct SuperuniqueTxt {
	WORD nIndex; //+00
	WORD nLocaleTxtNo; //+02
	DWORD _1[9]; //+04
	BYTE _1a[4]; //+28
	WORD tcs[4]; //+2c
};

struct SuperuniqueTxt_109 {
	BYTE _1[0xd8];
	DWORD tcs[3]; //+d8
};

struct PlayerData {
	wchar_t szName[1]; //+00
};


struct MonsterData {
	BYTE _1[0x16];
	struct {
		BYTE fUnk:1;
		BYTE fNormal:1;
		BYTE fChamp:1;
		BYTE fBoss:1;
		BYTE fMinion:1;
	}; //+16
	BYTE _1aa;
	wchar_t szName[1]; //+18
	BYTE _1a[2]; // +1a
	BYTE anEnchants[9]; // +1c
	BYTE _2a; // +25
	WORD uniqueno; // +26
	BYTE _2[50*4-14];
	struct {
		DWORD _3[1];
		WORD uniqueno; //+04
		WORD _4[1];
		DWORD anEnchants[9]; //+08
	} *pEnchants; //+cc
};

struct MonsterData_109 {
	struct {
		WORD fBoss:1;
		WORD fMinion:1;
		WORD fChamp:1;
	}; //+00
	wchar_t szName[1]; //+02
	DWORD _2[50];
	struct {
		DWORD _3[1];
		WORD uniqueno; //+04
		WORD _4[1];
		DWORD anEnchants[9]; //+08
	} *pEnchants; //+cc
};

struct ObjectData {
	ObjectTxt *pTxtFile; //+00 ??
	union {
		BYTE nShrineNo;
		struct {
			BYTE _1:7;
			BYTE fChestLocked:1;
		};
	}; //+04
};

struct ItemData {
	DWORD nQuality;
	BYTE _1[0x14]; // +04
	DWORD nFlag; // +18
	BYTE _2[0x10]; // +1c
	DWORD nItemLevel; // +2c
	BYTE _3[0x14]; // +30
	BYTE nLocation1; // +44					// location on body = xpos of item (only if on body) (spread)
	BYTE nLocation2; // +45					// 0 = inventory, 4=stash (spread)
};

struct ItemData_109 {
	DWORD nQuality;
};

struct UnitInventory {
	DWORD nFlag; //+00
	void* pGame2; //+04 ptGame+1c
	UnitAny *pUnit;
	DWORD nItem; //+0c
};

struct ObjectPath {
	DWORD xpos1; //+00
	DWORD ypos1; //+04
	DWORD xpos2; //+08
	DWORD ypos2; //+0c
	WORD targetx; //+10
	WORD targety; //+12
	DWORD _1[2];
	DrlgRoom1 *pRoom1; //+1c
	DWORD _2[14];
	UnitAny *pTargetUnit; //+58
};
struct ItemPath {
	void * ptRoom;				// 0x00
	DWORD _1[2];				// 0x04
	DWORD xpos;				// 0x0C
	DWORD ypos;				// 0x10
	DWORD _2[5];				// 0x14
	BYTE * ptUnk;				// 0x28
	DWORD _3[5];				// 0x2C
};
struct UnitAny {
	DWORD nUnitType; //+00
	DWORD nTxtFileNo; //+04
	DWORD _1;
	DWORD nUnitId; // +0C
	DWORD eMode; // +10
	union {
		PlayerData *pPlayerData; //+14
		MonsterData *pMonsterData; //+14
		ObjectData *pObjectData; //+14
		ItemData *pItemData; //+14
	};
	DWORD _2;
	UnitAny *pNext; //+1c
	WORD _2a0;
	WORD unkNo;
	DWORD _2a[2];
	union {
		ObjectPath *pPos;
		ItemPath *pItemPath;
	};
	//struct {
	//	DWORD xpos1; //+00
	//	DWORD ypos1; //+04
	//	DWORD xpos2; //+08
	//	DWORD ypos2; //+0c
	//	WORD targetx; //+10
	//	WORD targety; //+12
	//	DWORD _1[2];
	//	DrlgRoom1 *pRoom1; //+1c
	//	DWORD _2[14];
	//	UnitAny *pTargetUnit; //+58
	//} *pPos; // +2c
	DWORD _2b[12];
	UnitInventory *pInventory; //+60
	DWORD _3[7];
	UnitAny *pNextPlayer; //+80
	DWORD _4b[4];
	DWORD nOwnerType; // +94
	DWORD nOwnerId; // +98
	BYTE _4c[42];
	BYTE  fFlags0:1; //+0c6, new added
	BYTE _4d;
	DWORD _5[10];
	DWORD fFlags; //+e8
	DWORD fFlags2; //+ec
	DWORD _6[7];
};

struct UnitAny_Heavy {
	DWORD nUnitType; //+00
	DWORD nTxtFileNo; //+04 Unit Id
	DWORD nInventoryId; //+08
	DWORD nUnitId; // +0C Unit unid
	DWORD eMode; // +10 Current Animation Mode
	union {
		PlayerData *pPlayerData; //+14
		MonsterData *pMonsterData; //+14
		ObjectData *pObjectData; //+14
		ItemData *pItemData; //+14
	};
	DrlgAct *pAct; //+18
	UnitAny *pNext; //+1c
	WORD _2a0;
	WORD unkNo; //+22
	DWORD _2a[2];
	union {
		ObjectPath *pPos; //+2c
		ItemPath *pItemPath; //+2c
	};
	//struct {
	//	DWORD xpos1; //+00
	//	DWORD ypos1; //+04
	//	DWORD xpos2; //+08
	//	DWORD ypos2; //+0c
	//	WORD targetx; //+10
	//	WORD targety; //+12
	//	DWORD _1[2];
	//	DrlgRoom1 *pRoom1; //+1c
	//	DWORD _2[14];
	//	UnitAny *pTargetUnit; //+58
	//} *pPos; // +2c
	UnitAny *pNextItem; //+30
	DWORD _2b[2];
	DWORD nAnimSpeed; //+3c
	DWORD _2c;
	DWORD nFrameCounter; //+44
	DWORD nLeftFrame; //+48
	WORD wAnimSpeed; //+4c
	BYTE bActionFlag; //+4e
	BYTE _2d;
	DWORD AnimData[3]; //+50
	void* pStatList; //+5c
	UnitInventory *pInventory; //+60
	DWORD _3[7];
	UnitAny *pNextPlayer; //+80
	DWORD _4b[4];
	DWORD nOwnerType; // +94
	DWORD nOwnerId; // +98
	BYTE _4c[42];
	BYTE  fFlags0:1; //+0c6, new added
	BYTE _4d;
	DWORD _5[10];
	DWORD fFlags; //+e8
	DWORD fFlags2; //+ec
	DWORD _6[7];
};


struct UnitAny_109 {
	DWORD nUnitType; //+00
	DWORD nTxtFileNo; //+04
	DWORD nUnitId; //+08
	DWORD eMode; //+0c
	DWORD _1[10];
	struct {
		DWORD xpos1; //+00
		DWORD ypos1; //+04
		DWORD xpos2; //+08
		DWORD ypos2; //+0c
		WORD targetx; //+10
		WORD targety; //+12
		DWORD _1[2];
		DrlgRoom1 *pRoom1; //+1c
		DWORD _2[14];
		UnitAny *pTargetUnit; //+58
	} *pPos; //+38
	DWORD _2[13];
	union {
		PlayerData *pPlayerData; //+70
		MonsterData *pMonsterData; //+70
		ObjectData *pObjectData; //+70
		ItemData *pItemData; //+70
	};
	DWORD _4a[4];
	UnitInventory *pInventory; //+84
	DWORD _4b[12];
	DWORD nOwnerType; //+b8
	DWORD nOwnerId; //+bc
	DWORD _5[10];
	DWORD fFlags; //+e8
	DWORD fFlags2; //+ec
	DWORD _6[7];
	UnitAny *pNext; //+10c
};

struct GfxCell {
	DWORD flags; //+00 ??
	DWORD width; //+04
	DWORD height; //+08
	DWORD xoffs; //+0c
	DWORD yoffs; //+10
	DWORD _2[1];
	DWORD lpParent; //+18
	DWORD length; //+1c
	BYTE cols[1]; //+20
};

struct CellFile {
	DWORD dwVersion; //+00
	struct {
		WORD dwFlags;
		BYTE mylastcol;
		BYTE mytabno:1;
	}; //+04
	DWORD eFormat; //+08
	DWORD termination; //+0c
	DWORD numdirs; //+10
	DWORD numcells; //+14
	GfxCell *cells[1]; //+18
};

struct CellContext_110 {
	GfxCell *hCell; //+00
	CellFile *pCellFile; //+04
	DWORD nCellNo; //+08
	DWORD direction; //+0c
	DWORD _1[14];
};

struct CellContext {
	DWORD direction; //+00
	GfxCell *hCell; //+04 ??
	CellFile *pCellFile; //+08
	DWORD _1[14];
	DWORD nCellNo; //+44
};

struct TreasureClassItem {
	DWORD _1[2];
	DWORD thingno; //+08
	struct {
		DWORD _3:2;
		DWORD tcflag:1;
	}; //+0c
	DWORD _2[3];
};

struct TreasureClass {
	DWORD _1a;
	DWORD numitems; //+04
	DWORD _1[8];
	TreasureClassItem *items; //+28
};

struct TreasureClass_109 {
	DWORD numitems; //+00
	DWORD _1[8];
	TreasureClassItem *items; //+24
};

struct D2EditBox2 {
	DWORD _1;
	DWORD _2[6];
	void (__fastcall *func)(D2EditBox2*); // +1c
	DWORD _3[0x0F];
	wchar_t* text;		// +5c
};
struct D2EditBox {
	DWORD _1;
	DWORD _2[6];
	void (__fastcall *func)(D2EditBox*); // +1c
	DWORD _3[0x0D];
	DWORD	dwSelectStart; // +54
	DWORD	dwSelectEnd; // +58
	wchar_t text[0x100];		// +5c
	DWORD	dwCursorPos;		// 0x25C
};

struct GameStructInfo
{
	DWORD _1[6];
	WORD _1a;
	char szGameName[0x18];
	char szGameServerIp[0x56];
	char szAccountName[0x30];
	char szCharName[0x18];
	char szRealmName[0x18];
	BYTE _2[0x157];
	char szGamePassword[0x18];
};

struct D2MSG {					// 0x20 bytes long
	HWND hwnd;				// 0x00
	DWORD message;				// 0x04
	WPARAM wParam;				// 0x08
	union {
		DWORD lParam;
		struct {
			WORD xpos;
			WORD ypos;
		};
	};
	DWORD _1;					// 0x10
	HWND hwnd2;				// 0x14
	DWORD _2[2];				// 0x18
};

struct FontInfo_t {
	DWORD hFontHandle;
	DWORD hMemHandle1;
	DWORD hMemHandle2;
	DWORD hMemHandle3;
	DWORD nLastTick;
};

struct PacketHandler_t {
	DWORD _1[2];
	DWORD fnHandler;
};

struct WardenClientRegion_t
{
	DWORD cbAllocSize; //+00
	DWORD offsetFunc1; //+04
	DWORD offsetRelocAddressTable; //+08
	DWORD nRelocCount; //+0c
	DWORD offsetWardenSetup; //+10
	DWORD _2[2];
	DWORD offsetImportAddressTable; //+1c
	DWORD nImportDllCount; //+20
	DWORD nSectionCount; //+24
};

struct WardenClient_t {
	WardenClientRegion_t* pWardenRegion; //+00
	DWORD cbSize; //+04
	DWORD nModuleCount; //+08
	DWORD param; //+0c
	DWORD fnSetupWarden; //+10
};

struct WardenIATInfo_t
{
	DWORD offsetModuleName;
	DWORD offsetImportTable;
};

#define DATAPTR_TO_SMEMPTR(dptr) ((SMemBlock_t*)( ((DWORD)dptr)&(~0xFF)))
#define DATAPTR_TO_HDRSIZE(dptr) ( ((DWORD)dptr) & 0xFF)
struct SMemBlock_t {
	DWORD _1[6];
	DWORD cbSize; //+18
	DWORD _2[31];
	BYTE data[1]; //+98
};
#endif // D2_STRUCTS_H
